/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.Container;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.WebContext;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.Handler;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.PageNormalizer;
import org.directwebremoting.extend.RealScriptSession;
import org.directwebremoting.extend.ScriptBufferUtil;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.extend.ScriptSessionManager;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.util.Continuation;
import org.directwebremoting.util.DebuggingPrintWriter;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class PollHandler
implements Handler {
    private boolean pollAndCometEnabled = false;
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    private boolean plain;
    private PageNormalizer pageNormalizer;
    protected ServerLoadMonitor serverLoadMonitor = null;
    protected ConverterManager converterManager = null;
    protected ScriptSessionManager scriptSessionManager = null;
    public static final String ATTRIBUTE_PARAMETERS = "org.directwebremoting.dwrp.parameters";
    public static final String ATTRIBUTE_CALL_ID = "org.directwebremoting.dwrp.callId";
    public static final String ATTRIBUTE_SESSION_ID = "org.directwebremoting.dwrp.sessionId";
    public static final String ATTRIBUTE_PAGE = "org.directwebremoting.dwrp.page";
    public static final String ATTRIBUTE_PARTIAL_RESPONSE = "org.directwebremoting.dwrp.partialResponse";
    public static final String ATTRIBUTE_LONGPOLL_SESSION_ID = "org.directwebremoting.dwrp.longPollSessionId";
    protected static final Logger log = Logger.getLogger(class$org$directwebremoting$dwrp$PollHandler == null ? (class$org$directwebremoting$dwrp$PollHandler = PollHandler.class$("org.directwebremoting.dwrp.PollHandler")) : class$org$directwebremoting$dwrp$PollHandler);
    static /* synthetic */ Class class$org$directwebremoting$extend$ServerLoadMonitor;
    static /* synthetic */ Class class$org$directwebremoting$dwrp$PollHandler;

    public PollHandler(boolean plain) {
        this.plain = plain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebContext webContext = WebContextFactory.get();
        Container container = webContext.getContainer();
        boolean isGet = request.getMethod().equals("GET");
        Map parameters = (Map)request.getAttribute(ATTRIBUTE_PARAMETERS);
        if (parameters == null) {
            try {
                parameters = isGet ? ParseUtil.parseGet(request) : ParseUtil.parsePost(request);
                request.setAttribute(ATTRIBUTE_PARAMETERS, (Object)parameters);
            }
            catch (Exception ex) {
                this.sendBatchExceptionResponse(response, null, ex);
                return;
            }
        }
        String batchId = this.extractParameter(request, parameters, ATTRIBUTE_CALL_ID, "batchId");
        String scriptId = this.extractParameter(request, parameters, ATTRIBUTE_SESSION_ID, "scriptSessionId");
        String page = this.extractParameter(request, parameters, ATTRIBUTE_PAGE, "page");
        String prString = this.extractParameter(request, parameters, ATTRIBUTE_PARTIAL_RESPONSE, "partialResponse");
        boolean partialResponse = Boolean.valueOf(prString);
        if (!this.pollAndCometEnabled) {
            this.sendNoPollingResponse(response, batchId);
            return;
        }
        if (!this.allowGetForSafariButMakeForgeryEasier && isGet) {
            this.sendBatchExceptionResponse(response, batchId, new SecurityException("GET Disallowed"));
            return;
        }
        String normalizedPage = this.pageNormalizer.normalizePage(page);
        webContext.setCurrentPageInformation(normalizedPage, scriptId);
        RealScriptSession scriptSession = (RealScriptSession)webContext.getScriptSession();
        ServerLoadMonitor monitor = (ServerLoadMonitor)container.getBean((class$org$directwebremoting$extend$ServerLoadMonitor == null ? (class$org$directwebremoting$extend$ServerLoadMonitor = PollHandler.class$("org.directwebremoting.extend.ServerLoadMonitor")) : class$org$directwebremoting$extend$ServerLoadMonitor).getName());
        long postStreamWaitTime = monitor.getPostStreamWaitTime();
        long preStreamWaitTime = monitor.getPreStreamWaitTime();
        if (!partialResponse) {
            postStreamWaitTime = 100L;
            preStreamWaitTime += postStreamWaitTime;
        }
        if (preStreamWaitTime > 0L || postStreamWaitTime > 0L) {
            this.notifyThreadsFromSameBrowser(request, scriptId);
        }
        try {
            this.serverLoadMonitor.threadWaitStarting();
            if (preStreamWaitTime > 0L && !scriptSession.hasWaitingScripts()) {
                Object lock;
                Object object = lock = scriptSession.getScriptLock();
                synchronized (object) {
                    Continuation continuation = new Continuation(request);
                    if (continuation.isAvailable()) {
                        if (!this.sleepWithContinuation(scriptSession, continuation, preStreamWaitTime)) {
                            this.sleepWithNotify(scriptSession, lock, preStreamWaitTime);
                        }
                    } else {
                        this.sleepWithNotify(scriptSession, lock, preStreamWaitTime);
                    }
                }
            }
            response.setContentType("text/plain");
            PrintWriter out = log.isDebugEnabled() ? new DebuggingPrintWriter("", response.getWriter()) : response.getWriter();
            PollScriptConduit conduit = new PollScriptConduit(out, response);
            if (out instanceof DebuggingPrintWriter) {
                DebuggingPrintWriter dpw = (DebuggingPrintWriter)out;
                dpw.setPrefix("out(" + conduit.hashCode() + "): ");
            }
            try {
                scriptSession.addScriptConduit(conduit);
                if (postStreamWaitTime > 0L) {
                    try {
                        Thread thread = Thread.currentThread();
                        String oldName = thread.getName();
                        thread.setName("DWR:Poll:PostStreamWait:" + postStreamWaitTime);
                        Thread.sleep(postStreamWaitTime);
                        thread.setName(oldName);
                    }
                    catch (InterruptedException ex) {
                        log.warn("Interupted", ex);
                    }
                }
                ScriptBuffer script = new ScriptBuffer();
                try {
                    int wait = this.serverLoadMonitor.getTimeToNextPoll();
                    Integer data = new Integer(wait);
                    EnginePrivate.remoteHandleCallback(conduit, batchId, "0", data);
                }
                catch (Exception ex) {
                    EnginePrivate.remoteHandleException(conduit, batchId, "0", ex);
                    log.warn("--Erroring: batchId[" + batchId + "] message[" + ex.toString() + ']', ex);
                }
                scriptSession.addScript(script);
            }
            finally {
                scriptSession.removeScriptConduit(conduit);
            }
        }
        finally {
            this.serverLoadMonitor.threadWaitEnding();
        }
    }

    protected void sendNoPollingResponse(HttpServletResponse response, String batchId) throws IOException {
        log.error("Polling and Comet are disabled. To enable them set the init-param pollAndCometEnabled to true. See http://getahead.ltd.uk/dwr/server/servlet for more.");
        String script = EnginePrivate.getRemotePollCometDisabledScript(batchId);
        this.sendScript(response, script);
    }

    protected void sendBatchExceptionResponse(HttpServletResponse response, String batchId, Exception ex) throws IOException {
        String script = EnginePrivate.getRemoteHandleBatchExceptionScript(batchId, ex);
        this.sendScript(response, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyThreadsFromSameBrowser(HttpServletRequest request, String scriptId) {
        String otherScriptSessionId = (String)request.getSession().getAttribute(ATTRIBUTE_LONGPOLL_SESSION_ID);
        if (otherScriptSessionId != null) {
            Object lock;
            RealScriptSession previousSession = this.scriptSessionManager.getScriptSession(otherScriptSessionId);
            Object object = lock = previousSession.getScriptLock();
            synchronized (object) {
                lock.notifyAll();
            }
        }
        request.getSession().setAttribute(ATTRIBUTE_LONGPOLL_SESSION_ID, (Object)scriptId);
    }

    protected String extractParameter(HttpServletRequest request, Map parameters, String attrName, String paramName) {
        String id = (String)request.getAttribute(attrName);
        if (id == null) {
            id = (String)parameters.remove(paramName);
            request.setAttribute(attrName, (Object)id);
        }
        if (id == null) {
            throw new IllegalArgumentException(Messages.getString("PollHandler.MissingParameter", paramName));
        }
        return id;
    }

    protected void sendScript(HttpServletResponse response, String script) throws IOException {
        PrintWriter out = response.getWriter();
        if (this.plain) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html");
        }
        this.sendScript(out, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendScript(PrintWriter out, String script) throws IOException {
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            if (!this.plain) {
                out.println("<html><body><script type='text/javascript'>");
            }
            out.println("//#DWR-START#");
            out.println(script);
            out.println("//#DWR-END#");
            if (!this.plain) {
                out.println("</script></body></html>");
            }
            if (out.checkError()) {
                throw new IOException("Error flushing buffered stream");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleepWithNotify(RealScriptSession scriptSession, Object lock, long preStreamWaitTime) throws IOException {
        NotifyOnlyScriptConduit listener = new NotifyOnlyScriptConduit(lock);
        try {
            scriptSession.addScriptConduit(listener);
            try {
                Thread thread = Thread.currentThread();
                String oldName = thread.getName();
                thread.setName("DWR:Poll:PreStreamWait:" + preStreamWaitTime);
                lock.wait(preStreamWaitTime);
                thread.setName(oldName);
            }
            catch (InterruptedException ex) {
                log.warn("Interupted", ex);
            }
        }
        finally {
            scriptSession.removeScriptConduit(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sleepWithContinuation(RealScriptSession scriptSession, Continuation continuation, long preStreamWaitTime) {
        ScriptConduit listener = null;
        try {
            listener = (ScriptConduit)continuation.getObject();
            if (listener == null) {
                listener = new ResumeContinuationScriptConduit(continuation);
                continuation.setObject(listener);
            }
            scriptSession.addScriptConduit(listener);
            continuation.suspend(preStreamWaitTime);
        }
        catch (Exception ex) {
            Continuation.rethrowIfContinuation(ex);
            log.warn("Exception", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (listener != null) {
                scriptSession.removeScriptConduit(listener);
            }
        }
        return true;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setPageNormalizer(PageNormalizer pageNormalizer) {
        this.pageNormalizer = pageNormalizer;
    }

    public void setScriptSessionManager(ScriptSessionManager scriptSessionManager) {
        this.scriptSessionManager = scriptSessionManager;
    }

    public void setPollAndCometEnabled(boolean pollAndCometEnabled) {
        this.pollAndCometEnabled = pollAndCometEnabled;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ResumeContinuationScriptConduit
    extends ScriptConduit {
        private final Continuation continuation;

        protected ResumeContinuationScriptConduit(Continuation continuation) {
            super(10);
            this.continuation = continuation;
        }

        public boolean addScript(ScriptBuffer script) {
            try {
                this.continuation.resume();
            }
            catch (Exception ex) {
                log.warn("Exception in continuation.resume()", ex);
            }
            return false;
        }

        public void flush() {
        }
    }

    private static final class NotifyOnlyScriptConduit
    extends ScriptConduit {
        private final Object lock;

        protected NotifyOnlyScriptConduit(Object lock) {
            super(10);
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addScript(ScriptBuffer script) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (Exception ex) {
                log.warn("Failed to notify all ScriptSession users", ex);
            }
            return false;
        }

        public void flush() {
        }
    }

    private class PollScriptConduit
    extends ScriptConduit {
        private final HttpServletResponse response;
        private final PrintWriter out;

        protected PollScriptConduit(PrintWriter out, HttpServletResponse response) {
            super(5);
            this.out = out;
            this.response = response;
        }

        public boolean addScript(ScriptBuffer script) throws IOException, MarshallException {
            PollHandler.this.sendScript(this.out, ScriptBufferUtil.createOutput(script, PollHandler.this.converterManager));
            return true;
        }

        public void flush() throws IOException {
            this.out.flush();
            this.response.flushBuffer();
            if (this.out.checkError()) {
                throw new IOException("Error flushing buffered stream");
            }
        }
    }
}

