/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.server.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.WireFeedOutput;
import com.sun.syndication.propono.atom.common.Collection;
import com.sun.syndication.propono.atom.server.AtomException;
import com.sun.syndication.propono.atom.server.AtomNotFoundException;
import com.sun.syndication.propono.atom.server.AtomServlet;
import com.sun.syndication.propono.atom.server.impl.FileStore;
import com.sun.syndication.propono.utils.Utilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FileBasedCollection
extends Collection {
    private String baseDir = null;
    private String handle = null;
    private String singular = null;
    private String collection = null;
    private String appuri = null;
    private static final String FEED_TYPE = "atom_1.0";

    public FileBasedCollection(String title, String handle, String collection, String singular, String baseDir, String accept, String appuri) {
        super(title, "text", appuri + "/" + handle + "/" + collection);
        this.handle = handle;
        this.collection = collection;
        this.singular = singular;
        this.baseDir = baseDir;
        this.appuri = appuri;
        this.setAccept(accept);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed getFeedDocument() throws AtomException {
        InputStream in = null;
        FileStore fileStore = FileStore.getFileStore();
        synchronized (fileStore) {
            in = FileStore.getFileStore().getFileInputStream(this.getFeedPath());
            if (in == null) {
                in = this.createDefaultFeedDocument(this.getHref());
            }
        }
        try {
            WireFeedInput input = new WireFeedInput();
            WireFeed wireFeed = input.build((Reader)new InputStreamReader(in));
            return (Feed)wireFeed;
        }
        catch (FeedException ex) {
            throw new AtomException(ex);
        }
    }

    public Entry addEntry(Entry entry) throws Exception {
        Feed f = this.getFeedDocument();
        String fsid = FileStore.getFileStore().getNextId();
        Entry storedEntry = this.updateAtomEntry(entry, fsid);
        this.updateFeedDocumentWithNewEntry(f, storedEntry);
        String entryPath = this.getEntryPath(fsid);
        OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
        AtomServlet.serializeEntry(storedEntry, os);
        os.flush();
        os.close();
        return storedEntry;
    }

    public Entry addMediaEntry(String title, String slug, String contentType, InputStream is) throws Exception {
        String fileName = this.createFileName(slug != null ? slug : title, contentType);
        File tempFile = File.createTempFile(fileName, "tmp");
        FileOutputStream fos = new FileOutputStream(tempFile);
        Utilities.copyInputToOutput(is, fos);
        fos.close();
        FileInputStream fis = new FileInputStream(tempFile);
        this.saveFile(fileName, contentType, tempFile.length(), fis);
        fis.close();
        File resourceFile = new File(this.getEntryMediaPath(fileName));
        Entry atomEntry = this.updateAtomResourceEntry(new Entry(), resourceFile);
        Feed f = this.getFeedDocument();
        this.updateFeedDocumentWithNewEntry(f, atomEntry);
        String entryPath = this.getEntryPath(fileName);
        OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
        AtomServlet.serializeEntry(atomEntry, os);
        os.flush();
        os.close();
        return atomEntry;
    }

    public Entry getEntry(String fileName) throws Exception {
        if (fileName.endsWith(".media-link")) {
            fileName = fileName.substring(0, fileName.length() - ".media-link".length());
        }
        String entryPath = this.getEntryPath(fileName);
        FileBasedCollection.checkExistence(entryPath);
        InputStream in = FileStore.getFileStore().getFileInputStream(entryPath);
        String filePath = this.getEntryMediaPath(fileName);
        File resource = new File(fileName);
        if (resource.exists()) {
            return this.loadAtomResourceEntry(in, resource);
        }
        return this.loadAtomEntry(in);
    }

    public Entry updateEntry(Entry entry, String fileName) throws Exception {
        Feed f = this.getFeedDocument();
        if (fileName.endsWith(".media-link")) {
            fileName = fileName.substring(0, fileName.length() - ".media-link".length());
        }
        Entry updatedAtomEntry = this.updateAtomEntry(entry, fileName);
        this.updateFeedDocumentWithExistingEntry(f, updatedAtomEntry);
        String entryPath = this.getEntryPath(fileName);
        OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
        AtomServlet.serializeEntry(updatedAtomEntry, os);
        os.flush();
        os.close();
        return updatedAtomEntry;
    }

    public Entry updateMediaEntry(String fileName, String contentType, InputStream is) throws Exception {
        File tempFile = File.createTempFile(fileName, "tmp");
        FileOutputStream fos = new FileOutputStream(tempFile);
        Utilities.copyInputToOutput(is, fos);
        fos.close();
        FileInputStream fis = new FileInputStream(tempFile);
        this.saveFile(fileName, contentType, tempFile.length(), fis);
        fis.close();
        File resourceFile = new File(this.getEntryMediaPath(fileName));
        String entryPath = this.getEntryPath(fileName);
        InputStream in = FileStore.getFileStore().getFileInputStream(entryPath);
        Entry atomEntry = this.loadAtomResourceEntry(in, resourceFile);
        Feed f = this.getFeedDocument();
        this.updateFeedDocumentWithExistingEntry(f, atomEntry);
        OutputStream os = FileStore.getFileStore().getFileOutputStream(entryPath);
        AtomServlet.serializeEntry(atomEntry, os);
        os.flush();
        os.close();
        return atomEntry;
    }

    public void deleteEntry(String fileName) throws Exception {
        if (fileName.endsWith(".media-link")) {
            fileName = fileName.substring(0, fileName.length() - ".media-link".length());
        }
        String entryId = this.appuri + "/" + this.handle + "/" + this.singular + "/" + fileName;
        Feed feed = this.getFeedDocument();
        this.updateFeedDocumentRemovingEntry(feed, entryId);
        String entryDir = this.getEntryDirPath(fileName);
        FileStore.getFileStore().deleteDirectory(entryDir);
    }

    private String getBaseDir() {
        return this.baseDir;
    }

    private String getFeedPath() {
        return this.getBaseDir() + File.separator + this.handle + File.separator + this.collection + File.separator + "feed.xml";
    }

    private String getEntryDirPath(String id) {
        return this.getBaseDir() + File.separator + this.handle + File.separator + this.collection + File.separator + id;
    }

    private String getEntryPath(String id) {
        return this.getEntryDirPath(id) + File.separator + "entry.xml";
    }

    private String getEntryMediaPath(String id) {
        return this.getEntryDirPath(id) + File.separator + "media" + File.separator + id;
    }

    private static void checkExistence(String path) throws AtomNotFoundException {
        if (!FileStore.getFileStore().exists(path)) {
            throw new AtomNotFoundException("Entry does not exist");
        }
    }

    private void updateFeedDocumentWithNewEntry(Feed f, Entry e) throws AtomException {
        f.getEntries().add(e);
        this.updateFeedDocument(f);
    }

    private void updateFeedDocumentRemovingEntry(Feed f, String id) throws AtomException {
        Entry e = this.findEntry(id, f);
        f.getEntries().remove(e);
        this.updateFeedDocument(f);
    }

    private void updateFeedDocumentWithExistingEntry(Feed f, Entry e) throws AtomException {
        Entry old = this.findEntry(e.getId(), f);
        f.getEntries().remove(old);
        f.getEntries().add(0, e);
        this.updateFeedDocument(f);
    }

    private Entry findEntry(String id, Feed f) {
        List l = f.getEntries();
        for (Entry e : l) {
            if (!id.equals(e.getId())) continue;
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFeedDocument(Feed f) throws AtomException {
        try {
            FileStore fileStore = FileStore.getFileStore();
            synchronized (fileStore) {
                WireFeedOutput wireFeedOutput = new WireFeedOutput();
                Document feedDoc = wireFeedOutput.outputJDom((WireFeed)f);
                XMLOutputter outputter = new XMLOutputter();
                outputter.setFormat(Format.getPrettyFormat());
                outputter.output(feedDoc, FileStore.getFileStore().getFileOutputStream(this.getFeedPath()));
            }
        }
        catch (FeedException fex) {
            throw new AtomException(fex);
        }
        catch (IOException ex) {
            throw new AtomException(ex);
        }
    }

    private InputStream createDefaultFeedDocument(String uri) throws AtomException {
        Feed f = new Feed();
        f.setTitle("Feed");
        f.setFeedType(FEED_TYPE);
        Link selfLink = new Link();
        selfLink.setRel("self");
        selfLink.setHref(uri);
        f.getOtherLinks().add(selfLink);
        try {
            WireFeedOutput wireFeedOutput = new WireFeedOutput();
            Document feedDoc = wireFeedOutput.outputJDom((WireFeed)f);
            XMLOutputter outputter = new XMLOutputter();
            outputter.setFormat(Format.getPrettyFormat());
            outputter.output(feedDoc, FileStore.getFileStore().getFileOutputStream(this.getFeedPath()));
        }
        catch (FeedException ex) {
            throw new AtomException(ex);
        }
        catch (IOException ex) {
            throw new AtomException(ex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return FileStore.getFileStore().getFileInputStream(this.getFeedPath());
    }

    private Entry loadAtomResourceEntry(InputStream in, File file) {
        try {
            Entry entry = AtomServlet.parseEntry(new BufferedReader(new InputStreamReader(in)));
            return this.updateAtomResourceEntry(entry, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Entry updateAtomResourceEntry(Entry entry, File file) {
        String editURI = this.appuri + "/" + this.handle + "/" + this.singular + "/" + file.getName() + ".media-link";
        String editMediaURI = this.appuri + "/" + this.handle + "/" + this.singular + "/" + file.getName();
        String viewURI = this.appuri + "/" + this.handle + "/" + this.collection + "/" + file.getName() + "/media/" + file.getName();
        FileTypeMap map = FileTypeMap.getDefaultFileTypeMap();
        if (map instanceof MimetypesFileTypeMap) {
            try {
                ((MimetypesFileTypeMap)map).addMimeTypes("image/png png PNG");
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        String contentType = map.getContentType(file.getName());
        entry.setId(editMediaURI);
        entry.setTitle(file.getName());
        entry.setUpdated(new Date());
        ArrayList<Link> otherlinks = new ArrayList<Link>();
        entry.setOtherLinks(otherlinks);
        Link editlink = new Link();
        editlink.setRel("edit");
        editlink.setHref(editURI);
        otherlinks.add(editlink);
        Link editMedialink = new Link();
        editMedialink.setRel("edit-media");
        editMedialink.setHref(editMediaURI);
        otherlinks.add(editMedialink);
        Content content = new Content();
        content.setSrc(viewURI);
        content.setType(contentType);
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.add(content);
        entry.setContents(contents);
        return entry;
    }

    private Entry loadAtomEntry(InputStream in) {
        try {
            return AtomServlet.parseEntry(new BufferedReader(new InputStreamReader(in)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Entry updateAtomEntry(Entry entry, String fsid) {
        String absUrl = this.appuri + "/" + this.handle + "/" + this.singular + "/" + fsid;
        entry.setId(absUrl);
        Link altlink = new Link();
        altlink.setRel("alternate");
        altlink.setHref(absUrl);
        ArrayList<Link> altlinks = new ArrayList<Link>();
        altlinks.add(altlink);
        entry.setAlternateLinks(altlinks);
        Link editlink = new Link();
        editlink.setRel("edit");
        editlink.setHref(this.appuri + "/" + this.handle + "/" + this.singular + "/" + fsid);
        ArrayList<Link> otherlinks = new ArrayList<Link>();
        otherlinks.add(editlink);
        entry.setOtherLinks(otherlinks);
        entry.setUpdated(new Date());
        return entry;
    }

    private void saveFile(String name, String contentType, long size, InputStream is) throws AtomException {
        byte[] buffer = new byte[8192];
        int bytesRead = 0;
        File dirPath = new File(this.getEntryMediaPath(name));
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        OutputStream bos = null;
        try {
            bos = new FileOutputStream(dirPath.getAbsolutePath() + File.separator + name);
            while ((bytesRead = is.read(buffer, 0, 8192)) != -1) {
                bos.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new AtomException("ERROR uploading file", e);
        }
        finally {
            try {
                bos.flush();
                bos.close();
            }
            catch (Exception ignored) {}
        }
    }

    private String createFileName(String title, String contentType) {
        if (this.handle == null) {
            throw new IllegalArgumentException("weblog handle cannot be null");
        }
        if (contentType == null) {
            throw new IllegalArgumentException("contentType cannot be null");
        }
        String fileName = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHHssSSS");
        String[] typeTokens = contentType.split("/");
        String ext = typeTokens[1];
        if (title != null && !title.trim().equals("")) {
            String base = Utilities.replaceNonAlphanumeric(title, ' ');
            StringTokenizer toker = new StringTokenizer(base);
            String tmp = null;
            for (int count = 0; toker.hasMoreTokens() && count < 5; ++count) {
                String s = toker.nextToken();
                s = s.toLowerCase();
                tmp = tmp == null ? s : tmp + "_" + s;
            }
            fileName = tmp + "-" + sdf.format(new Date()) + "." + ext;
        } else {
            fileName = this.handle + "-" + sdf.format(new Date()) + "." + ext;
        }
        return fileName;
    }
}

