/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.server.impl;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.server.AtomException;
import com.sun.syndication.propono.atom.server.AtomHandler;
import com.sun.syndication.propono.atom.server.AtomServlet;
import com.sun.syndication.propono.atom.server.impl.FileBasedAtomService;
import com.sun.syndication.propono.atom.server.impl.FileBasedCollection;
import java.io.File;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileBasedAtomHandler
implements AtomHandler {
    private static Log log = LogFactory.getFactory().getInstance(FileBasedAtomHandler.class);
    private static String fileStoreDir = null;
    private String userName = null;
    private String atomProtocolURL = null;
    private String contextURL = null;
    private String uploadurl = null;
    private FileBasedAtomService service = null;

    public FileBasedAtomHandler(HttpServletRequest req) {
        this(req, AtomServlet.getContextDirPath());
    }

    public FileBasedAtomHandler(HttpServletRequest req, String uploaddir) {
        this.userName = this.authenticateBASIC(req);
        this.atomProtocolURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath() + req.getServletPath();
        this.contextURL = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
        try {
            this.service = new FileBasedAtomService(this.userName, uploaddir, this.atomProtocolURL);
        }
        catch (Throwable t) {
            throw new RuntimeException("ERRLR creating FileBasedAtomService");
        }
    }

    public boolean validateUser(String login, String password) {
        return true;
    }

    public String getAuthenticatedUsername() {
        return this.userName;
    }

    public String getAtomProtocolURL() {
        if (this.atomProtocolURL == null) {
            return "app";
        }
        return this.atomProtocolURL;
    }

    public AtomService getIntrospection() throws AtomException {
        return this.service;
    }

    public Feed getCollection(String[] pathInfo) throws AtomException {
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        return col.getFeedDocument();
    }

    public Entry postEntry(String[] pathInfo, Entry entry) throws AtomException {
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.addEntry(entry);
        }
        catch (Exception fe) {
            fe.printStackTrace();
            throw new AtomException(fe);
        }
    }

    public Entry getEntry(String[] pathInfo) throws AtomException {
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.getEntry(fileName);
        }
        catch (Exception re) {
            if (re instanceof AtomException) {
                throw (AtomException)re;
            }
            throw new AtomException("ERROR: getting entry", re);
        }
    }

    public Entry putEntry(String[] pathInfo, Entry entry) throws AtomException {
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.updateEntry(entry, fileName);
        }
        catch (Exception fe) {
            throw new AtomException(fe);
        }
    }

    public void deleteEntry(String[] pathInfo) throws AtomException {
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            col.deleteEntry(fileName);
        }
        catch (Exception e) {
            String msg = "ERROR in atom.deleteResource";
            log.error((Object)msg, (Throwable)e);
            throw new AtomException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry postMedia(String[] pathInfo, String title, String slug, String contentType, InputStream is) throws AtomException {
        try {
            File tempFile = null;
            String handle = pathInfo[0];
            String collection = pathInfo[1];
            FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
            try {
                Entry entry = col.addMediaEntry(title, slug, contentType, is);
                return entry;
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "ERROR reading posted file";
                log.error((Object)msg, (Throwable)e);
                throw new AtomException(msg, e);
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    public Entry putMedia(String[] pathInfo, String contentType, InputStream is) throws AtomException {
        String handle = pathInfo[0];
        String collection = pathInfo[1];
        String fileName = pathInfo[2];
        FileBasedCollection col = this.service.findCollectionByHandle(handle, collection);
        try {
            return col.updateMediaEntry(fileName, contentType, is);
        }
        catch (Exception re) {
            throw new AtomException("ERROR: posting media");
        }
    }

    public boolean isIntrospectionURI(String[] pathInfo) {
        return pathInfo.length == 0;
    }

    public boolean isCollectionURI(String[] pathInfo) {
        String collection;
        String handle;
        return pathInfo.length == 2 && this.service.findCollectionByHandle(handle = pathInfo[0], collection = pathInfo[1]) != null;
    }

    public boolean isEntryURI(String[] pathInfo) {
        String collection;
        String handle;
        return pathInfo.length == 3 && this.service.findCollectionByHandle(handle = pathInfo[0], collection = pathInfo[1]) != null;
    }

    public boolean isMediaEditURI(String[] pathInfo) {
        if (pathInfo.length == 5) {
            String handle = pathInfo[0];
            String collection = pathInfo[1];
            String fsid1 = pathInfo[2];
            String media = pathInfo[3];
            String fsid2 = pathInfo[4];
            if (this.service.findCollectionByHandle(handle, collection) != null && media.equals("media") && fsid1.equals(fsid2)) {
                return true;
            }
        }
        return false;
    }

    public String authenticateBASIC(HttpServletRequest request) {
        boolean valid = false;
        String userID = null;
        String password = null;
        try {
            String credentials;
            String userPass;
            int p;
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic") && (p = (userPass = new String(Base64.decodeBase64((byte[])(credentials = st.nextToken()).getBytes()))).indexOf(":")) != -1) {
                userID = userPass.substring(0, p);
                password = userPass.substring(p + 1);
                valid = this.validateUser(userID, password);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        if (valid) {
            return userID;
        }
        return null;
    }
}

