/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.server;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.WireFeedOutput;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.server.AtomException;
import com.sun.syndication.propono.atom.server.AtomHandler;
import com.sun.syndication.propono.atom.server.AtomHandlerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class AtomServlet
extends HttpServlet {
    public static final String FEED_TYPE = "atom_1.0";
    private static String contextDirPath = null;
    private static Log log = LogFactory.getFactory().getInstance(AtomServlet.class);

    private AtomHandler createAtomRequestHandler(HttpServletRequest request) throws ServletException {
        AtomHandlerFactory ahf = AtomHandlerFactory.newInstance();
        return ahf.newAtomHandler(request);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block10: {
            log.debug((Object)"Entering");
            AtomHandler handler = this.createAtomRequestHandler(req);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                String[] pathInfo = this.getPathInfo(req);
                try {
                    if (handler.isIntrospectionURI(pathInfo)) {
                        AtomService service = handler.getIntrospection();
                        Document doc = AtomService.serviceToDocument(service);
                        res.setContentType("application/atomsvc+xml; charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        XMLOutputter outputter = new XMLOutputter();
                        outputter.setFormat(Format.getPrettyFormat());
                        outputter.output(doc, (Writer)writer);
                        ((Writer)writer).close();
                        res.setStatus(200);
                        break block10;
                    }
                    if (handler.isCollectionURI(pathInfo)) {
                        Feed col = handler.getCollection(pathInfo);
                        col.setFeedType(FEED_TYPE);
                        WireFeedOutput wireFeedOutput = new WireFeedOutput();
                        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)col);
                        res.setContentType("application/atom+xml; charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        XMLOutputter outputter = new XMLOutputter();
                        outputter.setFormat(Format.getPrettyFormat());
                        outputter.output(feedDoc, (Writer)writer);
                        ((Writer)writer).close();
                        res.setStatus(200);
                        break block10;
                    }
                    if (handler.isEntryURI(pathInfo)) {
                        Entry entry = handler.getEntry(pathInfo);
                        if (entry != null) {
                            res.setContentType("application/atom+xml; charset=utf-8");
                            PrintWriter writer = res.getWriter();
                            AtomServlet.serializeEntry(entry, writer);
                            ((Writer)writer).close();
                        } else {
                            res.setStatus(404);
                        }
                        break block10;
                    }
                    res.setStatus(404);
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                    log.debug((Object)ae);
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    log.debug((Object)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"Roller\"");
                res.setStatus(401);
            }
        }
        log.debug((Object)"Exiting");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block12: {
            log.debug((Object)"Entering");
            AtomHandler handler = this.createAtomRequestHandler(req);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                String[] pathInfo = this.getPathInfo(req);
                try {
                    if (handler.isCollectionURI(pathInfo)) {
                        if (req.getContentType().startsWith("application/atom+xml")) {
                            Entry unsavedEntry = AtomServlet.parseEntry(new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "UTF-8")));
                            Entry savedEntry = handler.postEntry(pathInfo, unsavedEntry);
                            for (Link link : savedEntry.getOtherLinks()) {
                                if (!link.getRel().equals("edit") && link.getRel() != null) continue;
                                res.addHeader("Location", link.getHref());
                                break;
                            }
                            res.setStatus(201);
                            res.setContentType("application/atom+xml; charset=utf-8");
                            PrintWriter writer = res.getWriter();
                            AtomServlet.serializeEntry(savedEntry, writer);
                            ((Writer)writer).close();
                        } else if (req.getContentType() != null) {
                            String title = req.getHeader("Title");
                            String slug = req.getHeader("Slug");
                            Entry resource = handler.postMedia(pathInfo, title, slug, req.getContentType(), (InputStream)req.getInputStream());
                            res.setStatus(201);
                            Content content = (Content)resource.getContents().get(0);
                            for (Link link : resource.getOtherLinks()) {
                                if (!link.getRel().equals("edit") && link.getRel() != null) continue;
                                res.addHeader("Location", link.getHref());
                                break;
                            }
                            PrintWriter writer = res.getWriter();
                            AtomServlet.serializeEntry(resource, writer);
                            ((Writer)writer).close();
                        } else {
                            res.sendError(415, "No content-type specified in request");
                        }
                        break block12;
                    }
                    res.sendError(404, "Invalid collection specified in request");
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    log.debug((Object)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"Roller\"");
                res.setStatus(401);
            }
        }
        log.debug((Object)"Exiting");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block7: {
            log.debug((Object)"Entering");
            AtomHandler handler = this.createAtomRequestHandler(req);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                String[] pathInfo = this.getPathInfo(req);
                try {
                    if (handler.isEntryURI(pathInfo)) {
                        Entry unsavedEntry = AtomServlet.parseEntry(new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), "UTF-8")));
                        Entry updatedEntry = handler.putEntry(pathInfo, unsavedEntry);
                        res.setContentType("application/atom+xml; charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        AtomServlet.serializeEntry(updatedEntry, writer);
                        res.setStatus(200);
                        ((Writer)writer).close();
                        break block7;
                    }
                    if (handler.isMediaEditURI(pathInfo)) {
                        Entry updatedEntry = handler.putMedia(pathInfo, req.getContentType(), (InputStream)req.getInputStream());
                        res.setContentType("application/atom+xml; charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        AtomServlet.serializeEntry(updatedEntry, writer);
                        ((Writer)writer).close();
                        res.setStatus(200);
                        break block7;
                    }
                    res.setStatus(404);
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    log.debug((Object)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"Roller\"");
                res.setStatus(401);
            }
        }
        log.debug((Object)"Exiting");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block6: {
            log.debug((Object)"Entering");
            AtomHandler handler = this.createAtomRequestHandler(req);
            String userName = handler.getAuthenticatedUsername();
            if (userName != null) {
                String[] pathInfo = this.getPathInfo(req);
                try {
                    if (handler.isEntryURI(pathInfo)) {
                        handler.deleteEntry(pathInfo);
                        res.setStatus(200);
                        break block6;
                    }
                    res.setStatus(404);
                }
                catch (AtomException ae) {
                    res.sendError(ae.getStatus(), ae.getMessage());
                }
                catch (Exception e) {
                    res.sendError(500, e.getMessage());
                    log.debug((Object)e);
                }
            } else {
                res.setHeader("WWW-Authenticate", "BASIC realm=\"Roller\"");
                res.setStatus(401);
            }
        }
        log.debug((Object)"Exiting");
    }

    protected String[] getPathInfo(HttpServletRequest request) {
        String mPathInfo = request.getPathInfo();
        mPathInfo = mPathInfo != null ? mPathInfo : "";
        return StringUtils.split((String)mPathInfo, (String)"/");
    }

    public static void serializeEntry(Entry entry, OutputStream ostream) throws IllegalArgumentException, FeedException, IOException {
        AtomServlet.serializeEntry(entry, new OutputStreamWriter(ostream));
    }

    public static void serializeEntry(Entry entry, Writer writer) throws IllegalArgumentException, FeedException, IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(entry);
        Feed feed1 = new Feed();
        feed1.setFeedType(FEED_TYPE);
        feed1.setEntries(entries);
        WireFeedOutput wireFeedOutput = new WireFeedOutput();
        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)feed1);
        Element entryElement = (Element)feedDoc.getRootElement().getChildren().get(0);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        if (log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            outputter.output(entryElement, (Writer)sw);
            log.debug((Object)sw.toString());
            writer.write(sw.toString());
        } else {
            outputter.output(entryElement, writer);
        }
    }

    public static Entry parseEntry(Reader rd) throws JDOMException, IOException, IllegalArgumentException, FeedException {
        SAXBuilder builder = new SAXBuilder();
        Document entryDoc = builder.build(rd);
        Element fetchedEntryElement = entryDoc.getRootElement();
        fetchedEntryElement.detach();
        Feed feed = new Feed();
        feed.setFeedType(FEED_TYPE);
        WireFeedOutput wireFeedOutput = new WireFeedOutput();
        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)feed);
        feedDoc.getRootElement().addContent((org.jdom.Content)fetchedEntryElement);
        WireFeedInput input = new WireFeedInput();
        Feed parsedFeed = (Feed)input.build(feedDoc);
        return (Entry)parsedFeed.getEntries().get(0);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        contextDirPath = this.getServletContext().getRealPath("/");
    }

    public static String getContextDirPath() {
        return contextDirPath;
    }
}

