/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common.rome;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.WireFeedOutput;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ROMEUtilities {
    private static Log log = LogFactory.getFactory().getInstance(ROMEUtilities.class);
    public static final String FEED_TYPE = "atom_1.0";

    ROMEUtilities() {
    }

    public static void serializeEntry(Entry entry, Writer writer) throws IllegalArgumentException, FeedException, IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        entries.add(entry);
        Feed feed1 = new Feed();
        feed1.setFeedType(FEED_TYPE);
        feed1.setEntries(entries);
        WireFeedOutput wireFeedOutput = new WireFeedOutput();
        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)feed1);
        Element entryElement = (Element)feedDoc.getRootElement().getChildren().get(0);
        XMLOutputter outputter = new XMLOutputter();
        outputter.setFormat(Format.getPrettyFormat());
        if (log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            outputter.output(entryElement, (Writer)sw);
            log.debug((Object)sw.toString());
            writer.write(sw.toString());
        } else {
            outputter.output(entryElement, writer);
        }
    }

    public static Entry parseEntry(Reader rd) throws JDOMException, IOException, IllegalArgumentException, FeedException {
        SAXBuilder builder = new SAXBuilder();
        Document entryDoc = builder.build(rd);
        Element fetchedEntryElement = entryDoc.getRootElement();
        fetchedEntryElement.detach();
        Feed feed = new Feed();
        feed.setFeedType(FEED_TYPE);
        WireFeedOutput wireFeedOutput = new WireFeedOutput();
        Document feedDoc = wireFeedOutput.outputJDom((WireFeed)feed);
        feedDoc.getRootElement().addContent((Content)fetchedEntryElement);
        WireFeedInput input = new WireFeedInput();
        Feed parsedFeed = (Feed)input.build(feedDoc);
        return (Entry)parsedFeed.getEntries().get(0);
    }

    public static boolean isMediaEntry(Entry entry) {
        boolean mediaEntry = false;
        List links = entry.getOtherLinks();
        for (Link link : links) {
            if (!"edit-media".equals(link.getRel())) continue;
            mediaEntry = true;
            break;
        }
        return mediaEntry;
    }
}

