/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.common;

import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.propono.atom.common.AtomService;
import com.sun.syndication.propono.atom.common.Categories;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class Collection {
    private String title = null;
    private String titleType = null;
    private String accept = "entry";
    private String listTemplate = null;
    private String href = null;
    private List categories = new ArrayList();

    public Collection(String title, String titleType, String href) {
        this.title = title;
        this.titleType = titleType;
        this.href = href;
    }

    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleType() {
        return this.titleType;
    }

    public void setTitleType(String titleType) {
        this.titleType = titleType;
    }

    public void addCategories(Categories cats) {
        this.categories.add(cats);
    }

    public List getCategories() {
        return this.categories;
    }

    public boolean accepts(String ct) {
        if (this.accept != null && this.accept.trim().equals("*/*")) {
            return true;
        }
        String entryType = "application/atom+xml";
        boolean entry = entryType.equals(ct);
        if (entry && null == this.accept) {
            return true;
        }
        if (entry && "entry".equals(this.accept)) {
            return true;
        }
        if (entry && entryType.equals(this.accept)) {
            return true;
        }
        String[] rules = this.accept.split(",");
        for (int i = 0; i < rules.length; ++i) {
            String rule = rules[i].trim();
            if (rule.equals(ct)) {
                return true;
            }
            int slashstar = rule.indexOf("/*");
            if (slashstar <= 0 || !ct.startsWith(rule = rule.substring(0, slashstar + 1))) continue;
            return true;
        }
        return false;
    }

    public static Element collectionToElement(Collection collection) {
        Element element = new Element("collection", AtomService.ATOM_PROTOCOL);
        element.setAttribute("href", collection.getHref());
        Element title = new Element("title", AtomService.ATOM_FORMAT);
        title.setText(collection.getTitle());
        element.addContent((Content)title);
        if (collection.getTitleType() != null && !collection.getTitleType().equals("TEXT")) {
            element.setAttribute("type", collection.getTitleType(), AtomService.ATOM_FORMAT);
        }
        for (Categories cats : collection.getCategories()) {
            Element catsElem = new Element("categories", AtomService.ATOM_PROTOCOL);
            catsElem.setAttribute("fixed", cats.isFixed() ? "yes" : "no", AtomService.ATOM_PROTOCOL);
            if (cats.getScheme() != null) {
                catsElem.setAttribute("scheme", cats.getScheme(), AtomService.ATOM_PROTOCOL);
            }
            for (Category cat : cats.getCategories()) {
                Element catElem = new Element("category", AtomService.ATOM_FORMAT);
                catElem.setAttribute("term", cat.getTerm(), AtomService.ATOM_FORMAT);
                if (cat.getScheme() != null) {
                    catElem.setAttribute("scheme", cat.getScheme(), AtomService.ATOM_FORMAT);
                }
                if (cat.getLabel() != null) {
                    catElem.setAttribute("label", cat.getLabel(), AtomService.ATOM_FORMAT);
                }
                catsElem.addContent((Content)catElem);
            }
            element.addContent((Content)catsElem);
        }
        Element memberType = new Element("accept", AtomService.ATOM_PROTOCOL);
        memberType.setText(collection.getAccept());
        element.addContent((Content)memberType);
        return element;
    }

    public static Collection elementToCollection(Element element) {
        String newHref = element.getAttribute("href").getValue();
        Element titleElem = element.getChild("title", AtomService.ATOM_FORMAT);
        String newTitle = titleElem.getText();
        String newType = null;
        if (titleElem.getAttribute("type", AtomService.ATOM_FORMAT) != null) {
            newType = titleElem.getAttribute("type", AtomService.ATOM_FORMAT).getValue();
        }
        Collection collection = new Collection(newTitle, newType, newHref);
        Element memberType = element.getChild("accept", AtomService.ATOM_PROTOCOL);
        if (memberType != null) {
            collection.setAccept(memberType.getText());
        }
        List catsElems = element.getChildren("categories", AtomService.ATOM_PROTOCOL);
        for (Element catsElem : catsElems) {
            Categories cats = new Categories();
            if ("yes".equals(catsElem.getAttribute("fixed", AtomService.ATOM_PROTOCOL))) {
                cats.setFixed(true);
            }
            List catElems = catsElem.getChildren("category", AtomService.ATOM_FORMAT);
            for (Element catElem : catElems) {
                Category cat = new Category();
                cat.setTerm(catElem.getAttributeValue("term"));
                cat.setLabel(catElem.getAttributeValue("label"));
                cat.setScheme(catElem.getAttributeValue("scheme"));
                cats.addCategory(cat);
            }
            collection.addCategories(cats);
        }
        return collection;
    }
}

