/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.atom.client;

import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.propono.atom.client.ClientAtomService;
import com.sun.syndication.propono.atom.client.ClientCollection;
import com.sun.syndication.propono.atom.client.ClientEntry;
import com.sun.syndication.propono.atom.common.rome.ROMEUtilities;
import com.sun.syndication.propono.utils.ProponoException;
import com.sun.syndication.propono.utils.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.JDOMException;

public class ClientMediaEntry
extends ClientEntry {
    private static final Log logger = LogFactory.getLog(ClientMediaEntry.class);
    private String slug = null;
    private byte[] bytes;
    private InputStream inputStream;

    public ClientMediaEntry(ClientAtomService service, ClientCollection collection) {
        super(service, collection);
    }

    public ClientMediaEntry(ClientAtomService service, ClientCollection collection, Entry entry, boolean partial) throws ProponoException {
        super(service, collection, entry, partial);
    }

    public ClientMediaEntry(ClientAtomService service, ClientCollection collection, String title, String slug, String contentType, InputStream is) {
        this(service, collection);
        this.inputStream = is;
        this.setTitle(title);
        this.setSlug(slug);
        Content content = new Content();
        content.setType(contentType);
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.add(content);
        this.setContents(contents);
    }

    public ClientMediaEntry(ClientAtomService service, ClientCollection collection, String title, String slug, String contentType, byte[] bytes) {
        this(service, collection);
        this.bytes = bytes;
        this.setTitle(title);
        this.setSlug(slug);
        Content content = new Content();
        content.setType(contentType);
        ArrayList<Content> contents = new ArrayList<Content>();
        contents.add(content);
        this.setContents(contents);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        if (this.inputStream != null) {
            throw new IllegalStateException("ERROR: already has inputStream, cannot set both inputStream and bytes");
        }
        this.bytes = bytes;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        if (this.bytes != null) {
            throw new IllegalStateException("ERROR: already has bytes, cannot set both bytes and inputStream");
        }
        this.inputStream = inputStream;
    }

    public String getMediaLinkURI() {
        for (int i = 0; i < this.getOtherLinks().size(); ++i) {
            Link link = (Link)this.getOtherLinks().get(i);
            if (link.getRel() == null || !link.getRel().equals("edit-media")) continue;
            return link.getHref();
        }
        return null;
    }

    public InputStream getAsStream() throws ProponoException {
        if (this.getContents() != null && this.getContents().size() > 0) {
            Content c = (Content)this.getContents().get(0);
            if (c.getSrc() != null) {
                return this.getResourceAsStream();
            }
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (this.bytes != null) {
                return new ByteArrayInputStream(this.bytes);
            }
            throw new ProponoException("ERROR: no src URI or binary data to return");
        }
        throw new ProponoException("ERROR: no content found in entry");
    }

    private InputStream getResourceAsStream() throws ProponoException {
        if (this.getEditURI() == null) {
            throw new ProponoException("ERROR: not yet saved to server");
        }
        GetMethod method = new GetMethod(((Content)this.getContents()).getSrc());
        try {
            this.getCollection().getHttpClient().executeMethod((HttpMethod)method);
            if (method.getStatusCode() != 200) {
                throw new ProponoException("ERROR HTTP status=" + method.getStatusCode());
            }
            return method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new ProponoException("ERROR: getting media entry", e);
        }
    }

    public void update() throws ProponoException {
        if (this.partial) {
            throw new ProponoException("ERROR: attempt to update partial entry");
        }
        PutMethod method = null;
        Content updateContent = (Content)this.getContents().get(0);
        try {
            if (this.getMediaLinkURI() != null && this.getBytes() != null) {
                method = new PutMethod(this.getMediaLinkURI());
                if (this.inputStream != null) {
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(this.inputStream));
                } else {
                    method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(this.getBytes())));
                }
                method.setRequestHeader("Content-type", updateContent.getType());
            } else if (this.getEditURI() != null) {
                method = new PutMethod(this.getEditURI());
                StringWriter sw = new StringWriter();
                ROMEUtilities.serializeEntry(this, sw);
                method.setRequestEntity((RequestEntity)new StringRequestEntity(sw.toString()));
                method.setRequestHeader("Content-type", "application/atom+xml; charset=utf8");
            } else {
                throw new ProponoException("ERROR: media entry has no edit URI or media-link URI");
            }
            this.getCollection().addAuthentication((HttpMethodBase)method);
            method.addRequestHeader("Title", this.getTitle());
            this.getCollection().getHttpClient().executeMethod((HttpMethod)method);
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            InputStream is = method.getResponseBodyAsStream();
            if (method.getStatusCode() != 200 && method.getStatusCode() != 201) {
                throw new ProponoException("ERROR HTTP status=" + method.getStatusCode() + " : " + Utilities.streamToString(is));
            }
            Entry romeEntry = ROMEUtilities.parseEntry(new InputStreamReader(is));
            BeanUtils.copyProperties((Object)((Object)this), (Object)romeEntry);
        }
        catch (Exception e) {
            throw new ProponoException("ERROR: saving media entry");
        }
        if (method.getStatusCode() != 201) {
            throw new ProponoException("ERROR HTTP status=" + method.getStatusCode());
        }
    }

    void addToCollection(ClientCollection col) throws ProponoException {
        this.setCollection(col);
        PostMethod method = new PostMethod(col.getHref());
        this.getCollection().addAuthentication((HttpMethodBase)method);
        StringWriter sw = new StringWriter();
        boolean error = false;
        try {
            Content c = (Content)this.getContents().get(0);
            if (this.inputStream != null) {
                method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(this.inputStream));
            } else {
                method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(this.getBytes())));
            }
            method.setRequestHeader("Content-type", c.getType());
            method.setRequestHeader("Title", this.getTitle());
            method.setRequestHeader("Slug", this.getSlug());
            this.getCollection().getHttpClient().executeMethod((HttpMethod)method);
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            InputStream is = method.getResponseBodyAsStream();
            if (method.getStatusCode() != 200 && method.getStatusCode() != 201) {
                throw new ProponoException("ERROR HTTP status-code=" + method.getStatusCode() + " status-line: " + method.getStatusLine());
            }
            Entry romeEntry = ROMEUtilities.parseEntry(new InputStreamReader(is));
            BeanUtils.copyProperties((Object)((Object)this), (Object)romeEntry);
        }
        catch (IOException ie) {
            throw new ProponoException("ERROR: saving media entry", ie);
        }
        catch (JDOMException je) {
            throw new ProponoException("ERROR: saving media entry", je);
        }
        catch (FeedException fe) {
            throw new ProponoException("ERROR: saving media entry", fe);
        }
        catch (IllegalAccessException ae) {
            throw new ProponoException("ERROR: saving media entry", ae);
        }
        catch (InvocationTargetException te) {
            throw new ProponoException("ERROR: saving media entry", te);
        }
        Header locationHeader = method.getResponseHeader("Location");
        if (locationHeader == null) {
            logger.warn((Object)"WARNING added media entry, but no location header returned");
        }
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }
}

