/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.fluent;

import java.util.HashMap;
import java.util.Map;
import org.directwebremoting.Container;
import org.directwebremoting.extend.AccessControl;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.impl.SignatureParser;
import org.directwebremoting.util.Logger;

public abstract class FluentConfigurator
implements Configurator {
    private String typeName;
    private String scriptName;
    private String converter;
    private String match;
    private Map params = null;
    private StringBuffer signature;
    private int state = -1;
    private ConverterManager converterManager;
    private AccessControl accessControl;
    private CreatorManager creatorManager;
    private static final int STATE_INIT_CREATE = 0;
    private static final int STATE_INIT_CONVERT = 1;
    private static final int STATE_ALLOW_CREATE = 2;
    private static final int STATE_ALLOW_CONVERT = 3;
    private static final int STATE_SIGNATURE = 4;
    private static final int STATE_COMPLETE = 5;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$fluent$FluentConfigurator == null ? (class$org$directwebremoting$fluent$FluentConfigurator = FluentConfigurator.class$("org.directwebremoting.fluent.FluentConfigurator")) : class$org$directwebremoting$fluent$FluentConfigurator);
    static /* synthetic */ Class class$org$directwebremoting$extend$ConverterManager;
    static /* synthetic */ Class class$org$directwebremoting$extend$AccessControl;
    static /* synthetic */ Class class$org$directwebremoting$extend$CreatorManager;
    static /* synthetic */ Class class$org$directwebremoting$fluent$FluentConfigurator;

    public abstract void configure();

    public FluentConfigurator withConverterType(String id, String className) {
        this.setState(1);
        this.converterManager.addConverterType(id, className);
        return this;
    }

    public FluentConfigurator withConverter(String newConverter, String newMatch) {
        this.setState(3);
        this.converter = newConverter;
        this.match = newMatch;
        return this;
    }

    public FluentConfigurator withCreatorType(String id, String className) {
        this.setState(0);
        this.creatorManager.addCreatorType(id, className);
        return this;
    }

    public FluentConfigurator withCreator(String newTypeName, String newScriptName) {
        this.setState(2);
        this.typeName = newTypeName;
        this.scriptName = newScriptName;
        return this;
    }

    public FluentConfigurator addParam(String name, String value) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(name, value);
        return this;
    }

    public FluentConfigurator include(String methodName) {
        this.accessControl.addIncludeRule(this.scriptName, methodName);
        return this;
    }

    public FluentConfigurator exclude(String methodName) {
        this.accessControl.addExcludeRule(this.scriptName, methodName);
        return this;
    }

    public FluentConfigurator withAuth(String methodName, String role) {
        this.accessControl.addRoleRestriction(this.scriptName, methodName, role);
        return this;
    }

    public FluentConfigurator withSignature() {
        this.setState(4);
        return this;
    }

    public FluentConfigurator addLine(String line) {
        if (null == line) {
            return this;
        }
        if (null == this.signature) {
            this.signature = new StringBuffer();
        }
        this.signature.append(line + System.getProperty("line.separator"));
        return this;
    }

    private void setState(int state) {
        this.flush();
        this.state = state;
    }

    private void flush() {
        switch (this.state) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            case 3: {
                try {
                    this.converterManager.addConverter(this.match, this.converter, this.params);
                }
                catch (Exception e) {
                    log.warn("Failed to add converter of type='" + this.converter + "', match=" + this.match + ": ", e);
                }
                this.params = null;
                this.match = null;
                this.converter = null;
                break;
            }
            case 2: {
                try {
                    this.creatorManager.addCreator(this.typeName, this.scriptName, this.params);
                }
                catch (Exception e) {
                    log.warn("Failed to add creator of type='" + this.typeName + "', scriptName=" + this.scriptName + ": ", e);
                }
                this.params = null;
                this.scriptName = null;
                this.typeName = null;
                break;
            }
            case 4: {
                if (this.signature == null || this.signature.length() <= 0) break;
                SignatureParser sigp = new SignatureParser(this.converterManager, this.creatorManager);
                sigp.parse(this.signature.toString());
                break;
            }
        }
    }

    public void configure(Container container) {
        this.converterManager = (ConverterManager)container.getBean((class$org$directwebremoting$extend$ConverterManager == null ? (class$org$directwebremoting$extend$ConverterManager = FluentConfigurator.class$("org.directwebremoting.extend.ConverterManager")) : class$org$directwebremoting$extend$ConverterManager).getName());
        this.accessControl = (AccessControl)container.getBean((class$org$directwebremoting$extend$AccessControl == null ? (class$org$directwebremoting$extend$AccessControl = FluentConfigurator.class$("org.directwebremoting.extend.AccessControl")) : class$org$directwebremoting$extend$AccessControl).getName());
        this.creatorManager = (CreatorManager)container.getBean((class$org$directwebremoting$extend$CreatorManager == null ? (class$org$directwebremoting$extend$CreatorManager = FluentConfigurator.class$("org.directwebremoting.extend.CreatorManager")) : class$org$directwebremoting$extend$CreatorManager).getName());
        this.configure();
        this.setState(5);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

