/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.ArrayOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.dwrp.SimpleOutboundVariable;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.Logger;
import org.directwebremoting.util.Messages;

public class CollectionConverter
extends BaseV20Converter
implements Converter {
    private ConverterManager config = null;
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$convert$CollectionConverter == null ? (class$org$directwebremoting$convert$CollectionConverter = CollectionConverter.class$("org.directwebremoting.convert.CollectionConverter")) : class$org$directwebremoting$convert$CollectionConverter);
    static /* synthetic */ Class class$java$util$Iterator;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$org$directwebremoting$convert$CollectionConverter;

    public void setConverterManager(ConverterManager newConfig) {
        this.config = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws MarshallException {
        String value = iv.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("[")) {
            throw new MarshallException(paramType, Messages.getString("CollectionConverter.FormatError", "["));
        }
        if (!value.endsWith("]")) {
            throw new MarshallException(paramType, Messages.getString("CollectionConverter.FormatError", "]"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Collection<Object> col;
            TypeHintContext icc = inctx.getCurrentTypeHintContext();
            TypeHintContext subthc = icc.createChildContext(0);
            Class subtype = subthc.getExtraTypeInfo();
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = CollectionConverter.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if (!paramType.isInterface() && !Modifier.isAbstract(paramType.getModifiers())) {
                col = (Collection)paramType.newInstance();
            } else if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CollectionConverter.class$("java.util.SortedSet")) : class$java$util$SortedSet).isAssignableFrom(paramType)) {
                col = new TreeSet();
            } else if ((class$java$util$Set == null ? (class$java$util$Set = CollectionConverter.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(paramType)) {
                col = new HashSet();
            } else if ((class$java$util$List == null ? (class$java$util$List = CollectionConverter.class$("java.util.List")) : class$java$util$List).isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(paramType)) {
                col = new ArrayList();
            } else {
                throw new MarshallException(paramType);
            }
            inctx.addConverted(iv, paramType, col);
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            for (int i = 0; i < size; ++i) {
                String token = st.nextToken();
                String[] split = ParseUtil.splitInbound(token);
                String splitType = split[0];
                String splitValue = split[1];
                InboundVariable nested = new InboundVariable(iv.getLookup(), null, splitType, splitValue);
                Object output = this.config.convertInbound(subtype, nested, inctx, subthc);
                col.add(output);
            }
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = CollectionConverter.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(paramType)) {
                return col.iterator();
            }
            return col;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        Iterator it;
        if (data instanceof Collection) {
            Collection col = (Collection)data;
            it = col.iterator();
        } else if (data instanceof Iterator) {
            it = (Iterator)data;
        } else {
            throw new MarshallException(data.getClass());
        }
        ArrayOutboundVariable ov = new ArrayOutboundVariable(outctx);
        outctx.put(data, ov);
        ArrayList<OutboundVariable> ovs = new ArrayList<OutboundVariable>();
        while (it.hasNext()) {
            OutboundVariable nested;
            Object member = it.next();
            try {
                nested = this.config.convertOutbound(member, outctx);
            }
            catch (Exception ex) {
                nested = new SimpleOutboundVariable("'Conversion Error. See console log.'", outctx, true);
                log.warn("Failed to convert array member " + ovs.size() + ". Conversion error for type: " + data.getClass().getName(), ex);
            }
            ovs.add(nested);
        }
        ov.init(ovs);
        return ov;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

