/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.InputStream;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.AuthenticationFailed;
import org.apache.xmlrpc.ContextXmlRpcHandler;
import org.apache.xmlrpc.DefaultXmlRpcContext;
import org.apache.xmlrpc.ParseFailed;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcContext;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcHandlerMapping;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;

public class XmlRpcWorker {
    protected XmlRpcRequestProcessor requestProcessor = new XmlRpcRequestProcessor();
    protected XmlRpcResponseProcessor responseProcessor = new XmlRpcResponseProcessor();
    protected XmlRpcHandlerMapping handlerMapping;

    public XmlRpcWorker(XmlRpcHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Object invokeHandler(Object handler, XmlRpcRequest request, XmlRpcContext context) throws Exception {
        Object object;
        long now;
        block7: {
            Object object2;
            block6: {
                now = 0L;
                try {
                    if (XmlRpc.debug) {
                        now = System.currentTimeMillis();
                    }
                    if (handler == null) {
                        throw new NullPointerException("Null handler passed to XmlRpcWorker.invokeHandler");
                    }
                    if (handler instanceof ContextXmlRpcHandler) {
                        Object object3 = ((ContextXmlRpcHandler)handler).execute(request.getMethodName(), request.getParameters(), context);
                        Object var7_7 = null;
                        if (!XmlRpc.debug) return object3;
                        System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis processing request");
                        return object3;
                    }
                    if (handler instanceof XmlRpcHandler) {
                        object2 = ((XmlRpcHandler)handler).execute(request.getMethodName(), request.getParameters());
                        break block6;
                    }
                    if (!(handler instanceof AuthenticatedXmlRpcHandler)) throw new ClassCastException("Handler class " + handler.getClass().getName() + " is not a valid XML-RPC handler");
                    object = ((AuthenticatedXmlRpcHandler)handler).execute(request.getMethodName(), request.getParameters(), context.getUserName(), context.getPassword());
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (!XmlRpc.debug) throw throwable;
                    System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis processing request");
                    throw throwable;
                }
            }
            Object var7_8 = null;
            if (!XmlRpc.debug) return object2;
            System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis processing request");
            return object2;
        }
        Object var7_9 = null;
        if (!XmlRpc.debug) return object;
        System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis processing request");
        return object;
    }

    public byte[] execute(InputStream is, String user, String password) {
        return this.execute(is, this.defaultContext(user, password));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] execute(InputStream is, XmlRpcContext context) {
        long now = 0L;
        if (XmlRpc.debug) {
            now = System.currentTimeMillis();
        }
        try {
            byte[] byArray;
            try {
                XmlRpcRequest request = this.requestProcessor.processRequest(is);
                Object handler = this.handlerMapping.getHandler(request.getMethodName());
                Object response = XmlRpcWorker.invokeHandler(handler, request, context);
                byArray = this.responseProcessor.processResponse(response, this.requestProcessor.getEncoding());
                Object var10_12 = null;
                if (!XmlRpc.debug) return byArray;
            }
            catch (AuthenticationFailed alertCallerAuth) {
                throw alertCallerAuth;
            }
            catch (ParseFailed alertCallerParse) {
                throw alertCallerParse;
            }
            catch (Exception x) {
                if (XmlRpc.debug) {
                    x.printStackTrace();
                }
                byte[] byArray2 = this.responseProcessor.processException(x, this.requestProcessor.getEncoding());
                Object var10_13 = null;
                if (!XmlRpc.debug) return byArray2;
                System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
                return byArray2;
            }
            System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
            return byArray;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            if (!XmlRpc.debug) throw throwable;
            System.out.println("Spent " + (System.currentTimeMillis() - now) + " millis in request/process/response");
            throw throwable;
        }
    }

    protected XmlRpcContext defaultContext(String user, String password) {
        return new DefaultXmlRpcContext(user, password, this.handlerMapping);
    }
}

