/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.propono.blogclient.metaweblog;

import com.sun.syndication.propono.blogclient.BaseBlogEntry;
import com.sun.syndication.propono.blogclient.BlogClientException;
import com.sun.syndication.propono.blogclient.BlogEntry;
import com.sun.syndication.propono.blogclient.metaweblog.MetaWeblogBlog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaWeblogEntry
extends BaseBlogEntry {
    MetaWeblogEntry(MetaWeblogBlog blog, Map entryMap) {
        super(blog);
        this.id = (String)entryMap.get("postid");
        this.content = new BlogEntry.Content((String)entryMap.get("description"));
        this.content.setType("application/metaweblog+xml");
        this.draft = false;
        this.title = (String)entryMap.get("title");
        this.publicationDate = (Date)entryMap.get("dateCreated");
        this.permalink = (String)entryMap.get("permaLink");
        this.categories = new ArrayList();
        Object[] catArray = (Object[])entryMap.get("categories");
        if (catArray != null) {
            for (int i = 0; i < catArray.length; ++i) {
                BlogEntry.Category cat = new BlogEntry.Category((String)catArray[i]);
                this.categories.add(cat);
            }
        }
    }

    public String getToken() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o instanceof MetaWeblogEntry) {
            MetaWeblogEntry other = (MetaWeblogEntry)o;
            if (other.id != null && this.id != null) {
                return other.id.equals(this.id);
            }
        }
        return false;
    }

    public void save() throws BlogClientException {
        this.id = ((MetaWeblogBlog)this.getBlog()).saveEntry(this);
    }

    public void delete() throws BlogClientException {
        ((MetaWeblogBlog)this.getBlog()).deleteEntry(this.id);
    }

    HashMap toPostStructure() {
        HashMap<String, Object> struct = new HashMap<String, Object>();
        if (this.getTitle() != null) {
            struct.put("title", this.getTitle());
        }
        if (this.getContent() != null && this.getContent().getValue() != null) {
            struct.put("description", this.getContent().getValue());
        }
        if (this.getCategories() != null && this.getCategories().size() > 0) {
            ArrayList<String> catArray = new ArrayList<String>();
            List cats = this.getCategories();
            for (int i = 0; i < cats.size(); ++i) {
                BlogEntry.Category cat = (BlogEntry.Category)cats.get(i);
                catArray.add(cat.getName());
            }
            struct.put("categories", catArray);
        }
        if (this.getPublicationDate() != null) {
            struct.put("dateCreated", this.getPublicationDate());
        }
        if (this.getId() != null) {
            struct.put("postid", this.getId());
        }
        return struct;
    }
}

