/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.analysis.SpecialAbilityResolution;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.PropertyFactory;

public class RaceToken
extends Token {
    private static final String TOKENNAME = "RACE";
    private static final String[] SUBTOKENLIST = new String[]{"ABILITYLIST"};

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if (TOKENNAME.equals(string)) {
            string2 = RaceToken.getRaceToken(playerCharacter);
        } else {
            for (int i = 0; i < SUBTOKENLIST.length; ++i) {
                String string3 = "RACE." + SUBTOKENLIST[i];
                if (!string3.equals(string)) continue;
                string2 = RaceToken.getSubToken(SUBTOKENLIST[i], playerCharacter);
            }
        }
        return string2;
    }

    private static String getSubToken(String string, PlayerCharacter playerCharacter) {
        if (!string.equals(SUBTOKENLIST[0])) {
            return "";
        }
        ArrayList arrayList = new ArrayList();
        playerCharacter.getRace().addSpecialAbilitiesToList(arrayList, playerCharacter);
        SpecialAbilityResolution.addSABToList(arrayList, (PlayerCharacter)playerCharacter, (CDOMObject)playerCharacter.getRace());
        if (arrayList.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (SpecialAbility specialAbility : arrayList) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            bl = false;
            stringBuffer.append(specialAbility.getDisplayName());
        }
        return stringBuffer.toString();
    }

    private static String getRaceToken(PlayerCharacter playerCharacter) {
        PCClass pCClass;
        PCClass pCClass2;
        LevelCommandFactory levelCommandFactory;
        String string = "";
        String string2 = playerCharacter.getRace().getOutputName();
        if (string2 == null || string2.length() == 0) {
            string2 = playerCharacter.getRace().getDisplayName();
        }
        StringBuffer stringBuffer = new StringBuffer(40);
        if (!playerCharacter.getSubRace().equals("None")) {
            stringBuffer.append(playerCharacter.getSubRace());
        }
        if (SettingsHandler.hideMonsterClasses() && (levelCommandFactory = (LevelCommandFactory)playerCharacter.getRace().get(ObjectKey.MONSTER_CLASS)) != null && (pCClass2 = playerCharacter.getClassKeyed((pCClass = levelCommandFactory.getPCClass()).getKeyName())) != null) {
            int n = levelCommandFactory.getLevelCount().resolve(playerCharacter, "").intValue();
            int n2 = pCClass2.getLevel();
            if (n2 != n) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(n2).append(PropertyFactory.getString((String)"in_hdLabel"));
            }
        }
        string = string2;
        if (stringBuffer.length() != 0) {
            string = string + " (" + stringBuffer + ')';
        }
        return string;
    }
}

