/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.rt.ClassPathCacheEntry;
import com.vladium.emma.rt.IClassLoadHook;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.util.Map;

public final class InstrClassLoader
extends URLClassLoader {
    public static final String PROPERTY_FORCED_DELEGATION_FILTER = "clsload.forced_delegation_filter";
    public static final String PROPERTY_THROUGH_DELEGATION_FILTER = "clsload.through_delegation_filter";
    private final ClassLoader m_parent;
    private final IInclExclFilter m_forcedDelegationFilter;
    private final IInclExclFilter m_throughDelegationFilter;
    private final Map m_cache;
    private final IClassLoadHook m_hook;
    private final PoolEntry[] m_bufPool;
    private int m_nestLevel;
    private int m_cacheHits;
    private int m_cacheMisses;
    private static final int BAOS_INIT_SIZE = 32768;
    private static final int BAOS_MAX_SIZE = 0x100000;
    private static final int BAOS_POOL_SIZE = 8;
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    public InstrClassLoader(ClassLoader parent, File[] classpath, IInclExclFilter forcedDelegationFilter, IInclExclFilter throughDelegationFilter, IClassLoadHook hook, Map cache) throws MalformedURLException {
        super(InstrClassLoader.filesToURLs(classpath), (ClassLoader)null);
        this.m_hook = hook;
        this.m_cache = cache;
        this.m_forcedDelegationFilter = forcedDelegationFilter;
        this.m_throughDelegationFilter = throughDelegationFilter;
        this.m_parent = parent;
        this.m_bufPool = new PoolEntry[8];
    }

    public final synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean trace1 = Logger.atTRACE1();
        if (trace1) {
            Logger.trace1("loadClass", "(" + name + ", " + resolve + "): nest level " + this.m_nestLevel);
        }
        Class<?> c = null;
        c = this.findLoadedClass(name);
        if (c == null) {
            Class<?> parentsVersion;
            block15: {
                parentsVersion = null;
                if (this.m_parent != null) {
                    try {
                        parentsVersion = this.m_parent.loadClass(name);
                        if (parentsVersion.getClassLoader() != this.m_parent || this.m_forcedDelegationFilter == null || this.m_forcedDelegationFilter.included(name)) {
                            c = parentsVersion;
                            if (trace1) {
                                Logger.trace1("loadClass", "using parent's version for [" + name + "]");
                            }
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        if (this.m_forcedDelegationFilter != null && !this.m_forcedDelegationFilter.included(name)) break block15;
                        throw cnfe;
                    }
                }
            }
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    if (parentsVersion != null) {
                        boolean delegate;
                        boolean bl = delegate = this.m_throughDelegationFilter == null || this.m_throughDelegationFilter.included(name);
                        if (delegate) {
                            c = parentsVersion;
                            if (trace1) {
                                Logger.trace1("loadClass", "[delegation filter] using parent's version for [" + name + "]");
                            }
                        }
                        throw cnfe;
                    }
                    throw cnfe;
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public final URL getResource(String name) {
        boolean trace1 = Logger.atTRACE1();
        if (trace1) {
            Logger.trace1("getResource", "(" + name + "): nest level " + this.m_nestLevel);
        }
        URL result = super.getResource(name);
        if (trace1 && result != null) {
            Logger.trace1("loadClass", "[" + name + "] found in " + result);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final Class findClass(String name) throws ClassNotFoundException {
        Class clazz;
        boolean trace = Logger.atTRACE1();
        if (trace) {
            Logger.trace1("findClass", "(" + name + "): nest level " + this.m_nestLevel);
        }
        boolean useClassCache = this.m_cache != null;
        ClassPathCacheEntry entry = useClassCache ? (ClassPathCacheEntry)this.m_cache.remove(name) : null;
        URL classURL = null;
        if (entry != null) {
            ++this.m_cacheHits;
            try {
                classURL = new URL(entry.m_srcURL);
            }
            catch (MalformedURLException murle) {
                // empty catch block
            }
            PoolEntry buf2 = null;
            try {
                buf2 = this.acquirePoolEntry();
                ByteArrayOStream baos = buf2.m_baos;
                byte[] bytes = entry.m_bytes;
                int length = bytes.length;
                if (this.m_hook != null && this.m_hook.processClassDef(name, bytes, length, baos)) {
                    bytes = baos.getByteArray();
                    length = baos.size();
                    if (trace) {
                        Logger.trace1("findClass", "defining [cached] instrumented [" + name + "] {" + length + " bytes }");
                    }
                } else if (trace) {
                    Logger.trace1("findClass", "defining [cached] [" + name + "] {" + length + " bytes }");
                }
                Class clazz2 = this.defineClass(name, bytes, length, classURL);
                return clazz2;
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(name);
            }
            finally {
                if (buf2 != null) {
                    this.releasePoolEntry(buf2);
                }
            }
        }
        if (useClassCache) {
            ++this.m_cacheMisses;
        }
        String classResource = name.replace('.', '/') + ".class";
        classURL = this.getResource(classResource);
        if (trace && classURL != null) {
            Logger.trace1("findClass", "[" + name + "] found in " + classURL);
        }
        if (classURL == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream in = null;
        PoolEntry buf = null;
        try {
            try {
                in = classURL.openStream();
                buf = this.acquirePoolEntry();
                ByteArrayOStream baos = buf.m_baos;
                InstrClassLoader.readFully(in, baos, buf.m_buf);
                in.close();
                in = null;
                byte[] bytes = baos.getByteArray();
                int length = baos.size();
                baos.reset();
                if (this.m_hook != null && this.m_hook.processClassDef(name, bytes, length, baos)) {
                    bytes = baos.getByteArray();
                    length = baos.size();
                    if (trace) {
                        Logger.trace1("findClass", "defining instrumented [" + name + "] {" + length + " bytes }");
                    }
                } else if (trace) {
                    Logger.trace1("findClass", "defining [" + name + "] {" + length + " bytes }");
                }
                clazz = this.defineClass(name, bytes, length, classURL);
                Object var14_22 = null;
                if (buf != null) {
                    this.releasePoolEntry(buf);
                }
                if (in == null) return clazz;
            }
            catch (IOException ioe) {
                throw new ClassNotFoundException(name);
            }
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            if (buf != null) {
                this.releasePoolEntry(buf);
            }
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ignore) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ignore) {
            // empty catch block
            return clazz;
        }
        in.close();
        return clazz;
    }

    public void debugDump(PrintWriter out) {
        if (out != null) {
            out.println(this + ": " + this.m_cacheHits + " class cache hits, " + this.m_cacheMisses + " misses");
        }
    }

    private Class defineClass(String className, byte[] bytes, int length, URL srcURL) {
        CodeSource csrc = new CodeSource(srcURL, null);
        return this.defineClass(className, bytes, 0, length, csrc);
    }

    private static URL[] filesToURLs(File[] classpath) throws MalformedURLException {
        if (classpath == null || classpath.length == 0) {
            return EMPTY_URL_ARRAY;
        }
        URL[] result = new URL[classpath.length];
        for (int f = 0; f < result.length; ++f) {
            result[f] = classpath[f].toURL();
        }
        return result;
    }

    private static void readFully(InputStream in, ByteArrayOStream out, byte[] buf) throws IOException {
        int read;
        while ((read = in.read(buf)) >= 0) {
            out.write(buf, 0, read);
        }
    }

    private PoolEntry acquirePoolEntry() {
        PoolEntry result;
        if (this.m_nestLevel >= 8) {
            result = new PoolEntry(32768, 32768);
        } else {
            result = this.m_bufPool[this.m_nestLevel];
            if (result == null) {
                this.m_bufPool[this.m_nestLevel] = result = new PoolEntry(32768, 32768);
            } else {
                result.m_baos.reset();
            }
        }
        ++this.m_nestLevel;
        return result;
    }

    private void releasePoolEntry(PoolEntry buf) {
        if (--this.m_nestLevel < 8) {
            buf.trim(32768, 0x100000);
        }
    }

    private static final class PoolEntry {
        ByteArrayOStream m_baos;
        final byte[] m_buf;

        PoolEntry(int baosCapacity, int bufSize) {
            this.m_baos = new ByteArrayOStream(baosCapacity);
            this.m_buf = new byte[bufSize];
        }

        void trim(int baosCapacity, int baosMaxCapacity) {
            if (this.m_baos.capacity() > baosMaxCapacity) {
                this.m_baos = new ByteArrayOStream(baosCapacity);
            }
        }
    }
}

