/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative.gui;

import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.text.NumberFormatter;
import plugin.initiative.DiceRollModel;
import plugin.initiative.gui.DiceRollDialog;

public class CheckDialog
extends DiceRollDialog {
    private static int m_defaultDC = 15;
    private JFormattedTextField m_dc;

    public CheckDialog(DiceRollModel diceRollModel) throws HeadlessException {
        super(diceRollModel);
    }

    protected void initDC(String string) {
        NumberFormatter numberFormatter = new NumberFormatter(new DecimalFormat("##"));
        numberFormatter.setValueClass(Integer.class);
        this.m_dc = new JFormattedTextField(numberFormatter);
        this.m_dc.setFocusLostBehavior(1);
        this.m_dc.setValue(m_defaultDC);
        JLabel jLabel = new JLabel("DC:");
        jLabel.setAlignmentX(1.0f);
        this.addComponent(this.m_dc, jLabel);
    }

    protected void initComponents() {
        this.initDC("DC:");
        super.initComponents();
    }

    protected void setResult(int n) {
        this.m_result.setText("<html><body><b>" + n + (n >= (Integer)this.m_dc.getValue() ? " (passed)" : "") + "</b></body></html>");
    }

    protected void initListeners() {
        super.initListeners();
        this.m_dc.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("value".equals(propertyChangeEvent.getPropertyName())) {
                    m_defaultDC = (Integer)CheckDialog.this.m_dc.getValue();
                }
            }
        });
    }
}

