/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.gui.PreferencesPanel;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;

public class PreferencesNotesPanel
extends PreferencesPanel {
    private JPanel dirPanel;
    private JPanel loggingPanel;
    private JTextField dataDirField;
    private JCheckBox logging;
    private JButton browseButton;

    public PreferencesNotesPanel() {
        this.initComponents();
        this.initPreferences();
    }

    public void applyPreferences() {
        SettingsHandler.setGMGenOption((String)"Notes.DataDir", (String)this.getDataDir());
        SettingsHandler.setGMGenOption((String)"Logging.On", (boolean)this.isLogging());
        LogUtilities.inst().setLoggingOn(this.isLogging());
    }

    public void initPreferences() {
        this.setDataDir(SettingsHandler.getGMGenOption((String)"Notes.DataDir", (String)(SettingsHandler.getGmgenPluginDir().toString() + File.separator + "Notes")));
        this.setLogging(SettingsHandler.getGMGenOption((String)"Logging.On", (boolean)false));
    }

    private void setDataDir(String string) {
        this.dataDirField.setText(string);
    }

    private String getDataDir() {
        return this.dataDirField.getText();
    }

    private boolean isLogging() {
        return this.logging.isSelected();
    }

    private void setLogging(boolean bl) {
        this.logging.setSelected(bl);
    }

    public String toString() {
        return "General";
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.dirPanel = new JPanel();
        this.loggingPanel = new JPanel();
        this.dataDirField = new JTextField();
        this.logging = new JCheckBox();
        this.browseButton = new JButton("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesNotesPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.dirPanel = new JPanel();
        this.dirPanel.setLayout(new BoxLayout(this.dirPanel, 1));
        this.dirPanel.setBorder(new TitledBorder("Source Directory"));
        JLabel jLabel = new JLabel();
        jLabel.setText("Notes Data Location");
        this.dataDirField.setPreferredSize(new Dimension(100, 21));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        jPanel4.add(jLabel);
        jPanel4.add(this.dataDirField);
        jPanel4.add(this.browseButton);
        this.dirPanel.add(jPanel4);
        jPanel2.add(this.dirPanel);
        this.loggingPanel = new JPanel();
        this.loggingPanel.setLayout(new BoxLayout(this.loggingPanel, 1));
        this.loggingPanel.setBorder(new TitledBorder("Client"));
        this.logging.setText("Log game data?");
        this.loggingPanel.add(this.logging);
        jPanel3.add(this.loggingPanel);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(jPanel);
        this.add(jScrollPane, "Center");
    }

    protected void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.getDataDir());
        jFileChooser.setFileSelectionMode(1);
        if (jFileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            this.setDataDir(jFileChooser.getSelectedFile().getAbsolutePath());
        }
    }
}

