/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes;

import gmgen.GMGenSystem;
import gmgen.GMGenSystemView;
import gmgen.gui.PreferencesPanel;
import gmgen.io.SimpleFileFilter;
import gmgen.pluginmgr.GMBComponent;
import gmgen.pluginmgr.GMBMessage;
import gmgen.pluginmgr.GMBPlugin;
import gmgen.pluginmgr.GMBus;
import gmgen.pluginmgr.messages.FileOpenMessage;
import gmgen.pluginmgr.messages.FileTypeMessage;
import gmgen.pluginmgr.messages.OpenMessage;
import gmgen.pluginmgr.messages.OpenPCGRequestMessage;
import gmgen.pluginmgr.messages.PreferencesPanelAddMessage;
import gmgen.pluginmgr.messages.StateChangedMessage;
import gmgen.pluginmgr.messages.TabAddMessage;
import gmgen.pluginmgr.messages.ToolMenuItemAddMessage;
import gmgen.pluginmgr.messages.WindowClosedMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.TabbedPaneUtilities;
import pcgen.io.PCGFile;
import plugin.notes.gui.NotesView;
import plugin.notes.gui.PreferencesNotesPanel;

public class NotesPlugin
extends GMBPlugin {
    public static final String LOG_NAME = "Notes";
    private JMenuItem notesToolsItem = new JMenuItem();
    private NotesView theView;
    private String name = "Notes";
    private String version = "01.00.99.01.00";

    public FileFilter getFileType() {
        String[] stringArray = new String[]{"gmn"};
        return new SimpleFileFilter(stringArray, "GMGen Notes File");
    }

    public FileFilter[] getFileTypes() {
        FileFilter[] fileFilterArray = new FileFilter[]{this.getFileType()};
        return fileFilterArray;
    }

    public void start() {
        GMBus.send((GMBMessage)new PreferencesPanelAddMessage((GMBComponent)this, this.name, (PreferencesPanel)new PreferencesNotesPanel()));
        this.theView = new NotesView(this.getDataDir(), this);
        GMBus.send((GMBMessage)new TabAddMessage((GMBComponent)this, this.name, (Component)this.getView(), this.getPluginSystem()));
        this.initMenus();
    }

    public String getPluginSystem() {
        return SettingsHandler.getGMGenOption((String)"Notes.System", (String)"GMGen");
    }

    public int getPluginLoadOrder() {
        return SettingsHandler.getGMGenOption((String)"Notes.LoadOrder", (int)70);
    }

    public String getName() {
        return this.name;
    }

    public boolean isRecognizedFileType(File file) {
        return PCGFile.isPCGenCharacterOrPartyFile((File)file);
    }

    public String getVersion() {
        return this.version;
    }

    public JPanel getView() {
        return this.theView;
    }

    public void handleMessage(GMBMessage gMBMessage) {
        if (gMBMessage instanceof StateChangedMessage) {
            this.handleStateChangedMessage((StateChangedMessage)gMBMessage);
        } else if (gMBMessage instanceof WindowClosedMessage) {
            this.handleWindowClosedMessage();
        } else if (gMBMessage instanceof FileOpenMessage) {
            this.handleFileOpenMessage();
        } else if (gMBMessage instanceof OpenMessage) {
            this.handleOpenMessage((OpenMessage)gMBMessage);
        } else if (gMBMessage instanceof FileTypeMessage) {
            this.handleFileTypeMessage((FileTypeMessage)gMBMessage);
        }
    }

    private void handleFileTypeMessage(FileTypeMessage fileTypeMessage) {
        fileTypeMessage.addFileTypes(this.getFileTypes());
    }

    private void handleOpenMessage(OpenMessage openMessage) {
        File[] fileArray = openMessage.getFile();
        FileFilter fileFilter = this.getFileType();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileFilter.accept(fileArray[i])) continue;
            this.theView.openGMN(fileArray[i]);
        }
    }

    public void loadRecognizedFileType(File file) {
        GMBus.send((GMBMessage)new OpenPCGRequestMessage((GMBComponent)this, file, false));
    }

    public void toolMenuItem(ActionEvent actionEvent) {
        JTabbedPane jTabbedPane = GMGenSystemView.getTabPane();
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            if (!(jTabbedPane.getComponentAt(i) instanceof NotesView)) continue;
            jTabbedPane.setSelectedIndex(i);
        }
    }

    private void handleFileOpenMessage() {
        if (this.isActive()) {
            this.theView.handleOpen();
        }
    }

    private void handleStateChangedMessage(StateChangedMessage stateChangedMessage) {
        StateChangedMessage stateChangedMessage2 = stateChangedMessage;
        if (this.isActive()) {
            this.notesToolsItem.setEnabled(false);
            JMenu jMenu = stateChangedMessage2.getEditMenu();
            if (jMenu != null) {
                this.theView.initEditMenu(jMenu);
            }
            this.theView.refreshTree();
            try {
                GMGenSystem.inst.openFileItem.setEnabled(true);
            }
            catch (Exception exception) {}
        } else {
            this.notesToolsItem.setEnabled(true);
            this.theView.refreshTree();
        }
    }

    private void handleWindowClosedMessage() {
        this.theView.windowClosed();
    }

    public boolean isActive() {
        JTabbedPane jTabbedPane = TabbedPaneUtilities.getTabbedPaneFor((Component)this.theView);
        return jTabbedPane != null && JOptionPane.getFrameForComponent(jTabbedPane).isFocused() && jTabbedPane.getSelectedComponent().equals(this.theView);
    }

    private void initMenus() {
        this.notesToolsItem.setMnemonic('o');
        this.notesToolsItem.setText(LOG_NAME);
        this.notesToolsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesPlugin.this.toolMenuItem(actionEvent);
            }
        });
        GMBus.send((GMBMessage)new ToolMenuItemAddMessage((GMBComponent)this, this.notesToolsItem));
    }

    public String getDataDir() {
        return SettingsHandler.getGMGenOption((String)"Notes.DataDir", (String)super.getDataDir());
    }
}

