/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.util.TripleKeyMapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.list.AbilityList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityLst
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "ABILITY";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        String string2;
        Ability.Nature nature;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string3 = stringTokenizer.nextToken();
        Category category = loadContext.ref.getCategoryFor(ABILITY_CLASS, string3);
        if (category == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " refers to invalid Ability Category: " + string3));
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " must have a Nature, " + "Format is: CATEGORY|NATURE|AbilityName: " + string));
            return false;
        }
        String string4 = stringTokenizer.nextToken();
        try {
            nature = Ability.Nature.valueOf((String)string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " refers to invalid Ability Nature: " + string4));
            return false;
        }
        if (Ability.Nature.ANY.equals((Object)nature)) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " refers to ANY Ability Nature, cannot be used in " + this.getTokenName() + ": " + string));
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " must have abilities, Format is: " + "CATEGORY|NATURE|AbilityName: " + string));
            return false;
        }
        String string5 = stringTokenizer.nextToken();
        if (string5.startsWith("PRE") || string5.startsWith("!PRE")) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot have only PRExxx subtoken in " + this.getTokenName() + ": " + string));
            return false;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CDOMReference cDOMReference = AbilityList.getAbilityListReference((Category)category, (Ability.Nature)nature);
        boolean bl = true;
        boolean bl2 = false;
        do {
            Object object2;
            if (".CLEAR".equals(string5)) {
                if (!bl) {
                    Logging.log((Level)Logging.LST_ERROR, (String)("  Non-sensical " + this.getTokenName() + ": .CLEAR was not the first list item: " + string));
                    return false;
                }
                loadContext.getListContext().removeAllFromList(this.getTokenName(), cDOMObject, cDOMReference);
                bl2 = true;
            } else if (string5.startsWith(".CLEAR.")) {
                string2 = string5.substring(7);
                object2 = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)category, (String)string2);
                if (object2 == null) {
                    return false;
                }
                AssociatedPrereqObject associatedPrereqObject = loadContext.getListContext().removeFromList(this.getTokenName(), cDOMObject, cDOMReference, (CDOMReference)object2);
                associatedPrereqObject.setAssociation(AssociationKey.NATURE, (Object)nature);
                associatedPrereqObject.setAssociation(AssociationKey.CATEGORY, (Object)category);
                bl2 = true;
            } else {
                string2 = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)category, (String)string5);
                if (string2 == null) {
                    return false;
                }
                object2 = loadContext.getListContext().addToList(this.getTokenName(), cDOMObject, cDOMReference, (CDOMReference)string2);
                object2.setAssociation(AssociationKey.NATURE, (Object)nature);
                object2.setAssociation(AssociationKey.CATEGORY, (Object)category);
                if (string5.indexOf(40) != -1) {
                    ArrayList arrayList2 = new ArrayList();
                    AbilityUtilities.getUndecoratedName((String)string5, arrayList2);
                    object2.setAssociation(AssociationKey.ASSOC_CHOICES, arrayList2);
                }
                arrayList.add(object2);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return true;
            }
            bl = false;
        } while (!(string5 = stringTokenizer.nextToken()).startsWith("PRE") && !string5.startsWith("!PRE"));
        if (bl2) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot use PREREQs when using .CLEAR or .CLEAR. in " + this.getTokenName()));
            return false;
        }
        while (true) {
            if ((string2 = this.getPrerequisite(string5)) == null) {
                Logging.log((Level)Logging.LST_ERROR, (String)("   (Did you put feats after the PRExxx tags in " + this.getTokenName() + ":?)"));
                return false;
            }
            for (AssociatedPrereqObject associatedPrereqObject : arrayList) {
                associatedPrereqObject.addPrerequisite((Prerequisite)string2);
            }
            if (!stringTokenizer.hasMoreTokens()) break;
            string5 = stringTokenizer.nextToken();
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Object object;
        Collection collection = loadContext.getListContext().getChangedLists(cDOMObject, AbilityList.class);
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        TripleKeyMapToList tripleKeyMapToList = new TripleKeyMapToList();
        TripleKeyMapToList tripleKeyMapToList2 = new TripleKeyMapToList();
        for (CDOMReference cDOMReference : collection) {
            Category category;
            Ability.Nature nature;
            CDOMDirectSingleRef cDOMDirectSingleRef;
            AssociatedChanges associatedChanges = loadContext.getListContext().getChangesInList(this.getTokenName(), cDOMObject, cDOMReference);
            if (associatedChanges.includesGlobalClear()) {
                cDOMDirectSingleRef = (CDOMDirectSingleRef)cDOMReference;
                AbilityList abilityList = (AbilityList)cDOMDirectSingleRef.resolvesTo();
                Object object2 = new StringBuilder();
                ((StringBuilder)object2).append(abilityList.get(ObjectKey.ABILITY_CAT)).append("|");
                ((StringBuilder)object2).append(abilityList.get(ObjectKey.ABILITY_NATURE)).append("|");
                ((StringBuilder)object2).append(".CLEAR");
                treeSet.add(((StringBuilder)object2).toString());
            }
            if ((cDOMDirectSingleRef = associatedChanges.getAddedAssociations()) != null) {
                for (Object object2 : cDOMDirectSingleRef.getKeySet()) {
                    for (Object object3 : cDOMDirectSingleRef.getListFor(object2)) {
                        nature = (Ability.Nature)object3.getAssociation(AssociationKey.NATURE);
                        category = (Category)object3.getAssociation(AssociationKey.CATEGORY);
                        tripleKeyMapToList.addToListFor((Object)nature, (Object)category, (Object)object3.getPrerequisiteList(), object2);
                    }
                }
            }
            if ((cDOMDirectSingleRef = associatedChanges.getRemovedAssociations()) == null) continue;
            for (Object object2 : cDOMDirectSingleRef.getKeySet()) {
                for (Object object3 : cDOMDirectSingleRef.getListFor(object2)) {
                    nature = (Ability.Nature)object3.getAssociation(AssociationKey.NATURE);
                    category = (Category)object3.getAssociation(AssociationKey.CATEGORY);
                    tripleKeyMapToList2.addToListFor((Object)nature, (Object)category, (Object)object3.getPrerequisiteList(), object2);
                }
            }
        }
        for (CDOMReference cDOMReference : tripleKeyMapToList.getKeySet()) {
            for (CDOMDirectSingleRef cDOMDirectSingleRef : tripleKeyMapToList.getSecondaryKeySet((Object)cDOMReference)) {
                for (Object object2 : tripleKeyMapToList.getTertiaryKeySet((Object)cDOMReference, (Object)cDOMDirectSingleRef)) {
                    Object object3;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(cDOMDirectSingleRef).append("|");
                    ((StringBuilder)object).append(cDOMReference);
                    object3 = tripleKeyMapToList2.removeListFor((Object)cDOMReference, (Object)cDOMDirectSingleRef, object2);
                    if (object3 != null && !object3.isEmpty()) {
                        ((StringBuilder)object).append("|");
                        ((StringBuilder)object).append(".CLEAR.");
                        ((StringBuilder)object).append(ReferenceUtilities.joinLstFormat((Collection)object3, (String)"|.CLEAR."));
                    }
                    ((StringBuilder)object).append("|");
                    ((StringBuilder)object).append(ReferenceUtilities.joinLstFormat((Collection)tripleKeyMapToList.getListFor((Object)cDOMReference, (Object)cDOMDirectSingleRef, object2), (String)"|"));
                    if (object2 != null && !object2.isEmpty()) {
                        ((StringBuilder)object).append("|");
                        ((StringBuilder)object).append(this.getPrerequisiteString(loadContext, (Collection)object2));
                    }
                    treeSet.add(((StringBuilder)object).toString());
                }
            }
        }
        for (CDOMReference cDOMReference : tripleKeyMapToList2.getKeySet()) {
            for (CDOMDirectSingleRef cDOMDirectSingleRef : tripleKeyMapToList2.getSecondaryKeySet((Object)cDOMReference)) {
                for (Object object2 : tripleKeyMapToList2.getTertiaryKeySet((Object)cDOMReference, (Object)cDOMDirectSingleRef)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(cDOMDirectSingleRef).append("|");
                    ((StringBuilder)object).append(cDOMReference).append("|").append(".CLEAR.");
                    ((StringBuilder)object).append(ReferenceUtilities.joinLstFormat((Collection)tripleKeyMapToList2.getListFor((Object)cDOMReference, (Object)cDOMDirectSingleRef, object2), (String)"|.CLEAR."));
                    if (object2 != null && !object2.isEmpty()) {
                        ((StringBuilder)object).append("|");
                        ((StringBuilder)object).append(this.getPrerequisiteString(loadContext, (Collection)object2));
                    }
                    treeSet.add(((StringBuilder)object).toString());
                }
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

