/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.TreeMapToList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.StringPClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServesAsToken
extends AbstractToken
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "SERVESAS";
    }

    public List<Class<? extends PObject>> getLegalTypes() {
        return Arrays.asList(PCClass.class, Ability.class, Skill.class, Race.class);
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        if (!this.getLegalTypes().contains(cDOMObject.getClass())) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Cannot use SERVESAS on a " + cDOMObject.getClass()));
            Logging.log((Level)Logging.LST_ERROR, (String)("   bad use found in " + cDOMObject.getClass().getSimpleName() + " " + cDOMObject.getKeyName()));
            return false;
        }
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = stringTokenizer.nextToken();
        ReferenceManufacturer referenceManufacturer = loadContext.getManufacturer(string2);
        if (referenceManufacturer == null) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " unable to generate manufacturer for type: " + string));
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " must include at least one target object"));
            return false;
        }
        if (!referenceManufacturer.getReferenceClass().equals(cDOMObject.getClass())) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " expecting a POBJECT Type valid for " + cDOMObject.getClass().getSimpleName() + ", found: " + string2));
            return false;
        }
        String string3 = StringPClassUtil.getStringFor(cDOMObject.getClass());
        ListKey listKey = ListKey.getKeyFor(CDOMReference.class, (String)("SERVES_AS_" + string3));
        while (stringTokenizer.hasMoreTokens()) {
            CDOMSingleRef cDOMSingleRef = referenceManufacturer.getReference(stringTokenizer.nextToken());
            loadContext.obj.addToList(cDOMObject, listKey, (Object)cDOMSingleRef);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Object object;
        String string = StringPClassUtil.getStringFor(cDOMObject.getClass());
        ListKey listKey = ListKey.getKeyFor(CDOMReference.class, (String)("SERVES_AS_" + string));
        Changes changes = loadContext.obj.getListChanges(cDOMObject, listKey);
        Collection collection = changes.getRemoved();
        if (collection != null && !collection.isEmpty() || changes.includesGlobalClear()) {
            loadContext.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
            return null;
        }
        Collection collection2 = changes.getAdded();
        if (collection2 == null || collection2.isEmpty()) {
            return null;
        }
        TreeMapToList treeMapToList = new TreeMapToList();
        for (Object object2 : collection2) {
            String string2 = string;
            if (CategorizedCDOMObject.class.isAssignableFrom(cDOMObject.getClass())) {
                object = ((CategorizedCDOMReference)object2).getCDOMCategory();
                string2 = AbilityCategory.FEAT.equals(object) ? "FEAT" : string2 + '=' + object.toString();
            }
            treeMapToList.addToListFor((Object)string2, (Object)object2.getLSTformat());
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : treeMapToList.getKeySet()) {
            object = new TreeSet(treeMapToList.getListFor((Object)string2));
            arrayList.add(string2 + '|' + StringUtil.joinToStringBuffer((Collection)object, (String)"|"));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

