/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.math.BigDecimal;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.BigDecimalHelper;

public class EqContainersToken
extends Token {
    public static final String TOKENNAME = "EQCONTAINERS";
    public static final String INDENT = "\t";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        stringTokenizer.nextToken();
        Equipment equipment = null;
        if (stringTokenizer.hasMoreElements()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                equipment = this.getContainer(playerCharacter, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (equipment != null) {
            String string3 = "NAME";
            if (stringTokenizer.hasMoreElements()) {
                string3 = stringTokenizer.nextToken();
            }
            if (string3.equals("ACCHECK")) {
                string2 = Integer.toString(EqContainersToken.getAcCheckToken(playerCharacter, equipment));
            } else if (string3.equals("ACMOD")) {
                string2 = Integer.toString(EqContainersToken.getAcModToken(playerCharacter, equipment));
            } else if (string3.equals("ALTCRIT")) {
                string2 = EqContainersToken.getAltCritToken(equipment);
            } else if (string3.equals("ALTDAMAGE")) {
                string2 = EqContainersToken.getAltDamageToken(playerCharacter, equipment);
            } else if (string3.equals("ATTACKS")) {
                string2 = Double.toString(EqContainersToken.getAttacksToken(playerCharacter, equipment));
            } else if (string3.equals("CARRIED")) {
                string2 = Float.toString(EqContainersToken.getCarriedToken(equipment));
            } else if (string3.equals("CONTENTS")) {
                string2 = EqContainersToken.getContentsToken(equipment, stringTokenizer);
            } else if (string3.equals("CONTENTWEIGHT")) {
                string2 = BigDecimalHelper.trimZeros((String)Float.toString(EqContainersToken.getContentWeightToken(playerCharacter, equipment)));
            } else if (string3.equals("COST")) {
                string2 = BigDecimalHelper.trimZeros((BigDecimal)EqContainersToken.getCostToken(playerCharacter, equipment));
            } else if (string3.equals("CRITMULT")) {
                string2 = EqContainersToken.getCritMultToken(equipment);
            } else if (string3.equals("CRITRANGE")) {
                string2 = EqContainersToken.getCritRangeToken(playerCharacter, equipment);
            } else if (string3.equals("DAMAGE")) {
                string2 = EqContainersToken.getDamageToken(playerCharacter, equipment);
            } else if (string3.equals("EDR")) {
                string2 = Integer.toString(EqContainersToken.getEdrToken(playerCharacter, equipment));
            } else if (string3.equals("EQUIPPED")) {
                string2 = EqContainersToken.getEquippedToken(equipment);
            } else if (string3.equals("ITEMWEIGHT")) {
                string2 = BigDecimalHelper.trimZeros((String)Float.toString(EqContainersToken.getItemWeightToken(playerCharacter, equipment)));
            } else if (string3.equals("LOCATION")) {
                string2 = EqContainersToken.getLocationToken(equipment);
            } else if (string3.equals("LONGNAME")) {
                string2 = EqContainersToken.getLongNameToken(equipment);
            } else if (string3.equals("MAXDEX")) {
                string2 = Integer.toString(EqContainersToken.getMaxDexToken(playerCharacter, equipment));
            } else if (string3.equals("MOVE")) {
                string2 = EqContainersToken.getMoveToken(equipment);
            } else if (string3.equals("NAME") || string3.equals("OUTPUTNAME")) {
                string2 = EqContainersToken.getNameToken(equipment, playerCharacter);
            } else if (string3.equals("PROF")) {
                string2 = equipment.consolidatedProfName();
            } else if (string3.equals("QTY")) {
                string2 = BigDecimalHelper.trimZeros((String)Double.toString(EqContainersToken.getQuantityToken(equipment)));
            } else if (string3.equals("RANGE")) {
                string2 = Integer.toString(EqContainersToken.getRangeToken(equipment, playerCharacter));
            } else if (string3.equals("SIZE")) {
                string2 = EqContainersToken.getSizeToken(equipment);
            } else if (string3.equals("SPELLFAILURE")) {
                string2 = Integer.toString(EqContainersToken.getSpellFailureToken(playerCharacter, equipment));
            } else if (string3.equals("SPROP")) {
                string2 = EqContainersToken.getSPropToken(playerCharacter, equipment);
            } else if (string3.equals("TOTALWEIGHT") || string3.equals("WT")) {
                string2 = BigDecimalHelper.trimZeros((String)Float.toString(EqContainersToken.getTotalWeightToken(playerCharacter, equipment)));
            } else if (string3.equals("TYPE")) {
                string2 = EqContainersToken.getTypeToken(equipment, stringTokenizer);
            }
        }
        return string2;
    }

    public static int getAcCheckToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.acCheck(playerCharacter);
    }

    public static int getAcModToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getACMod(playerCharacter);
    }

    public static String getAltCritToken(Equipment equipment) {
        return equipment.getAltCritMult();
    }

    public static String getAltDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getAltDamage(playerCharacter);
    }

    public static double getAttacksToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.bonusTo(playerCharacter, "COMBAT", "ATTACKS", true);
    }

    public static float getCarriedToken(Equipment equipment) {
        return equipment.numberCarried().floatValue();
    }

    public static String getContentsToken(Equipment equipment, StringTokenizer stringTokenizer) {
        String string = "";
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = "NAME";
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            string = equipment.getContainerByType(string2, string3);
        } else {
            string = equipment.getContainerContentsString();
        }
        return string;
    }

    public static float getContentWeightToken(PlayerCharacter playerCharacter, Equipment equipment) {
        if (equipment.getChildCount() == 0) {
            return 0.0f;
        }
        return equipment.getContainedWeight(playerCharacter).floatValue();
    }

    public static BigDecimal getCostToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getCost(playerCharacter);
    }

    public static String getCritMultToken(Equipment equipment) {
        return equipment.getCritMult();
    }

    public static String getCritRangeToken(PlayerCharacter playerCharacter, Equipment equipment) {
        int n = playerCharacter.getCritRange(equipment, true);
        return n == 0 ? "" : Integer.toString(n);
    }

    public static String getDamageToken(PlayerCharacter playerCharacter, Equipment equipment) {
        String string = equipment.getDamage(playerCharacter);
        if (playerCharacter != null && equipment.isNatural()) {
            string = Globals.adjustDamage((String)string, (int)playerCharacter.getRace().getSafe(FormulaKey.SIZE).resolve(playerCharacter, "").intValue(), (int)playerCharacter.sizeInt());
        }
        return string;
    }

    public static int getEdrToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.eDR(playerCharacter);
    }

    public static String getEquippedToken(Equipment equipment) {
        if (equipment.isEquipped()) {
            return "Y";
        }
        return "N";
    }

    public static float getItemWeightToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getWeight(playerCharacter).floatValue();
    }

    public static String getLocationToken(Equipment equipment) {
        return equipment.getParentName();
    }

    public static String getLongNameToken(Equipment equipment) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = equipment.itemDepth(); i > 0; --i) {
            stringBuffer.append(INDENT);
        }
        stringBuffer.append(equipment.longName());
        return stringBuffer.toString();
    }

    public static int getMaxDexToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getMaxDex(playerCharacter);
    }

    public static String getMoveToken(Equipment equipment) {
        return equipment.moveString();
    }

    public static String getNameToken(Equipment equipment, PlayerCharacter playerCharacter) {
        return OutputNameFormatting.parseOutputName((String)equipment.getOutputName(), (PlayerCharacter)playerCharacter);
    }

    public static double getQuantityToken(Equipment equipment) {
        return equipment.qty();
    }

    public static int getRangeToken(Equipment equipment, PlayerCharacter playerCharacter) {
        return equipment.getRange(playerCharacter);
    }

    public static String getSizeToken(Equipment equipment) {
        return equipment.getSize();
    }

    public static int getSpellFailureToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.spellFailure(playerCharacter);
    }

    public static String getSPropToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return equipment.getSpecialProperties(playerCharacter);
    }

    public static float getTotalWeightToken(PlayerCharacter playerCharacter, Equipment equipment) {
        return EqContainersToken.getContentWeightToken(playerCharacter, equipment) + EqContainersToken.getItemWeightToken(playerCharacter, equipment);
    }

    public static String getTypeToken(Equipment equipment, StringTokenizer stringTokenizer) {
        String string = "";
        if (stringTokenizer.hasMoreTokens()) {
            try {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                string = equipment.typeIndex(n);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            string = equipment.getType();
        }
        return string;
    }

    private Equipment getContainer(PlayerCharacter playerCharacter, int n) {
        for (Equipment equipment : playerCharacter.getEquipmentListInOutputOrder()) {
            if (equipment.isContainer()) {
                --n;
            }
            if (n >= 0) continue;
            return equipment;
        }
        return null;
    }
}

