/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import pcgen.base.formula.AddingFormula;
import pcgen.base.formula.DividingFormula;
import pcgen.base.formula.MultiplyingFormula;
import pcgen.base.formula.ReferenceFormula;
import pcgen.base.formula.SubtractingFormula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.HitDie;
import pcgen.cdom.content.Modifier;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.modifier.ContextModifier;
import pcgen.cdom.modifier.HitDieFormula;
import pcgen.cdom.modifier.HitDieLock;
import pcgen.cdom.modifier.HitDieStep;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitdieToken
extends AbstractToken
implements CDOMPrimaryToken<PCTemplate> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;

    public String getTokenName() {
        return "HITDIE";
    }

    public boolean parse(LoadContext loadContext, PCTemplate pCTemplate, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        try {
            int n;
            String string2;
            String string3 = string;
            int n2 = string3.indexOf("|");
            if (n2 != string3.lastIndexOf("|")) {
                Logging.errorPrint((String)(this.getTokenName() + " has more than one pipe, " + "is not of format: <int>[|<prereq>]"));
                return false;
            }
            CDOMSingleRef cDOMSingleRef = null;
            if (n2 != -1) {
                String string4;
                string2 = string3.substring(n2 + 1);
                if (string2.startsWith("CLASS.TYPE=")) {
                    string4 = string3.substring(n2 + 12);
                    if (string4.length() == 0) {
                        Logging.errorPrint((String)("Cannot have Empty Type Limitation in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                    if (this.hasIllegalSeparator('.', string4)) {
                        return false;
                    }
                    cDOMSingleRef = loadContext.ref.getCDOMTypeReference(PCCLASS_CLASS, string4.split("\\."));
                } else if (string2.startsWith("CLASS=")) {
                    string4 = string3.substring(n2 + 7);
                    if (string4.length() == 0) {
                        Logging.errorPrint((String)("Cannot have Empty Class Limitation in " + this.getTokenName() + ": " + string));
                        return false;
                    }
                    cDOMSingleRef = loadContext.ref.getCDOMReference(PCCLASS_CLASS, string4);
                } else {
                    Logging.errorPrint((String)("Invalid Limitation in HITDIE: " + string2));
                    return false;
                }
                string3 = string3.substring(0, n2);
            }
            if (string3.startsWith("%/")) {
                n = Integer.parseInt(string3.substring(2));
                if (n <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive Integer " + "for dividing Lock, was : " + string3.substring(2)));
                    return false;
                }
                string2 = new HitDieFormula((ReferenceFormula)new DividingFormula(n));
            } else if (string3.startsWith("%*")) {
                n = Integer.parseInt(string3.substring(2));
                if (n <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive " + "Integer for multiplying Lock, was : " + string3.substring(2)));
                    return false;
                }
                string2 = new HitDieFormula((ReferenceFormula)new MultiplyingFormula(n));
            } else if (string3.startsWith("%+")) {
                n = Integer.parseInt(string3.substring(2));
                if (n <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive " + "Integer for adding Lock, was : " + string3.substring(2)));
                    return false;
                }
                string2 = new HitDieFormula((ReferenceFormula)new AddingFormula(n));
            } else if (string3.startsWith("%-")) {
                n = Integer.parseInt(string3.substring(2));
                if (n <= 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " was expecting a Positive " + "Integer for subtracting Lock, was : " + string3.substring(2)));
                    return false;
                }
                string2 = new HitDieFormula((ReferenceFormula)new SubtractingFormula(n));
            } else if (string3.startsWith("%up")) {
                n = Integer.parseInt(string3.substring(3));
                if (n <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n + " in " + this.getTokenName() + " up (must be positive)"));
                    return false;
                }
                if (n >= 5) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n + " in " + this.getTokenName() + " up (too large)"));
                    return false;
                }
                string2 = new HitDieStep(n, new HitDie(12));
            } else if (string3.startsWith("%Hup")) {
                n = Integer.parseInt(string3.substring(4));
                if (n <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n + " in " + this.getTokenName()));
                    return false;
                }
                string2 = new HitDieStep(n, null);
            } else if (string3.startsWith("%down")) {
                n = Integer.parseInt(string3.substring(5));
                if (n <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n + " in " + this.getTokenName() + " down (must be positive)"));
                    return false;
                }
                if (n >= 5) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n + " in " + this.getTokenName() + " down (too large)"));
                    return false;
                }
                string2 = new HitDieStep(-n, new HitDie(4));
            } else if (string3.startsWith("%Hdown")) {
                n = Integer.parseInt(string3.substring(6));
                if (n <= 0) {
                    Logging.errorPrint((String)("Invalid Step Count: " + n + " in " + this.getTokenName()));
                    return false;
                }
                string2 = new HitDieStep(-n, null);
            } else {
                n = Integer.parseInt(string3);
                if (n <= 0) {
                    Logging.errorPrint((String)("Invalid HitDie: " + n + " in " + this.getTokenName()));
                    return false;
                }
                string2 = new HitDieLock(new HitDie(n));
            }
            String string5 = cDOMSingleRef == null ? string2 : new ContextModifier((Modifier)string2, cDOMSingleRef);
            loadContext.getObjectContext().put((CDOMObject)pCTemplate, ObjectKey.HITDIE, (Object)string5);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint((String)("Invalid Number in " + this.getTokenName() + ": " + numberFormatException.getLocalizedMessage()));
            Logging.errorPrint((String)"  Must be an Integer");
            return false;
        }
    }

    public String[] unparse(LoadContext loadContext, PCTemplate pCTemplate) {
        Modifier modifier = (Modifier)loadContext.getObjectContext().getObject((CDOMObject)pCTemplate, ObjectKey.HITDIE);
        if (modifier == null) {
            return null;
        }
        return new String[]{modifier.getLSTformat()};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

