/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.remove;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.choiceset.AbilityFromClassChoiceSet;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.choiceset.CompoundOrChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.AbilityRef;
import pcgen.cdom.helper.AbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatToken
extends AbstractToken
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<AbilitySelection> {
    private static final Class<PCClass> PCCLASS_CLASS = PCClass.class;
    private static final Class<AbilitySelection> ABILITY_SELECTION_CLASS = AbilitySelection.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getParentToken() {
        return "REMOVE";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    public String getTokenName() {
        return "FEAT";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        String string2;
        String string3;
        Object object;
        Object object2;
        String string4;
        Formula formula;
        if (string.length() == 0) {
            Logging.errorPrint((String)(this.getFullName() + " may not have empty argument"));
            return false;
        }
        AbilityCategory abilityCategory = AbilityCategory.FEAT;
        Ability.Nature nature = Ability.Nature.NORMAL;
        int n = string.indexOf("|");
        if (n == -1) {
            formula = FormulaFactory.ONE;
            string4 = string;
        } else {
            object2 = string.substring(0, n);
            formula = FormulaFactory.getFormulaFor((String)object2);
            if (formula.isStatic() && formula.resolve(null, "").doubleValue() <= 0.0) {
                Logging.errorPrint((String)("Count in " + this.getFullName() + " must be > 0"));
                return false;
            }
            string4 = string.substring(n + 1);
        }
        if (this.isEmpty(string4) || this.hasIllegalSeparator(',', string4)) {
            return false;
        }
        object2 = new ArrayList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        boolean bl = false;
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            Object object3;
            object = null;
            string3 = stringTokenizer.nextToken();
            if ("CHOICE".equals(string3) || "ANY".equals(string3)) {
                bl = true;
                object = loadContext.ref.getCDOMAllReference(ABILITY_CLASS, (Category)abilityCategory);
            } else if (string3.startsWith("CLASS.") || string3.startsWith("CLASS=")) {
                string2 = string3.substring(6);
                if (string2.length() == 0) {
                    Logging.errorPrint((String)(this.getTokenName() + " must have Class name after " + string3));
                    return false;
                }
                object3 = loadContext.ref.getCDOMReference(PCCLASS_CLASS, string2);
                AbilityFromClassChoiceSet abilityFromClassChoiceSet = new AbilityFromClassChoiceSet((CDOMSingleRef)object3);
                arrayList.add(abilityFromClassChoiceSet);
            } else {
                bl2 = true;
                object = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)abilityCategory, (String)string3);
                if (object == null) {
                    Logging.errorPrint((String)("  Error was encountered while parsing " + this.getTokenName() + ": " + string + " had an invalid reference: " + string3));
                    return false;
                }
            }
            if (object == null) continue;
            string2 = new AbilityRef((CDOMReference)object);
            object2.add(string2);
            if (string3.indexOf(40) == -1) continue;
            object3 = new ArrayList();
            AbilityUtilities.getUndecoratedName((String)string3, (Collection)object3);
            if (object3.size() != 1) {
                Logging.errorPrint((String)("Invalid use of multiple items in parenthesis (comma prohibited) in " + this.getFullName() + ": " + string3));
                return false;
            }
            string2.setChoice((String)object3.get(0));
        }
        if (bl && bl2) {
            Logging.errorPrint((String)("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + string));
            return false;
        }
        if (!object2.isEmpty()) {
            object = new AbilityRefChoiceSet((Category)abilityCategory, (Collection)object2, nature);
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            Logging.errorPrint((String)("Internal Error: " + this.getFullName() + " did not have any references: " + string));
            return false;
        }
        object = arrayList.size() == 1 ? (PrimitiveChoiceSet)arrayList.get(0) : new CompoundOrChoiceSet(arrayList);
        string3 = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)object, true);
        string2 = new PersistentTransitionChoice((ChoiceSet)string3, formula);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.REMOVE, (Object)string2);
        string2.setTitle("Select for removal");
        string2.allowStack(true);
        string2.setChoiceActor((ChoiceActor)this);
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.REMOVE);
        Collection collection = changes.getAdded();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PersistentTransitionChoice persistentTransitionChoice : collection) {
            ChoiceSet choiceSet = persistentTransitionChoice.getChoices();
            if (!this.getTokenName().equals(choiceSet.getName()) || !ABILITY_SELECTION_CLASS.equals(choiceSet.getChoiceClass())) continue;
            Formula formula = persistentTransitionChoice.getCount();
            if (formula == null) {
                loadContext.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!FormulaFactory.ONE.equals(formula)) {
                stringBuilder.append(formula).append("|");
            }
            stringBuilder.append(choiceSet.getLSTformat());
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject cDOMObject, AbilitySelection abilitySelection, PlayerCharacter playerCharacter) {
        AbilityUtilities.modFeat((PlayerCharacter)playerCharacter, null, (String)abilitySelection.getFullAbilityKey(), (boolean)false, (boolean)false);
        double d = ((BigDecimal)abilitySelection.getAbility().getSafe(ObjectKey.SELECTION_COST)).doubleValue();
        playerCharacter.adjustAbilities(AbilityCategory.FEAT, BigDecimal.valueOf(-d));
    }

    public boolean allow(AbilitySelection abilitySelection, PlayerCharacter playerCharacter, boolean bl) {
        for (Ability ability : playerCharacter.getRealFeatList()) {
            Boolean bl2;
            if (!ability.getKeyName().equals(abilitySelection.getAbilityKey()) || (bl2 = (Boolean)ability.getSafe(ObjectKey.MULTIPLE_ALLOWED)).booleanValue() && (!bl2.booleanValue() || !this.hasAssoc(playerCharacter.getAssociationList((CDOMObject)ability), abilitySelection))) continue;
            return true;
        }
        return false;
    }

    private boolean hasAssoc(List<String> list, AbilitySelection abilitySelection) {
        if (list == null) {
            Logging.errorPrint((String)("Didn't have any associations for Ability: " + abilitySelection.getAbilityKey()));
            return false;
        }
        for (String string : list) {
            if (!abilitySelection.containsAssociation(string)) continue;
            return true;
        }
        return false;
    }

    public AbilitySelection decodeChoice(String string) {
        return AbilitySelection.getAbilitySelectionFromPersistentFormat((String)string);
    }

    public String encodeChoice(Object object) {
        return ((AbilitySelection)object).getPersistentFormat();
    }

    public void restoreChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
    }

    public void removeChoice(PlayerCharacter playerCharacter, CDOMObject cDOMObject, AbilitySelection abilitySelection) {
        AbilityUtilities.modFeat((PlayerCharacter)playerCharacter, null, (String)abilitySelection.getFullAbilityKey(), (boolean)false, (boolean)true);
    }
}

