/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.ant.FilterTask;
import com.vladium.emma.instr.InstrProcessor;
import com.vladium.util.asserts.;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public final class instrTask
extends FilterTask {
    private Path m_instrpath;
    private InstrProcessor.OutMode m_outMode = InstrProcessor.OutMode.OUT_MODE_COPY;
    private File m_outDir;
    private File m_outFile;
    private Boolean m_outFileMerge;

    public void execute() throws BuildException {
        if (this.isEnabled()) {
            if (this.m_instrpath == null) {
                throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": instrumentation path must be specified", this.location).fillInStackTrace();
            }
            if (this.m_outMode != InstrProcessor.OutMode.OUT_MODE_OVERWRITE && this.m_outDir == null) {
                throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": output directory must be specified for '" + this.m_outMode + "' output mode", this.location).fillInStackTrace();
            }
            InstrProcessor processor = InstrProcessor.create();
            .assert.ASSERT((this.m_instrpath != null ? 1 : 0) != 0, (String)"m_instrpath not set");
            processor.setInstrPath(this.m_instrpath.list(), true);
            processor.setInclExclFilter(this.getFilterSpecs());
            .assert.ASSERT((this.m_outMode != null ? 1 : 0) != 0, (String)"m_outMode not set");
            processor.setOutMode(this.m_outMode);
            processor.setInstrOutDir(this.m_outDir != null ? this.m_outDir.getAbsolutePath() : null);
            processor.setMetaOutFile(this.m_outFile != null ? this.m_outFile.getAbsolutePath() : null);
            processor.setMetaOutMerge(this.m_outFileMerge);
            processor.setPropertyOverrides(this.getTaskSettings());
            processor.run();
        }
    }

    public void setInstrpath(Path path) {
        if (this.m_instrpath == null) {
            this.m_instrpath = path;
        } else {
            this.m_instrpath.append(path);
        }
    }

    public void setInstrpathRef(Reference ref) {
        this.createInstrpath().setRefid(ref);
    }

    public Path createInstrpath() {
        if (this.m_instrpath == null) {
            this.m_instrpath = new Path(this.project);
        }
        return this.m_instrpath.createPath();
    }

    public void setOutdir(File dir) {
        if (this.m_outDir != null) {
            throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": outdir|destdir attribute already set", this.location).fillInStackTrace();
        }
        this.m_outDir = dir;
    }

    public void setDestdir(File dir) {
        if (this.m_outDir != null) {
            throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": outdir|destdir attribute already set", this.location).fillInStackTrace();
        }
        this.m_outDir = dir;
    }

    public void setMetadatafile(File file) {
        if (this.m_outFile != null) {
            throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": metadata file attribute already set", this.location).fillInStackTrace();
        }
        this.m_outFile = file;
    }

    public void setOutfile(File file) {
        if (this.m_outFile != null) {
            throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": metadata file attribute already set", this.location).fillInStackTrace();
        }
        this.m_outFile = file;
    }

    public void setMerge(boolean merge) {
        this.m_outFileMerge = merge ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setMode(ModeAttribute mode) {
        InstrProcessor.OutMode outMode = InstrProcessor.OutMode.nameToMode((String)mode.getValue());
        if (outMode == null) {
            throw (BuildException)instrTask.newBuildException(this.getTaskName() + ": invalid output mode: " + mode.getValue(), this.location).fillInStackTrace();
        }
        this.m_outMode = outMode;
    }

    public static final class ModeAttribute
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"copy", "overwrite", "fullcopy"};

        public String[] getValues() {
            return VALUES;
        }
    }
}

