/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.EqModControl;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModsToken
extends AbstractToken
implements CDOMPrimaryToken<Equipment> {
    public String getTokenName() {
        return "MODS";
    }

    public boolean parse(LoadContext loadContext, Equipment equipment, String string) {
        EqModControl eqModControl;
        if (this.isEmpty(string)) {
            return false;
        }
        try {
            eqModControl = EqModControl.valueOf((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.deprecationPrint((String)("Invalid Mod Control provided in " + this.getTokenName() + ": " + string));
            switch (string.charAt(0)) {
                case 'R': 
                case 'r': {
                    Logging.deprecationPrint((String)("Use REQUIRED instead of " + string));
                    eqModControl = EqModControl.REQUIRED;
                    break;
                }
                case 'Y': 
                case 'y': {
                    Logging.deprecationPrint((String)("Use YES instead of " + string));
                    eqModControl = EqModControl.YES;
                    break;
                }
                case 'N': 
                case 'n': {
                    Logging.deprecationPrint((String)("Use NO instead of " + string));
                    eqModControl = EqModControl.NO;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        loadContext.getObjectContext().put((CDOMObject)equipment, ObjectKey.MOD_CONTROL, (Object)eqModControl);
        return true;
    }

    public String[] unparse(LoadContext loadContext, Equipment equipment) {
        EqModControl eqModControl = (EqModControl)loadContext.getObjectContext().getObject((CDOMObject)equipment, ObjectKey.MOD_CONTROL);
        if (eqModControl == null) {
            return null;
        }
        return new String[]{eqModControl.toString()};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

