/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import pcgen.util.PJEP;

public class PjepPool {
    private Stack<PJEP> freeStack = new Stack();
    private List<PJEP> usedList = new ArrayList<PJEP>();
    private static PjepPool instance = new PjepPool();

    private PjepPool() {
    }

    public static PjepPool getInstance() {
        return instance;
    }

    public synchronized void initialise() {
        this.freeStack.push(new PJEP());
    }

    public synchronized PJEP aquire() {
        return this.aquire(null, "");
    }

    public synchronized PJEP aquire(Object object, String string) {
        PJEP pJEP = this.freeStack.size() > 0 ? this.freeStack.pop() : new PJEP();
        this.usedList.add(pJEP);
        pJEP.initSymTab();
        pJEP.setVariableSource(string);
        pJEP.setParent(object);
        return pJEP;
    }

    public synchronized void release(PJEP pJEP) {
        if (this.usedList.contains((Object)pJEP)) {
            this.usedList.remove((Object)pJEP);
        } else {
            System.err.println("Tried to release a PJEP instance that we did not aquire...");
        }
        this.freeStack.push(pJEP);
    }

    public synchronized void dumpStats() {
        System.out.println("PJEP Pool: ");
        System.out.println("    Currently Unused: " + this.freeStack.size());
        System.out.println("    Currently Used  : " + this.usedList.size());
    }
}

