/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.List;
import java.util.Map;
import pcgen.core.GameMode;
import pcgen.core.PCStat;
import pcgen.core.SettingsHandler;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.StatsAndChecksLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class StatsAndChecksLoader
extends LstLineFileLoader {
    public void loadLstFile(LoadContext loadContext, URI uRI) throws PersistenceLayerException {
        GameMode gameMode = SettingsHandler.getGame();
        gameMode.setAttribLong(null);
        gameMode.setAttribShort(null);
        gameMode.clearCheckList();
        gameMode.clearAlignmentList();
        gameMode.clearStatList();
        super.loadLstFile(loadContext, uRI);
        List<PCStat> list = gameMode.getUnmodifiableStatList();
        int n = list.size();
        gameMode.setAttribLong(new String[n]);
        gameMode.setAttribShort(new String[n]);
        for (int i = 0; i < n; ++i) {
            PCStat pCStat = list.get(i);
            gameMode.setAttribLong(i, pCStat.getDisplayName());
            gameMode.setAttribShort(i, pCStat.getAbb());
        }
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) {
        int n = string.indexOf(58);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(StatsAndChecksLstToken.class);
        StatsAndChecksLstToken statsAndChecksLstToken = (StatsAndChecksLstToken)map.get(string2);
        if (statsAndChecksLstToken != null) {
            LstUtils.deprecationCheck(statsAndChecksLstToken, string2, uRI, string);
            if (!statsAndChecksLstToken.parse(loadContext, string, uRI)) {
                Logging.errorPrint("Error parsing StatsAndChecks object: " + string + '/' + uRI.toString());
            }
        } else {
            Logging.errorPrint("Illegal StatsAndChecks object: " + string + '/' + uRI.toString());
        }
    }
}

