/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpellLoader
extends LstObjectFileLoader<Spell> {
    @Override
    public Spell parseLine(LoadContext loadContext, Spell spell, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        StringTokenizer stringTokenizer;
        Spell spell2 = spell;
        boolean bl = false;
        if (spell2 == null) {
            spell2 = new Spell();
            bl = true;
        }
        if ((stringTokenizer = new StringTokenizer(string, "\t")).hasMoreTokens()) {
            spell2.setName(stringTokenizer.nextToken());
            spell2.setSourceCampaign(campaignSourceEntry.getCampaign());
            spell2.setSourceURI(campaignSourceEntry.getURI());
            if (bl) {
                loadContext.addStatefulInformation(spell2);
                loadContext.ref.importObject(spell2);
            }
        }
        while (stringTokenizer.hasMoreElements()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in spell " + spell2.getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: " + string3);
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processToken(spell2, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
        this.completeObject(loadContext, campaignSourceEntry, spell2);
        return null;
    }

    @Override
    protected Spell getObjectKeyed(LoadContext loadContext, String string) {
        return Globals.getSpellKeyed(string);
    }

    @Override
    protected void finishObject(PObject pObject) {
    }

    @Override
    protected void performForget(LoadContext loadContext, Spell spell) {
        super.performForget(loadContext, spell);
        Globals.removeFromSpellMap(spell.getKeyName());
    }

    @Override
    protected void addGlobalObject(PObject pObject) {
        Object obj = Globals.getSpellMap().get(pObject.getKeyName());
        if (obj == null) {
            Globals.addToSpellMap(pObject.getKeyName(), pObject);
        } else {
            ArrayList<Spell> arrayList;
            if (obj instanceof Spell) {
                arrayList = new ArrayList<Spell>();
                Globals.removeFromSpellMap(((Spell)obj).getKeyName());
                Globals.addToSpellMap(pObject.getKeyName(), arrayList);
                arrayList.add((Spell)obj);
            } else {
                arrayList = (ArrayList<Spell>)obj;
            }
            arrayList.add((Spell)pObject);
        }
    }
}

