/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.cdom.base.Constants;
import pcgen.core.GameMode;
import pcgen.core.PointBuyCost;
import pcgen.core.PointBuyMethod;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PointBuyLstToken;
import pcgen.persistence.lst.PointBuyMethodLstToken;
import pcgen.persistence.lst.PointBuyStatLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class PointBuyLoader
extends LstLineFileLoader {
    public void parseLine(LoadContext loadContext, String string, URI uRI) {
        GameMode gameMode = SystemCollections.getGameModeNamed(this.getGameMode());
        int n = string.indexOf(58);
        if (n < 0) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PointBuyLstToken.class);
        PointBuyLstToken pointBuyLstToken = (PointBuyLstToken)map.get(string2);
        if (pointBuyLstToken != null) {
            LstUtils.deprecationCheck(pointBuyLstToken, gameMode.getName(), uRI, string3);
            if (!pointBuyLstToken.parse(gameMode, string3, uRI)) {
                Logging.errorPrint("Error parsing point buy method " + gameMode.getName() + '/' + uRI.toString() + ':' + " \"" + string + "\"");
            }
        } else {
            Logging.errorPrint("Illegal point buy method info " + gameMode.getName() + '/' + uRI.toString() + ':' + " \"" + string + "\"");
        }
    }

    public static boolean parseStatLine(GameMode gameMode, String string, URI uRI) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("NumberFormatException in Point Buy Line:" + Constants.s_LINE_SEP, numberFormatException);
            return true;
        }
        PointBuyCost pointBuyCost = new PointBuyCost(n);
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PointBuyStatLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            PointBuyStatLstToken pointBuyStatLstToken = (PointBuyStatLstToken)map.get(string3);
            if (pointBuyStatLstToken != null) {
                object = string2.substring(n2 + 1);
                LstUtils.deprecationCheck(pointBuyStatLstToken, gameMode.getName(), uRI, (String)object);
                if (pointBuyStatLstToken.parse(pointBuyCost, (String)object)) continue;
                Logging.errorPrint("Error parsing point buy method " + gameMode.getName() + ':' + string2 + "\"");
                continue;
            }
            if (PreParserFactory.isPreReqString(string2) || string2.startsWith("RESTRICT:")) {
                if (string2.equalsIgnoreCase("PRE:.CLEAR")) {
                    pointBuyCost.clearPreReq();
                    continue;
                }
                try {
                    object = PreParserFactory.getInstance();
                    pointBuyCost.addPreReq(((PreParserFactory)object).parse(string2));
                    continue;
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    Logging.errorPrint("PersistenceLayerException in Point Buy Line:" + Constants.s_LINE_SEP, persistenceLayerException);
                    return false;
                }
            }
            return false;
        }
        gameMode.addPointBuyStatCost(pointBuyCost);
        return true;
    }

    public static boolean parseMethodLine(GameMode gameMode, String string, URI uRI) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        PointBuyMethod pointBuyMethod = new PointBuyMethod(stringTokenizer.nextToken(), "0");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PointBuyMethodLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            PointBuyMethodLstToken pointBuyMethodLstToken = (PointBuyMethodLstToken)map.get(string3);
            if (pointBuyMethodLstToken != null) {
                String string4 = string2.substring(n + 1);
                LstUtils.deprecationCheck(pointBuyMethodLstToken, gameMode.getName(), uRI, string4);
                if (pointBuyMethodLstToken.parse(pointBuyMethod, string4)) continue;
                Logging.errorPrint("Error parsing point buy method " + gameMode.getName() + ':' + string2 + "\"");
                continue;
            }
            return false;
        }
        gameMode.addPurchaseModeMethod(pointBuyMethod);
        return true;
    }
}

