/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PaperInfo;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.PaperInfoLstToken;
import pcgen.persistence.lst.TokenStore;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

final class PaperInfoLoader
extends LstLineFileLoader {
    public void loadLstFile(LoadContext loadContext, URI uRI) throws PersistenceLayerException {
        super.loadLstFile(loadContext, uRI);
        Globals.selectPaper(SettingsHandler.getPCGenOption("paperName", "A4"));
    }

    public void parseLine(LoadContext loadContext, String string, URI uRI) {
        PaperInfo paperInfo = new PaperInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        int n = 0;
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(PaperInfoLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n2 = string2.indexOf(58);
            String string3 = "";
            try {
                string3 = string2.substring(0, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            PaperInfoLstToken paperInfoLstToken = (PaperInfoLstToken)map.get(string3);
            if (paperInfoLstToken != null) {
                String string4 = string2.substring(n2 + 1);
                LstUtils.deprecationCheck(paperInfoLstToken, paperInfo.toString(), uRI, string4);
                if (paperInfoLstToken.parse(paperInfo, string4)) continue;
                Logging.errorPrint("Error parsing equip slots " + paperInfo.toString() + ':' + uRI + ':' + string2 + "\"");
                continue;
            }
            LstUtils.deprecationWarning("Using deprecated style of paperinfo.lst.  Please consult the docs for information about the new style paperinfo.lst");
            try {
                paperInfo.setPaperInfo(n, string2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Logging.errorPrint("Illegal paper size info '" + string + "' in " + uRI.toString());
            }
            ++n;
        }
        SystemCollections.addToPaperInfoList(paperInfo, this.gameMode);
    }
}

