/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.core.LevelInfo;
import pcgen.persistence.lst.LevelLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

final class LevelLoader {
    private LevelLoader() {
    }

    public static String parseLine(GameMode gameMode, String string, int n, URI uRI, String string2) {
        Object object;
        if (gameMode == null) {
            return "";
        }
        if (string.startsWith("XPTABLE:")) {
            object = string.substring(8);
            if (((String)object).indexOf("\t") >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf("\t"));
            }
            if (((String)(object = ((String)object).trim())).equals("")) {
                Logging.errorPrint("Error parsing level line \"" + string + "\": empty XPTABLE value.");
            } else {
                gameMode.addXpTable((String)object);
                return object;
            }
        }
        if (string2.equals("")) {
            string2 = "Default";
            gameMode.addXpTable(string2);
        }
        object = new LevelInfo();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        Map<String, LstToken> map = TokenStore.inst().getTokenMap(LevelLstToken.class);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            int n2 = string3.indexOf(58);
            String string4 = "";
            try {
                string4 = string3.substring(0, n2);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
            LevelLstToken levelLstToken = (LevelLstToken)map.get(string4);
            if (levelLstToken != null) {
                String string5 = string3.substring(n2 + 1);
                LstUtils.deprecationCheck(levelLstToken, ((LevelInfo)object).getLevelString(), uRI, string5);
                if (levelLstToken.parse((LevelInfo)object, string5)) continue;
                Logging.errorPrint("LevelLoader got invalid " + string4 + " value of '" + string5 + "' in '" + string + "' at line " + n + " of " + uRI + ". Token ignored.");
                continue;
            }
            Logging.errorPrint("LevelLoader got unexpected token of '" + string3 + "' at line " + n + ". Token ignored.");
        }
        if (LevelLoader.validateLevelInfo(gameMode, string2, (LevelInfo)object, string, n, uRI)) {
            gameMode.addLevelInfo(string2, (LevelInfo)object);
        }
        return string2;
    }

    private static boolean validateLevelInfo(GameMode gameMode, String string, LevelInfo levelInfo, String string2, int n, URI uRI) {
        String string3 = levelInfo.getLevelString();
        if (string3 == null) {
            Logging.errorPrint("LevelLoader got empty level value in '" + string2 + "' at line " + n + " of " + uRI + ". Line ignored.");
            return false;
        }
        Map<String, LevelInfo> map = gameMode.getLevelInfo(string);
        if (map == null) {
            return true;
        }
        if (map.get(string3) != null) {
            Logging.errorPrint("LevelLoader got duplicate level value of '" + string3 + "' in '" + string2 + "' at line " + n + " of " + uRI + ". Line ignored.");
            return false;
        }
        if (!LevelLoader.isNumeric(string3)) {
            return true;
        }
        int n2 = LevelLoader.getIntValue(string3);
        Set<String> set = map.keySet();
        for (String string4 : set) {
            if (n2 >= LevelLoader.getIntValue(map.get(string4).getLevelString())) continue;
            Logging.errorPrint("LevelLoader got out of sequence level value of '" + string3 + "' in '" + string2 + "' at line " + n + " of " + uRI + ". Line ignored.");
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static int getIntValue(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

