/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.lang.reflect.Modifier;
import java.util.StringTokenizer;
import pcgen.base.lang.UnreachableError;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.PObject;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.LstObjectFileLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenericLoader<T extends PObject>
extends LstObjectFileLoader<T> {
    private final Class<T> baseClass;

    public GenericLoader(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class for GenericLoader cannot be null");
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Class for GenericLoader must not be abstract");
        }
        try {
            if (!Modifier.isPublic(clazz.getConstructor(new Class[0]).getModifiers())) {
                throw new IllegalArgumentException("Class for GenericLoader must have public zero-argument constructor");
            }
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("Class for GenericLoader must have public zero-argument constructor");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Class for GenericLoader must have zero-argument constructor");
        }
        this.baseClass = clazz;
    }

    @Override
    public T parseLine(LoadContext loadContext, T t, String string, CampaignSourceEntry campaignSourceEntry) throws PersistenceLayerException {
        Object object;
        boolean bl = false;
        if (t == null) {
            try {
                object = (PObject)this.baseClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new UnreachableError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnreachableError(illegalAccessException);
            }
            bl = true;
        } else {
            object = t;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        if (stringTokenizer.hasMoreTokens()) {
            ((PObject)object).setName(stringTokenizer.nextToken());
            ((PObject)object).setSourceCampaign(campaignSourceEntry.getCampaign());
            ((PObject)object).setSourceURI(campaignSourceEntry.getURI());
            if (bl) {
                loadContext.addStatefulInformation((CDOMObject)object);
                loadContext.ref.importObject(object);
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = stringTokenizer.nextToken().trim();
            int n = string3.indexOf(58);
            if (n == -1) {
                Logging.errorPrint("Invalid Token - does not contain a colon: '" + string3 + "' in " + object.getClass().getSimpleName() + " " + ((PObject)object).getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            if (n == 0) {
                Logging.errorPrint("Invalid Token - starts with a colon: '" + string3 + "' in " + object.getClass().getSimpleName() + " " + ((PObject)object).getDisplayName() + " of " + campaignSourceEntry);
                continue;
            }
            String string4 = string3.substring(0, n);
            String string5 = string2 = n == string3.length() - 1 ? null : string3.substring(n + 1);
            if (loadContext.processToken(object, string4, string2)) {
                loadContext.commit();
            } else {
                loadContext.rollback();
                Logging.replayParsedMessages();
            }
            Logging.clearParseMessages();
        }
        this.completeObject(loadContext, campaignSourceEntry, object);
        return null;
    }

    @Override
    protected T getObjectKeyed(LoadContext loadContext, String string) {
        return (T)((PObject)loadContext.ref.silentlyGetConstructedCDOMObject(this.baseClass, string));
    }
}

