/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.base.lang.UnreachableError;
import pcgen.base.util.HashMapToList;
import pcgen.core.Campaign;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CampaignSourceEntry {
    private static final URI FAILED_URI;
    private Campaign campaign = null;
    private List<String> excludeItems = new ArrayList<String>();
    private List<String> includeItems = new ArrayList<String>();
    private URI uri = null;
    private URI writeURI = null;
    private URIFactory uriFac = null;
    private String stringForm = null;

    public CampaignSourceEntry(Campaign campaign, URI uRI) {
        if (campaign == null) {
            throw new IllegalArgumentException("campaign can't be null");
        }
        if (uRI == null) {
            throw new IllegalArgumentException("lstLoc can't be null");
        }
        this.campaign = campaign;
        this.uri = uRI;
    }

    public CampaignSourceEntry(Campaign campaign, URIFactory uRIFactory) {
        if (campaign == null) {
            throw new IllegalArgumentException("campaign can't be null");
        }
        if (uRIFactory == null) {
            throw new IllegalArgumentException("URI Factory can't be null");
        }
        this.campaign = campaign;
        this.uriFac = uRIFactory;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public List<String> getExcludeItems() {
        return this.excludeItems;
    }

    public URI getURI() {
        if (this.uri == null) {
            this.uri = this.uriFac.getURI();
        }
        return this.uri;
    }

    public List<String> getIncludeItems() {
        return this.includeItems;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CampaignSourceEntry)) {
            return false;
        }
        CampaignSourceEntry campaignSourceEntry = (CampaignSourceEntry)object;
        if (this.uriFac == null ? campaignSourceEntry.uriFac != null || !this.getURI().equals(campaignSourceEntry.getURI()) : !this.uriFac.equals(campaignSourceEntry.uriFac)) {
            return false;
        }
        return ((Object)this.excludeItems).equals(campaignSourceEntry.excludeItems) && ((Object)this.includeItems).equals(campaignSourceEntry.includeItems);
    }

    public int hashCode() {
        return this.getURIIdentifier().hashCode();
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Campaign: ");
            stringBuffer.append(this.campaign.getDisplayName());
            stringBuffer.append("; SourceFile: ");
            stringBuffer.append(this.getURI());
            this.stringForm = stringBuffer.toString();
        }
        return this.stringForm;
    }

    private static URI getPathURI(URI uRI, String string) {
        if (string.length() <= 0) {
            Logging.errorPrint("Empty Path to LST file in " + uRI);
            return FAILED_URI;
        }
        if (string.charAt(0) == '@') {
            String string2 = CampaignSourceEntry.trimLeadingFileSeparator(string.substring(1));
            String string3 = CoreUtility.fixFilenamePath(string2);
            return new File(SettingsHandler.getPccFilesLocation(), string3).toURI();
        }
        if (string.charAt(0) == '&') {
            String string4 = CampaignSourceEntry.trimLeadingFileSeparator(string.substring(1));
            String string5 = CoreUtility.fixFilenamePath(string4);
            return new File(SettingsHandler.getPcgenVendorDataDir(), string5).toURI();
        }
        if (string.charAt(0) == '*') {
            String string6 = CampaignSourceEntry.trimLeadingFileSeparator(string.substring(1));
            String string7 = CoreUtility.fixFilenamePath(string6);
            File file = new File(SettingsHandler.getPcgenVendorDataDir(), string7);
            if (file.exists()) {
                return file.toURI();
            }
            return new File(SettingsHandler.getPccFilesLocation(), string7).toURI();
        }
        String string8 = CampaignSourceEntry.trimLeadingFileSeparator(string);
        if (string8.startsWith("data")) {
            String string9 = CoreUtility.fixFilenamePath(string8.substring(5));
            return new File(SettingsHandler.getPccFilesLocation(), string9).toURI();
        }
        if (string.indexOf(58) > 0) {
            try {
                URL uRL = new URL(string);
                return new URI(uRL.getProtocol(), uRL.getHost(), uRL.getPath(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        String string10 = uRI.getPath();
        try {
            return new URI(uRI.getScheme(), null, string10.substring(0, string10.lastIndexOf(47) + 1) + string.replace('\\', '/'), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.errorPrint("GPURI failed to convert " + string10.substring(0, string10.lastIndexOf(47) + 1) + string + " to a URI: " + uRISyntaxException.getLocalizedMessage());
            return FAILED_URI;
        }
    }

    private static String trimLeadingFileSeparator(String string) {
        String string2 = string;
        if (string2.startsWith("/") || string2.startsWith(File.separator)) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static CampaignSourceEntry getNewCSE(Campaign campaign, URI uRI, String string) {
        CampaignSourceEntry campaignSourceEntry;
        if (string == null || string.length() == 0) {
            Logging.errorPrint("Cannot build CampaignSourceEntry for empty value in " + uRI);
            return null;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            if (string.startsWith("(")) {
                Logging.errorPrint("Invalid Campaign File, cannot start with (:" + string);
                return null;
            }
            campaignSourceEntry = new CampaignSourceEntry(campaign, new URIFactory(uRI, string));
        } else {
            campaignSourceEntry = new CampaignSourceEntry(campaign, new URIFactory(uRI, string.substring(0, n)));
            String string2 = string.substring(n + 1);
            if (string2.startsWith("(")) {
                string2 = string2.substring(1, string2.length() - 1);
            } else {
                Logging.deprecationPrint("Found Suffix in Campaign Source without parenthesis: Parens required around INCLUDE/EXCLUDE");
                Logging.deprecationPrint("Found: '" + string2 + "' in " + string);
            }
            while (string2.startsWith("(")) {
                string2 = string2.substring(1, string2.length() - 1);
                Logging.deprecationPrint("Found Suffix in Campaign Source with multiple parenthesis: Single set of parens required around INCLUDE/EXCLUDE");
                Logging.deprecationPrint("Found: '" + string.substring(n + 1) + "' in " + string);
            }
            if (string2.startsWith("INCLUDE:")) {
                List<String> list = campaignSourceEntry.splitInExString(string2);
                if (list == null) {
                    return null;
                }
                campaignSourceEntry.includeItems = list;
            } else if (string2.startsWith("EXCLUDE:")) {
                List<String> list = campaignSourceEntry.splitInExString(string2);
                if (list == null) {
                    return null;
                }
                campaignSourceEntry.excludeItems = list;
            } else {
                Logging.errorPrint("Invalid Suffix: " + string2 + " on Campaign Source: '" + string + "' in " + uRI);
                return null;
            }
        }
        return campaignSourceEntry;
    }

    public URI getWriteURI() {
        return this.writeURI;
    }

    public void setWriteURI(URI uRI) {
        this.writeURI = uRI;
    }

    private List<String> splitInExString(String string) {
        boolean bl = false;
        boolean bl2 = false;
        List<Object> list = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string.substring(8);
        if (string2 == null || string2.length() == 0) {
            Logging.errorPrint("Must Specify Items after :");
            return null;
        }
        list = CoreUtility.split(string2, '|');
        for (String string3 : list) {
            if (string3.startsWith("CATEGORY=")) {
                bl = true;
                List<String> list2 = CoreUtility.split(string3.substring(9), ',');
                String string4 = list2.get(0);
                list2.remove(0);
                for (String string5 : list2) {
                    arrayList.add(string4 + ',' + string5);
                }
                continue;
            }
            bl2 = true;
            arrayList.add(string3);
        }
        if (bl2 && bl) {
            Logging.log(Logging.LST_ERROR, "Invalid " + string.substring(0, 7) + " value on " + this.getURIIdentifier() + " in " + this.campaign.getDisplayName() + ". Abilities must always have categories (e.g. " + string.substring(0, 8) + "CATEGORY=cat1,key1,key2|CATEGORY=cat2,key1 ) and " + "other file types should never have categories (e.g. " + string.substring(0, 8) + "key1|key2 ).");
            return null;
        }
        return arrayList;
    }

    private String getURIIdentifier() {
        if (this.uriFac == null) {
            return this.uri.toString();
        }
        return this.uriFac.s;
    }

    public String getLSTformat() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getURIIdentifier());
        if (!this.includeItems.isEmpty()) {
            stringBuilder.append("|");
            stringBuilder.append("(INCLUDE:");
            stringBuilder.append((CharSequence)this.joinIncExcList(this.includeItems));
            stringBuilder.append(')');
        } else if (!this.excludeItems.isEmpty()) {
            stringBuilder.append("|");
            stringBuilder.append("(EXCLUDE:");
            stringBuilder.append((CharSequence)this.joinIncExcList(this.excludeItems));
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private StringBuilder joinIncExcList(List<String> list) {
        HashMapToList<String, String> hashMapToList = new HashMapToList<String, String>();
        for (String string : list) {
            int n = string.indexOf(44);
            if (n == -1) {
                return StringUtil.joinToStringBuffer(list, "|");
            }
            hashMapToList.addToListFor(string.substring(0, n), string.substring(n + 1));
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String string : hashMapToList.getKeySet()) {
            if (bl) {
                stringBuilder.append("|");
            }
            bl = true;
            stringBuilder.append("CATEGORY=");
            stringBuilder.append(string);
            stringBuilder.append(",");
            stringBuilder.append((CharSequence)StringUtil.joinToStringBuffer(hashMapToList.getListFor(string), ","));
        }
        return stringBuilder;
    }

    public CampaignSourceEntry getRelatedTarget(String string) {
        if (this.uriFac == null) {
            throw new IllegalStateException("getRelatedTarget can only be called on a CampaignSourceEntry that uses a URI Factory");
        }
        return new CampaignSourceEntry(this.campaign, new URIFactory(this.uriFac.u, string));
    }

    static {
        try {
            FAILED_URI = new URI("file:/FAIL");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UnreachableError(uRISyntaxException);
        }
    }

    public static class URIFactory {
        private final URI u;
        private final String s;

        public URIFactory(URI uRI, String string) {
            if (uRI == null) {
                throw new IllegalArgumentException("URI cannot be null");
            }
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException("URI cannot be null");
            }
            this.u = uRI;
            this.s = string;
        }

        public URI getURI() {
            return CampaignSourceEntry.getPathURI(this.u, this.s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof URIFactory) {
                URIFactory uRIFactory = (URIFactory)object;
                return this.s.equals(uRIFactory.s) && this.u.equals(uRIFactory.u);
            }
            return false;
        }
    }
}

