/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.io.filters.OutputFilter;
import pcgen.util.Delta;
import pcgen.util.Logging;

public class CharacterFilter
implements OutputFilter {
    private String outputFilterName = "";
    private Map<Integer, String> outputFilter = null;

    public CharacterFilter(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((string = string.toLowerCase()).equals(this.outputFilterName)) {
            return;
        }
        this.outputFilter = null;
        string = SettingsHandler.getPcgenSystemDir() + File.separator + "outputFilters" + File.separator + string + ".lst";
        File file = new File(string);
        try {
            if (file.canRead() && file.isFile()) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                this.outputFilterName = string;
                this.outputFilter = new HashMap<Integer, String>();
                while ((string2 = bufferedReader.readLine()) != null) {
                    List<String> list = CoreUtility.split(string2, '\t');
                    if (list.size() < 2) continue;
                    try {
                        Integer n2 = Delta.decode(list.get(0));
                        this.outputFilter.put(n2, list.get(1));
                    }
                    catch (NullPointerException nullPointerException) {
                        Logging.errorPrint("Exception in setCurrentOutputFilter", nullPointerException);
                    }
                    catch (NumberFormatException numberFormatException) {
                        Logging.errorPrint("Exception in setCurrentOutputFilter", numberFormatException);
                    }
                }
                bufferedReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String filterString(String string) {
        if (this.outputFilter != null && this.outputFilter.size() != 0 && string != null) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                String string2 = this.outputFilter.get(c);
                if (string2 != null) {
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
        }
        return string;
    }
}

