/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;

public class WeightToken
extends Token {
    public static final String TOKENNAME = "WEIGHT";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        if (TOKENNAME.equals(string)) {
            string2 = WeightToken.getWeightToken(playerCharacter);
        } else if ("WEIGHT.NOUNIT".equals(string)) {
            string2 = WeightToken.getNoUnitToken(playerCharacter);
        } else {
            String string3 = string.substring(string.lastIndexOf(46) + 1);
            string2 = Globals.getGameModeUnitSet().displayWeightInUnitSet(WeightToken.getLoadToken(string3, playerCharacter));
        }
        return string2;
    }

    public static double getLoadToken(String string, PlayerCharacter playerCharacter) {
        Float f = SystemCollections.getLoadInfo().getLoadMultiplier(string.toUpperCase());
        if (f != null) {
            return Globals.maxLoadForLoadScore(playerCharacter.getVariableValue("LOADSCORE", "").intValue(), playerCharacter, f).intValue();
        }
        return 0.0;
    }

    public static String getNoUnitToken(PlayerCharacter playerCharacter) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(playerCharacter.getWeight());
    }

    public static String getWeightToken(PlayerCharacter playerCharacter) {
        return Globals.getGameModeUnitSet().displayWeightInUnitSet(playerCharacter.getWeight()) + Globals.getGameModeUnitSet().getWeightUnit();
    }
}

