/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io.exporttoken;

import java.util.StringTokenizer;
import pcgen.core.PlayerCharacter;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Delta;
import pcgen.util.enumeration.AttackType;

public class AttackToken
extends Token {
    public static final String TOKENNAME = "ATTACK";

    public String getTokenName() {
        return TOKENNAME;
    }

    public String getToken(String string, PlayerCharacter playerCharacter, ExportHandler exportHandler) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            int n;
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            String string5 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
            string2 = AttackToken.getParsedToken(playerCharacter, string3, string4);
            if ("SHORT".equalsIgnoreCase(string5) && (n = string2.indexOf("/")) >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static String getParsedToken(PlayerCharacter playerCharacter, String string, String string2) {
        if (string2.equals("TOTAL")) {
            if (string.equals("RANGED")) {
                int n = AttackToken.getTotalToken(playerCharacter, string);
                return playerCharacter.getAttackString(AttackType.RANGED, n);
            }
            if (string.equals("UNARMED")) {
                int n = AttackToken.getTotalToken(playerCharacter, "MELEE");
                return playerCharacter.getAttackString(AttackType.MELEE, n);
            }
            int n = AttackToken.getTotalToken(playerCharacter, string);
            return playerCharacter.getAttackString(AttackType.MELEE, n);
        }
        return AttackToken.getSubToken(playerCharacter, string, string2);
    }

    private static String getSubToken(PlayerCharacter playerCharacter, String string, String string2) {
        if (string2.equals("BASE")) {
            return Delta.toString(AttackToken.getBaseToken(playerCharacter));
        }
        if (string2.equals("EPIC")) {
            return Delta.toString(AttackToken.getEpicToken(playerCharacter));
        }
        if (string2.equals("MISC")) {
            return Delta.toString(AttackToken.getMiscToken(playerCharacter, string));
        }
        if (string2.equals("SIZE")) {
            return Delta.toString(AttackToken.getSizeToken(playerCharacter, string));
        }
        if (string2.equals("STAT")) {
            return Delta.toString(AttackToken.getStatToken(playerCharacter, string));
        }
        if (!string2.equals("TOTAL")) {
            return playerCharacter.getAttackString(AttackType.valueOf(string));
        }
        return "";
    }

    public static int getBaseToken(PlayerCharacter playerCharacter) {
        return playerCharacter.baseAttackBonus();
    }

    public static int getEpicToken(PlayerCharacter playerCharacter) {
        return (int)playerCharacter.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
    }

    public static int getMiscToken(PlayerCharacter playerCharacter, String string) {
        int n = (int)playerCharacter.getTotalBonusTo("TOHIT", "TOHIT") + (int)playerCharacter.getTotalBonusTo("TOHIT", "TYPE." + string) - (int)playerCharacter.getStatBonusTo("TOHIT", "TYPE." + string) - (int)playerCharacter.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        int n2 = (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT") + (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT." + string) - (int)playerCharacter.getStatBonusTo("COMBAT", "TOHIT." + string) - (int)playerCharacter.getSizeAdjustmentBonusTo("COMBAT", "TOHIT") - (int)playerCharacter.getSizeAdjustmentBonusTo("COMBAT", "TOHIT." + string) - (int)playerCharacter.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
        return n2 + n;
    }

    public static int getSizeToken(PlayerCharacter playerCharacter, String string) {
        int n = (int)playerCharacter.getSizeAdjustmentBonusTo("TOHIT", "TOHIT") + (int)playerCharacter.getSizeAdjustmentBonusTo("TOHIT", "TYPE." + string);
        int n2 = (int)playerCharacter.getSizeAdjustmentBonusTo("COMBAT", "TOHIT") + (int)playerCharacter.getSizeAdjustmentBonusTo("COMBAT", "TOHIT." + string);
        return n2 + n;
    }

    public static int getStatToken(PlayerCharacter playerCharacter, String string) {
        int n = (int)playerCharacter.getStatBonusTo("TOHIT", "TYPE." + string);
        int n2 = (int)playerCharacter.getStatBonusTo("COMBAT", "TOHIT." + string);
        return n2 + n;
    }

    public static int getTotalToken(PlayerCharacter playerCharacter, String string) {
        int n = (int)playerCharacter.getTotalBonusTo("TOHIT", "TOHIT") + (int)playerCharacter.getTotalBonusTo("TOHIT", "TYPE." + string);
        int n2 = (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT") + (int)playerCharacter.getTotalBonusTo("COMBAT", "TOHIT." + string);
        return n + n2;
    }
}

