/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.File;
import java.net.URI;

public final class PCGFile {
    public static boolean isPCGenCharacterFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".pcg");
    }

    public static boolean isPCGenPartyFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".pcp");
    }

    public static boolean isPCGenCampaignFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".pcc");
    }

    public static boolean isPCGenCampaignFile(URI uRI) {
        if ("file".equals(uRI.getScheme())) {
            return PCGFile.isPCGenCampaignFile(new File(uRI));
        }
        return uRI.getPath() != null && uRI.getPath().toLowerCase().endsWith(".pcc");
    }

    public static boolean isPCGenListFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return PCGFile.getWindowsSafeFilename(file).endsWith(".lst");
    }

    public static boolean isPCGenCharacterOrPartyFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = PCGFile.getWindowsSafeFilename(file);
        return string.endsWith(".pcg") || string.endsWith(".pcp");
    }

    public static boolean isPCGenCharacterPartyOrCampaignFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String string = PCGFile.getWindowsSafeFilename(file);
        return string.endsWith(".pcg") || string.endsWith(".pcp") || string.endsWith(".pcc");
    }

    private static String getWindowsSafeFilename(File file) {
        return file.getName().toLowerCase();
    }
}

