/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import pcgen.core.PObject;
import pcgen.core.character.SpellInfo;
import pcgen.core.utils.MessageType;
import pcgen.gui.utils.AbstractCellEditor;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.TreeTableModelAdapter;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTreeTable
extends JTableEx
implements KeyListener {
    static final long serialVersionUID = -3571248405124682593L;
    private TimedKeyBuffer keyBuffer = new TimedKeyBuffer(3000);
    private TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        UIManager.put("TreeTableUI", "javax.swing.plaf.metal.MetalTreeUI");
        UIManager.put("Tree.leftChildIndent", 3);
        UIManager.put("Tree.rightChildIndent", 8);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.addKeyListener(this);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.tree.getRowHeight());
        }
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public List<String> getExpandedPaths() {
        if (this.tree == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.tree.getRowCount());
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            if (!this.tree.isExpanded(i)) continue;
            arrayList.add(this.tree.getPathForRow(i).toString());
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        return arrayList;
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void expandByPObjectName(String string) {
        this.expandByPObjectName((PObjectNode)this.getTree().getModel().getRoot(), string);
    }

    public void expandPathList(List<String> list) {
        if (list == null) {
            return;
        }
        for (String string : list) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                TreePath treePath = this.tree.getPathForRow(i);
                if (treePath == null || !treePath.toString().equals(string)) continue;
                this.tree.makeVisible(treePath);
                this.tree.expandPath(treePath);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.keyBuffer.clearBuffer();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        String string;
        if (keyEvent.getModifiers() != 0 && keyEvent.getModifiers() != 1) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c) && c != '-' && c != '+' && c != '(' && c != ')' && c != '.' && c != ',' && c != ':' && c != ';') {
            return;
        }
        if (this.getSelectedRow() >= 0 && this.getSelectedColumn() >= 0 && this.isCellEditable(this.getSelectedRow(), this.getSelectedColumn()) && this.getColumnClass(this.getSelectedColumn()) != TreeTableModel.class) {
            return;
        }
        this.keyBuffer.addChar(keyEvent.getKeyChar());
        String string2 = this.keyBuffer.getString();
        TreePath treePath = this.tree.getSelectionPath();
        PObjectNode pObjectNode = (PObjectNode)treePath.getLastPathComponent();
        PObjectNode pObjectNode2 = pObjectNode.getParent();
        if (!(string2.length() != 1 || pObjectNode.isLeaf() || c != '+' && c != '-' && c != ' ')) {
            this.keyBuffer.clearBuffer();
            switch (c) {
                case '+': {
                    this.tree.expandPath(treePath);
                    this.tree.setSelectionPath(treePath);
                    return;
                }
                case '-': {
                    this.tree.collapsePath(treePath);
                    this.tree.setSelectionPath(treePath);
                    return;
                }
                case ' ': {
                    if (this.tree.isCollapsed(treePath)) {
                        this.tree.expandPath(treePath);
                    } else {
                        this.tree.collapsePath(treePath);
                    }
                    this.tree.setSelectionPath(treePath);
                    return;
                }
            }
        }
        if ((string = pObjectNode.getNodeName()) == null || !string.regionMatches(true, 0, string2, 0, string2.length())) {
            this.searchSingleLevel(pObjectNode2, string2, true);
        }
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        Container container;
        int n = this.getX();
        int n2 = this.getY();
        for (container = this.getParent(); container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane); container = container.getParent()) {
            Rectangle rectangle2 = container.getBounds();
            n += rectangle2.x;
            n2 += rectangle2.y;
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n;
            rectangle.y += n2;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n;
            rectangle.y -= n2;
        }
    }

    public TreePath search(String string, boolean bl) {
        PObjectNode pObjectNode = (PObjectNode)this.tree.getModel().getRoot();
        return this.search(pObjectNode, string, bl);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    private void expandByPObjectName(PObjectNode pObjectNode, String string) {
        ArrayList<PObjectNode> arrayList = pObjectNode.getChildren();
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            PObjectNode pObjectNode2;
            ArrayList<PObjectNode> arrayList2;
            PObjectNode pObjectNode3 = (PObjectNode)arrayList.get(i);
            if (!pObjectNode3.isLeaf()) {
                this.expandByPObjectName(pObjectNode3, string);
                continue;
            }
            Object object = pObjectNode3.getItem();
            if (object instanceof PObject) {
                if (!((PObject)object).getDisplayName().equals(string)) continue;
                arrayList2 = new ArrayList<PObjectNode>();
                pObjectNode2 = pObjectNode3;
                while (pObjectNode2.getParent() != null) {
                    arrayList2.add(0, pObjectNode2.getParent());
                    pObjectNode2 = pObjectNode2.getParent();
                }
                this.getTree().expandPath(new TreePath(arrayList2.toArray()));
                continue;
            }
            if (!(object instanceof SpellInfo) || !object.toString().equals(string)) continue;
            arrayList2 = new ArrayList();
            pObjectNode2 = pObjectNode3;
            while (pObjectNode2.getParent() != null) {
                arrayList2.add(0, pObjectNode2.getParent());
                pObjectNode2 = pObjectNode2.getParent();
            }
            this.getTree().expandPath(new TreePath(arrayList2.toArray()));
        }
    }

    private void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.tree.makeVisible(treePath);
            Rectangle rectangle = this.tree.getPathBounds(treePath);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
            }
        }
    }

    private TreePath search(PObjectNode pObjectNode, String string, boolean bl) {
        int n = string.length();
        ArrayList<PObjectNode> arrayList = pObjectNode.getChildren();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object;
                PObjectNode pObjectNode2 = (PObjectNode)arrayList.get(i);
                if (!pObjectNode2.isLeaf()) {
                    object = this.search(pObjectNode2, string, bl);
                    if (object == null) continue;
                    return object;
                }
                object = pObjectNode2.getNodeName();
                if ("".equals(object) && ((String)(object = pObjectNode2.toString())).indexOf("|") != -1) {
                    object = ((String)object).substring(((String)object).lastIndexOf("|") + 1);
                }
                if (!((String)object).regionMatches(true, 0, string, 0, n)) continue;
                ArrayList<PObjectNode> arrayList2 = new ArrayList<PObjectNode>();
                PObjectNode pObjectNode3 = pObjectNode2;
                while (pObjectNode3.getParent() != null) {
                    arrayList2.add(0, pObjectNode3.getParent());
                    pObjectNode3 = pObjectNode3.getParent();
                }
                TreePath treePath = new TreePath(arrayList2.toArray());
                if (bl) {
                    this.tree.expandPath(treePath);
                }
                arrayList2.add(pObjectNode2);
                treePath = new TreePath(arrayList2.toArray());
                if (bl) {
                    this.scrollPathToVisible(treePath);
                    this.tree.setSelectionPath(treePath);
                }
                return treePath;
            }
        }
        return null;
    }

    private TreePath searchSingleLevel(PObjectNode pObjectNode, String string, boolean bl) {
        int n = string.length();
        ArrayList<PObjectNode> arrayList = pObjectNode.getChildren();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                PObjectNode pObjectNode2 = (PObjectNode)arrayList.get(i);
                String string2 = pObjectNode2.getNodeName();
                if (!string2.regionMatches(true, 0, string, 0, n)) continue;
                ArrayList<PObjectNode> arrayList2 = new ArrayList<PObjectNode>();
                PObjectNode pObjectNode3 = pObjectNode2;
                while (pObjectNode3.getParent() != null) {
                    arrayList2.add(0, pObjectNode3.getParent());
                    pObjectNode3 = pObjectNode3.getParent();
                }
                arrayList2.add(pObjectNode2);
                TreePath treePath = new TreePath(arrayList2.toArray());
                if (bl) {
                    this.scrollPathToVisible(treePath);
                    this.tree.setSelectionPath(treePath);
                }
                return treePath;
            }
        }
        return null;
    }

    public String searchTree(String string) {
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(null, PropertyFactory.getString("TreeTable.Prompt.Search"), "PCGen", MessageType.INFORMATION, null, string);
        String string2 = (String)object;
        if (string2 != null) {
            if (string2.length() != 0 && this.search(string2, true) != null) {
                this.requestFocus();
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    public void addPopupMenu(JPopupMenu jPopupMenu) {
        this.addMouseListener(new PopupListener(this, jPopupMenu));
    }

    private class PopupListener
    extends MouseAdapter {
        private JPopupMenu theMenu;
        private JTree theTree;

        private PopupListener(JTreeTable jTreeTable2, JPopupMenu jPopupMenu) {
            this.theTree = jTreeTable2.getTree();
            this.theMenu = jPopupMenu;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                TreePath treePath = this.theTree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath == null) {
                    return;
                }
                if (this.theTree.isSelectionEmpty()) {
                    this.theTree.setSelectionPath(treePath);
                    this.theMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (!this.theTree.isPathSelected(treePath)) {
                    this.theTree.setSelectionPath(treePath);
                    this.theMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.theTree.addSelectionPath(treePath);
                    this.theMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    private final class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TreeTableCellEditor() {
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                for (int i = JTreeTable.this.getColumnCount() - 1; i >= 0; --i) {
                    if (JTreeTable.this.getColumnClass(i) != TreeTableModel.class) continue;
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                    break;
                }
            }
            return false;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }
    }

    private static final class TimedKeyBuffer {
        private String keyBuffer;
        private int timeToWait;
        private long lastMSecs;

        public TimedKeyBuffer(int n) {
            this.timeToWait = n;
            this.lastMSecs = 0L;
        }

        public String getString() {
            if (System.currentTimeMillis() > this.lastMSecs + (long)this.timeToWait) {
                return "";
            }
            return this.keyBuffer;
        }

        public void addChar(char c) {
            if (System.currentTimeMillis() > this.lastMSecs + (long)this.timeToWait) {
                this.keyBuffer = "";
            }
            this.keyBuffer = this.keyBuffer + String.valueOf(Character.toLowerCase(c));
            this.lastMSecs = System.currentTimeMillis();
        }

        public void clearBuffer() {
            this.keyBuffer = "";
        }
    }

    private final class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        static final long serialVersionUID = -3571248405124682593L;
        private boolean updatingListSelectionModel;

        private ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        private ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        private ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int[] nArray = JTreeTable.this.getSelectedRows();
                    if (nArray == null || nArray.length == 0) {
                        return;
                    }
                    int n = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        if (JTreeTable.this.tree.getPathForRow(nArray[i]) == null) continue;
                        ++n;
                    }
                    if (n == 0) {
                        return;
                    }
                    TreePath[] treePathArray = new TreePath[n];
                    n = 0;
                    for (int i = 0; i < nArray.length; ++i) {
                        TreePath treePath = JTreeTable.this.tree.getPathForRow(nArray[i]);
                        if (treePath == null) continue;
                        treePathArray[n++] = treePath;
                    }
                    this.setSelectionPaths(treePathArray);
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        final class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    final class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private int visibleRow;
        private DefaultTableCellRenderer tableCellRenderer;

        TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.tableCellRenderer = new DefaultTableCellRenderer(){

                public void setBounds(int n, int n2, int n3, int n4) {
                    super.setBounds(n, n2, n3, n4);
                    TreeTableCellRenderer.this.setBounds(n, n2, n3, n4);
                }

                public void paint(Graphics graphics) {
                    TreeTableCellRenderer.this.paint(graphics);
                    this.paintBorder(graphics);
                }
            };
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(JTreeTable.this.getRowHeight());
                }
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            return this.tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }

        public String getUIClassID() {
            return "TreeTableUI";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics graphics) {
            int n = -this.visibleRow * JTreeTable.this.getRowHeight();
            graphics.translate(0, n);
            try {
                super.paint(graphics);
            }
            catch (Exception exception) {
            }
            finally {
                graphics.translate(0, -n);
            }
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }
    }
}

