/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class BrowserLauncher {
    private static int jvm;
    private static Object browser;
    private static boolean loadedWithoutErrors;
    private static Class<?> mrjFileUtilsClass;
    private static Class<?> mrjOSTypeClass;
    private static Class<?> aeDescClass;
    private static Constructor<?> aeTargetConstructor;
    private static Constructor<?> appleEventConstructor;
    private static Constructor<?> aeDescConstructor;
    private static Method findFolder;
    private static Method getFileCreator;
    private static Method getFileType;
    private static Method openURL;
    private static Method makeOSType;
    private static Method putParameter;
    private static Method sendNoReply;
    private static Object kSystemFolderType;
    private static Integer keyDirectObject;
    private static Integer kAutoGenerateReturnID;
    private static Integer kAnyTransactionID;
    private static final int MRJ_2_0 = 0;
    private static final int MRJ_2_1 = 1;
    private static final int MRJ_3_0 = 3;
    private static final int MRJ_3_1 = 4;
    private static final int WINDOWS_NT = 5;
    private static final int WINDOWS_9x = 6;
    private static final int OTHER = -1;
    private static final String FINDER_TYPE = "FNDR";
    private static final String FINDER_CREATOR = "MACS";
    private static final String GURL_EVENT = "GURL";
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";
    private static final String BROWSER_PROPERTY = "BROWSER";
    private static String errorMessage;

    private BrowserLauncher() {
    }

    public static void openURL(URL uRL) throws IOException {
        BrowserLauncher.openURL(uRL.toString());
    }

    public static void openURL(String string) throws IOException {
        if (!loadedWithoutErrors) {
            throw new IOException(PropertyFactory.getFormattedString("in_BLEr3", errorMessage));
        }
        if (BrowserLauncher.isBrowserPathNull(SettingsHandler.getBrowserPath())) {
            Object object = BrowserLauncher.locateBrowser();
            if (BrowserLauncher.isBrowserPathNull(object)) {
                BrowserLauncher.noBrowserSet();
                return;
            }
            switch (jvm) {
                case 0: {
                    Object var2_3 = null;
                    try {
                        var2_3 = aeDescConstructor.newInstance(string);
                        putParameter.invoke(object, keyDirectObject, var2_3);
                        sendNoReply.invoke(object, Globals.EMPTY_OBJECT_ARRAY);
                        break;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr6", invocationTargetException.getMessage()));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr7", illegalAccessException.getMessage()));
                    }
                    catch (InstantiationException instantiationException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr8", instantiationException.getMessage()));
                    }
                    finally {
                        var2_3 = null;
                        object = null;
                    }
                }
                case 1: {
                    Runtime.getRuntime().exec(new String[]{(String)object, string});
                    break;
                }
                case 3: {
                    int[] nArray = new int[1];
                    int n = BrowserLauncher.ICStart(nArray, 0);
                    if (n == 0) {
                        int[] nArray2;
                        int[] nArray3 = new int[]{0};
                        byte[] byArray = string.getBytes();
                        n = BrowserLauncher.ICLaunchURL(nArray[0], new byte[]{0}, byArray, byArray.length, nArray3, nArray2 = new int[]{byArray.length});
                        if (n == 0) {
                            BrowserLauncher.ICStop(nArray);
                            break;
                        }
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr9", String.valueOf(n)));
                    }
                    throw new IOException(PropertyFactory.getFormattedString("in_BLEr10", String.valueOf(n)));
                }
                case 4: {
                    try {
                        Logging.log(Logging.INFO, PropertyFactory.getFormattedString("in_BLEr11", string));
                        openURL.invoke(null, string);
                        break;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr12", invocationTargetException.getMessage()));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr13", illegalAccessException.getMessage()));
                    }
                }
                case 5: 
                case 6: {
                    Process process = Runtime.getRuntime().exec(new String[]{(String)object, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, '\"' + string + '\"'});
                    try {
                        process.waitFor();
                        process.exitValue();
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr14", interruptedException.getMessage()));
                    }
                }
                case -1: {
                    Process process = Runtime.getRuntime().exec(new String[]{(String)object, NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START + string + NETSCAPE_OPEN_PARAMETER_END});
                    try {
                        int n = process.waitFor();
                        if (n != 0) {
                            Runtime.getRuntime().exec(new String[]{(String)object, string});
                        }
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(PropertyFactory.getFormattedString("in_BLEr14", interruptedException.getMessage()));
                    }
                }
                default: {
                    Runtime.getRuntime().exec(new String[]{(String)object, string});
                }
            }
        } else {
            String string2 = SettingsHandler.getBrowserPath();
            if (BrowserLauncher.isBrowserPathNull(string2)) {
                BrowserLauncher.noBrowserSet();
                return;
            }
            Logging.log(Logging.INFO, PropertyFactory.getFormattedString("in_BLEr15", string2));
            if (jvm == 4 && string2.toLowerCase().endsWith(".app")) {
                Logging.log(Logging.INFO, PropertyFactory.getFormattedString("in_BLEr16", string2, string));
                Runtime.getRuntime().exec(new String[]{"open", "-a", string2, string});
            } else {
                Logging.log(Logging.INFO, PropertyFactory.getFormattedString("in_BLEr17", string2, string));
                Runtime.getRuntime().exec(new String[]{string2, string});
            }
        }
    }

    private static boolean isBrowserPathNull(Object object) {
        return object == null || object.equals("") || object.equals("null");
    }

    private static native int ICLaunchURL(int var0, byte[] var1, byte[] var2, int var3, int[] var4, int[] var5);

    private static native int ICStart(int[] var0, int var1);

    private static native int ICStop(int[] var0);

    private static boolean loadClasses() {
        switch (jvm) {
            case 0: {
                try {
                    Class<?> clazz = Class.forName("com.apple.MacOS.AETarget");
                    Class<?> clazz2 = Class.forName("com.apple.MacOS.OSUtils");
                    Class<?> clazz3 = Class.forName("com.apple.MacOS.AppleEvent");
                    Class<?> clazz4 = Class.forName("com.apple.MacOS.ae");
                    aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
                    aeTargetConstructor = clazz.getDeclaredConstructor(Integer.TYPE);
                    appleEventConstructor = clazz3.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, clazz, Integer.TYPE, Integer.TYPE);
                    aeDescConstructor = aeDescClass.getDeclaredConstructor(String.class);
                    makeOSType = clazz2.getDeclaredMethod("makeOSType", String.class);
                    putParameter = clazz3.getDeclaredMethod("putParameter", Integer.TYPE, aeDescClass);
                    sendNoReply = clazz3.getDeclaredMethod("sendNoReply", Globals.EMPTY_CLASS_ARRAY);
                    Field field = clazz4.getDeclaredField("keyDirectObject");
                    keyDirectObject = (Integer)field.get(null);
                    Field field2 = clazz3.getDeclaredField("kAutoGenerateReturnID");
                    kAutoGenerateReturnID = (Integer)field2.get(null);
                    Field field3 = clazz3.getDeclaredField("kAnyTransactionID");
                    kAnyTransactionID = (Integer)field3.get(null);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    errorMessage = noSuchFieldException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
            case 1: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
                    Field field = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
                    kSystemFolderType = field.get(null);
                    findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
                    getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", File.class);
                    getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", File.class);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    errorMessage = noSuchFieldException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (SecurityException securityException) {
                    errorMessage = securityException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
            case 3: {
                try {
                    Class<?> clazz = Class.forName("com.apple.mrj.jdirect.Linker");
                    Constructor<?> constructor = clazz.getConstructor(Class.class);
                    constructor.newInstance(BrowserLauncher.class);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    errorMessage = invocationTargetException.getMessage();
                    return false;
                }
                catch (InstantiationException instantiationException) {
                    errorMessage = instantiationException.getMessage();
                    return false;
                }
                catch (IllegalAccessException illegalAccessException) {
                    errorMessage = illegalAccessException.getMessage();
                    return false;
                }
            }
            case 4: {
                try {
                    mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
                    openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    errorMessage = classNotFoundException.getMessage();
                    return false;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    errorMessage = noSuchMethodException.getMessage();
                    return false;
                }
            }
        }
        return true;
    }

    private static Object locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (jvm) {
            case 0: {
                try {
                    Integer n = (Integer)makeOSType.invoke(null, FINDER_CREATOR);
                    Object obj = aeTargetConstructor.newInstance(n);
                    Integer n2 = (Integer)makeOSType.invoke(null, GURL_EVENT);
                    Object obj2 = appleEventConstructor.newInstance(n2, n2, obj, kAutoGenerateReturnID, kAnyTransactionID);
                    return obj2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    browser = null;
                    errorMessage = illegalAccessException.getMessage();
                    return browser;
                }
                catch (InstantiationException instantiationException) {
                    browser = null;
                    errorMessage = instantiationException.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationTargetException) {
                    browser = null;
                    errorMessage = invocationTargetException.getMessage();
                    return browser;
                }
            }
            case 1: {
                File file;
                try {
                    file = (File)findFolder.invoke(null, kSystemFolderType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    browser = null;
                    errorMessage = illegalArgumentException.getMessage();
                    return browser;
                }
                catch (IllegalAccessException illegalAccessException) {
                    browser = null;
                    errorMessage = illegalAccessException.getMessage();
                    return browser;
                }
                catch (InvocationTargetException invocationTargetException) {
                    browser = null;
                    errorMessage = invocationTargetException.getTargetException().getClass() + ": " + invocationTargetException.getTargetException().getMessage();
                    return browser;
                }
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        Object object;
                        Object object2;
                        File file2 = new File(file, stringArray[i]);
                        if (!file2.isFile() || !FINDER_TYPE.equals((object2 = getFileType.invoke(null, file2)).toString()) || !FINDER_CREATOR.equals((object = getFileCreator.invoke(null, file2)).toString())) continue;
                        browser = file2.toString();
                        return browser;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        errorMessage = illegalArgumentException.getMessage();
                        return null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        browser = null;
                        errorMessage = illegalAccessException.getMessage();
                        return browser;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        browser = null;
                        errorMessage = invocationTargetException.getTargetException().getClass() + ": " + invocationTargetException.getTargetException().getMessage();
                        return browser;
                    }
                }
                return null;
            }
            case 3: 
            case 4: {
                browser = "";
                return "";
            }
            case 5: {
                return "cmd.exe";
            }
            case 6: {
                return "command.com";
            }
        }
        browser = System.getProperty(BROWSER_PROPERTY, null);
        if (null != browser) {
            return browser;
        }
        return null;
    }

    private static void noBrowserSet() {
        ShowMessageDelegate.showMessageDialog("Please set your browser in the Preferences", "PCGen", MessageType.ERROR);
    }

    static {
        block9: {
            loadedWithoutErrors = true;
            String string = System.getProperty("os.name");
            if (string.startsWith("Mac OS")) {
                String string2 = System.getProperty("mrj.version");
                String string3 = string2.substring(0, 3);
                try {
                    double d = Double.valueOf(string3);
                    if (d < 2.1) {
                        jvm = 0;
                        break block9;
                    }
                    if (d >= 2.1 && d < 3.0) {
                        jvm = 1;
                        break block9;
                    }
                    if (d == 3.0) {
                        jvm = 3;
                        break block9;
                    }
                    if (d >= 3.1) {
                        jvm = 4;
                        break block9;
                    }
                    loadedWithoutErrors = false;
                    errorMessage = PropertyFactory.getFormattedString("in_BLEr1", String.valueOf(d));
                }
                catch (NumberFormatException numberFormatException) {
                    loadedWithoutErrors = false;
                    errorMessage = PropertyFactory.getFormattedString("in_BLEr2", String.valueOf(string2));
                }
            } else {
                jvm = string.startsWith("Windows") ? (string.indexOf("9") != -1 ? 6 : 5) : -1;
            }
        }
        if (loadedWithoutErrors) {
            loadedWithoutErrors = BrowserLauncher.loadClasses();
        }
    }
}

