/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.resources;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.base.formula.Formula;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.list.CompanionList;
import pcgen.core.FollowerOption;
import pcgen.core.Globals;
import pcgen.core.Movement;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.character.Follower;
import pcgen.core.display.VisionDisplay;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.CoreUtility;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AvailableFollowerModel
extends AbstractTreeTableModel
implements TableColumnManagerModel {
    private static final int COL_NAME = 0;
    private static final int COL_ADJUSTMENT = 7;
    private static final int COL_SIZE = 1;
    private static final int COL_MOVE = 2;
    private static final int COL_VISION = 3;
    private static final int COL_PRE = 4;
    private static final int COL_TYPE = 5;
    private static final int COL_SOURCE = 6;
    private static final int VIEW_ADJUSTMENT = 1;
    private static final int VIEW_NAME = 0;
    private static final int VIEW_RACETYPE = 2;
    private List<Boolean> displayList = null;
    private PObjectNode avaRoot;
    private String[] avaNameList = new String[]{PropertyFactory.getString("in_typeName"), PropertyFactory.getString("in_size"), PropertyFactory.getString("in_speed"), PropertyFactory.getString("in_vision"), PropertyFactory.getString("in_alignLabel"), PropertyFactory.getString("in_typeRace"), PropertyFactory.getString("in_source"), PropertyFactory.getString("in_adjustment")};
    private final int[] avaDefaultWidth = new int[]{200, 100, 100, 100, 100, 100, 100, 100};
    private PlayerCharacter pc;

    public AvailableFollowerModel(PlayerCharacter playerCharacter, int n) {
        super(null);
        this.setCharacter(playerCharacter);
        this.resetModel(n);
        int n2 = 1;
        this.displayList = new ArrayList<Boolean>();
        this.displayList.add(Boolean.TRUE);
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
        this.displayList.add(this.getColumnViewOption(this.avaNameList[n2++], true));
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        return n == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? TreeTableModel.class : String.class;
    }

    @Override
    public int getColumnCount() {
        return this.avaNameList.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.avaNameList[n];
    }

    @Override
    public Object getRoot() {
        return super.getRoot();
    }

    public void setCharacter(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
    }

    @Override
    public Object getValueAt(Object object, int n) {
        PObjectNode pObjectNode = (PObjectNode)object;
        Race race = null;
        String string = "";
        if (pObjectNode == null) {
            Logging.errorPrintLocalised("Errors.TreeTableModel.NoActiveNode", this.getClass().toString());
            return null;
        }
        FollowerOption followerOption = null;
        if (pObjectNode.getItem() instanceof FollowerOption) {
            followerOption = (FollowerOption)pObjectNode.getItem();
            race = followerOption.getRace();
        } else if (pObjectNode.getItem() instanceof Race) {
            race = (Race)pObjectNode.getItem();
        } else if (pObjectNode.getItem() instanceof Follower) {
            pObjectNode.getItem();
        }
        int n2 = this.adjustColumnConst(n);
        switch (n2) {
            case 0: {
                if (race != null) {
                    return race.getDisplayName();
                }
                return pObjectNode.toString();
            }
            case 1: {
                if (race == null) break;
                Formula formula = race.get(FormulaKey.SIZE);
                string = formula == null ? "" : formula.toString();
                break;
            }
            case 2: {
                if (race == null) {
                    return null;
                }
                List<Movement> list = race.getListFor(ListKey.MOVEMENT);
                if (list == null || list.isEmpty()) break;
                string = list.get(0).toString();
                break;
            }
            case 3: {
                if (race == null) break;
                string = VisionDisplay.getVision(this.pc, race);
                break;
            }
            case 4: {
                if (race == null) break;
                string = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, race.getPrerequisiteList(), true);
                break;
            }
            case 5: {
                if (race == null) break;
                RaceType raceType = race.get(ObjectKey.RACETYPE);
                string = raceType == null ? "" : raceType.toString();
                break;
            }
            case 6: {
                if (race == null) break;
                string = race.getDefaultSourceString();
                break;
            }
            case 7: {
                if (followerOption == null) break;
                return String.valueOf(followerOption.getAdjustment());
            }
            default: {
                Logging.errorPrintLocalised("Errors.FollowerModel", n2, this.getClass().toString());
            }
        }
        return string;
    }

    private void setRoot(PObjectNode pObjectNode) {
        super.setRoot(pObjectNode);
    }

    private int adjustColumnConst(int n) {
        return n;
    }

    public void resetModel(int n) {
        this.avaRoot = new PObjectNode();
        this.setRoot(this.avaRoot);
        String string = this.getQFilter();
        for (CompanionList companionList : Globals.getContext().ref.getConstructedCDOMObjects(CompanionList.class)) {
            int n2 = this.pc.getMaxFollowers(companionList);
            if (n2 == 0) continue;
            PObjectNode pObjectNode = new PObjectNode();
            String string2 = companionList.getKeyName();
            pObjectNode.setDisplayName(CoreUtility.capitalizeFirstLetter(string2));
            this.avaRoot.addChild(pObjectNode);
            List<FollowerOption> list = this.pc.getAvailableFollowers(string2);
            switch (n) {
                default: {
                    Collections.sort(list);
                    break;
                }
                case 1: {
                    Collections.sort(list, new Comparator<FollowerOption>(){

                        @Override
                        public int compare(FollowerOption followerOption, FollowerOption followerOption2) {
                            int n = followerOption2.getAdjustment() - followerOption.getAdjustment();
                            if (n == 0) {
                                return followerOption.compareTo(followerOption2);
                            }
                            return n;
                        }
                    });
                    break;
                }
                case 2: {
                    Collections.sort(list, new Comparator<FollowerOption>(){

                        @Override
                        public int compare(FollowerOption followerOption, FollowerOption followerOption2) {
                            Race race = followerOption.getRace();
                            Race race2 = followerOption2.getRace();
                            if (race == null) {
                                return 1;
                            }
                            if (race2 == null) {
                                return -1;
                            }
                            Collator collator = Collator.getInstance();
                            RaceType raceType = race.get(ObjectKey.RACETYPE);
                            RaceType raceType2 = race2.get(ObjectKey.RACETYPE);
                            int n = collator.compare(raceType.toString(), raceType2.toString());
                            if (n == 0) {
                                return followerOption.compareTo(followerOption2);
                            }
                            return n;
                        }
                    });
                }
            }
            for (FollowerOption followerOption : list) {
                if (string != null && followerOption.getRace().getDisplayName().toLowerCase().indexOf(string) < 0) continue;
                PObjectNode pObjectNode2 = new PObjectNode(followerOption);
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl = followerOption.qualifies(this.pc);
                if (!bl) {
                    stringBuffer.append("<html>");
                    stringBuffer.append(SettingsHandler.getPrereqFailColorAsHtmlStart());
                }
                stringBuffer.append(followerOption.getRace().getDisplayName());
                if (!bl) {
                    stringBuffer.append(SettingsHandler.getPrereqFailColorAsHtmlEnd());
                    stringBuffer.append("</html>");
                }
                pObjectNode2.setDisplayName(stringBuffer.toString());
                pObjectNode.addChild(pObjectNode2);
            }
        }
        PObjectNode pObjectNode = (PObjectNode)this.getRoot();
        if (pObjectNode.getChildCount() > 0) {
            this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
        }
    }

    @Override
    public List<String> getMColumnList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i < this.avaNameList.length; ++i) {
            arrayList.add(this.avaNameList[i]);
        }
        return arrayList;
    }

    @Override
    public boolean isMColumnDisplayed(int n) {
        return this.displayList.get(n);
    }

    @Override
    public void setMColumnDisplayed(int n, boolean bl) {
        this.setColumnViewOption(this.avaNameList[n], bl);
        this.displayList.set(n, bl);
    }

    @Override
    public int getMColumnOffset() {
        return 1;
    }

    @Override
    public int getMColumnDefaultWidth(int n) {
        return SettingsHandler.getPCGenOption("InfoResources.AFollowerModel.sizecol." + this.avaNameList[n], this.avaDefaultWidth[n]);
    }

    @Override
    public void setMColumnDefaultWidth(int n, int n2) {
        SettingsHandler.setPCGenOption("InfoResources.AFollowerModel.sizecol." + this.avaNameList[n], n2);
    }

    private boolean getColumnViewOption(String string, boolean bl) {
        return SettingsHandler.getPCGenOption("InfoResources.AFollowerModel.viewcol." + string, bl);
    }

    private void setColumnViewOption(String string, boolean bl) {
        SettingsHandler.setPCGenOption("InfoResources.AFollowerModel.viewcol." + string, bl);
    }

    @Override
    public void resetMColumn(int n, TableColumn tableColumn) {
    }
}

