/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.gui.tabs.ability.AbilitySelectionPanel;
import pcgen.gui.tabs.ability.IAbilitySelectionListener;
import pcgen.gui.tabs.components.AddItemPanel;
import pcgen.gui.tabs.components.FilterPanel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableAbilityPanel
extends AbilitySelectionPanel {
    private static final String AVAILABLE_LABEL = PropertyFactory.getString("in_available") + ": ";
    private AddItemPanel theAddButton;
    private JMenuItem theAddMenu;

    public AvailableAbilityPanel(PlayerCharacter playerCharacter, AbilityCategory abilityCategory) {
        super(playerCharacter, abilityCategory);
        this.setLayout(new BorderLayout());
        this.add((Component)new FilterPanel(this, AVAILABLE_LABEL), "North");
        this.theAddButton = new AddItemPanel();
        this.theAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AvailableAbilityPanel.this.addAbility();
            }
        });
        this.add((Component)this.theAddButton, "South");
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.theTable.addMouseListener(new JTreeTableMouseAdapter(this.theTable, new AvailableClickHandler(), false));
        this.theTable.addPopupMenu(new AbilityPopupMenu(this.theTable));
    }

    private void addAbility() {
        Object object = this.theTable.getTree().getLastSelectedPathComponent();
        final Ability ability = this.getAbilityFromObject(object);
        if (ability == null) {
            return;
        }
        for (final IAbilitySelectionListener iAbilitySelectionListener : this.getListeners()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    iAbilitySelectionListener.addAbility(ability);
                }
            });
        }
    }

    private void setAddEnabled(boolean bl) {
        this.theAddButton.setEnabled(bl);
        this.theAddMenu.setEnabled(bl);
    }

    @Override
    public boolean accept(AbilitySelectionPanel.ViewMode viewMode, Ability ability) {
        if (!super.accept(viewMode, ability)) {
            return false;
        }
        if (viewMode == AbilitySelectionPanel.ViewMode.PREREQTREE) {
            return true;
        }
        if (ability.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            return true;
        }
        if (this.getPC().hasVirtualAbility(this.getCategory(), ability)) {
            return true;
        }
        return !this.getPC().hasAbility(null, Ability.Nature.ANY, ability);
    }

    @Override
    public void update() {
        if (this.theTable != null) {
            int n = this.theTable.convertColumnIndexToView(0);
            if (n < 0) {
                n = 0;
            }
            TableColumn tableColumn = this.theTable.getColumnModel().getColumn(n);
            String string = this.getCategory().getDisplayName();
            if (string.startsWith("in_")) {
                string = PropertyFactory.getFormattedString(string, new Object[0]);
            }
            tableColumn.setHeaderValue(string);
        }
        super.update();
    }

    @Override
    protected Map<AbilityCategory, List<Ability>> getAbilityList() {
        HashMap<AbilityCategory, List<Ability>> hashMap = new HashMap<AbilityCategory, List<Ability>>();
        hashMap.put(this.getCategory(), Globals.getAbilityList(this.getCategory()));
        return hashMap;
    }

    @Override
    protected String getOptionKey() {
        return "available";
    }

    @Override
    public AbilitySelectionPanel.ViewMode getDefaultViewMode() {
        return AbilitySelectionPanel.ViewMode.PREREQTREE;
    }

    @Override
    protected void abilitySelected(Ability ability) {
        super.abilitySelected(ability);
        if (ability != null) {
            this.setAddEnabled(this.getPC().canSelectAbility(ability));
        } else {
            this.setAddEnabled(false);
        }
    }

    @Override
    protected boolean getSplitByCategory() {
        return false;
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AvailableAbilityPanel.this.addAbility();
                }
            });
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AbilityPopupMenu
    extends JPopupMenu {
        private JMenuItem poolFullMenuItem;
        private JMenuItem noQualifyMenuItem;
        private JTreeTable theTreeTable;

        private AbilityPopupMenu(JTreeTable jTreeTable) {
            this.theTreeTable = jTreeTable;
            String string = PropertyFactory.getFormattedString("InfoAbility.Menu.Add", AvailableAbilityPanel.this.getCategory().getDisplayName());
            String string2 = PropertyFactory.getFormattedString("InfoAbility.Menu.Add.Tooltip", AvailableAbilityPanel.this.getCategory().getDisplayName());
            this.add(AvailableAbilityPanel.this.theAddMenu = Utility.createMenuItem(string, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            AvailableAbilityPanel.this.addAbility();
                        }
                    });
                }
            }, null, '\u0000', "shortcut EQUALS", string2, "Add16.gif", true));
            String string3 = PropertyFactory.getString("InfoAbility.Messages.NotQualified");
            String string4 = PropertyFactory.getString("InfoAbility.Messages.NoPoints");
            this.noQualifyMenuItem = Utility.createMenuItem(string3, null, null, '\u0000', null, null, null, false);
            this.poolFullMenuItem = Utility.createMenuItem(string4, null, null, '\u0000', null, null, null, false);
        }

        public void show(Component component, int n, int n2) {
            PObjectNode pObjectNode = (PObjectNode)this.theTreeTable.getTree().getLastSelectedPathComponent();
            if (pObjectNode != null && pObjectNode.getItem() instanceof Ability) {
                Ability ability = (Ability)((PObjectNode)this.theTreeTable.getTree().getLastSelectedPathComponent()).getItem();
                if (AvailableAbilityPanel.this.getPC().canSelectAbility(ability)) {
                    this.removeAll();
                    this.add(AvailableAbilityPanel.this.theAddMenu);
                } else if (AvailableAbilityPanel.this.getPC().getAvailableAbilityPool(AvailableAbilityPanel.this.getCategory()).compareTo(BigDecimal.ZERO) < 0) {
                    this.removeAll();
                    this.add(this.poolFullMenuItem);
                } else {
                    this.removeAll();
                    this.add(this.noQualifyMenuItem);
                }
                super.show(component, n, n2);
            } else {
                this.removeAll();
                super.show(component, n, n2);
            }
        }
    }
}

