/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs.ability;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.Aspect;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.BenefitFormatting;
import pcgen.core.PlayerCharacter;
import pcgen.core.analysis.DescriptionFormatting;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class AbilityInfoPanel
extends JPanel {
    private PlayerCharacter thePC;
    private Ability theAbility = null;
    private JLabelPane theInfoLabel = new JLabelPane();
    private final TitledBorder border;

    public AbilityInfoPanel(PlayerCharacter playerCharacter, String string) {
        this.thePC = playerCharacter;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        JScrollPane jScrollPane = new JScrollPane();
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.border = BorderFactory.createTitledBorder(string);
        this.border.setTitleJustification(2);
        jScrollPane.setBorder(this.border);
        this.theInfoLabel.setBackground(this.getBackground());
        jScrollPane.setViewportView(this.theInfoLabel);
        Utility.setDescription(jScrollPane, PropertyFactory.getString("in_infoScrollTip"));
        this.add(jScrollPane);
    }

    public void setPC(PlayerCharacter playerCharacter) {
        this.thePC = playerCharacter;
    }

    public void setAbility(Ability ability) {
        this.theAbility = ability;
        this.theInfoLabel.setText(this.getDisplayString());
    }

    public void setCategory(AbilityCategory abilityCategory) {
        this.border.setTitle(PropertyFactory.getFormattedString("InfoAbility.Title", abilityCategory.getDisplayName()));
        this.repaint();
    }

    private String getDisplayString() {
        Object object;
        String string;
        if (this.theAbility == null) {
            return "<html></html>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>").append("<font size=+1>").append("<b>");
        stringBuffer.append(OutputNameFormatting.piString(this.theAbility, false));
        stringBuffer.append("</b>").append("</font>").append("<br>");
        stringBuffer.append(PropertyFactory.getFormattedString("Ability.Info.Type", StringUtil.join(this.theAbility.getTrueTypeList(true), ". ")));
        BigDecimal bigDecimal = this.theAbility.getSafe(ObjectKey.SELECTION_COST);
        if (!bigDecimal.equals(BigDecimal.ONE)) {
            stringBuffer.append(PropertyFactory.getFormattedString("Ability.Info.Cost", bigDecimal));
        }
        if (this.theAbility.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue()) {
            stringBuffer.append(" &nbsp; ").append(PropertyFactory.getString("Ability.Info.Multiple"));
        }
        if (this.theAbility.getSafe(ObjectKey.STACKS).booleanValue()) {
            stringBuffer.append(" &nbsp; ").append(PropertyFactory.getString("Ability.Info.Stacks"));
        }
        if ((string = PrerequisiteUtilities.preReqHTMLStringsForList(this.thePC, null, this.theAbility.getPrerequisiteList(), false)).length() > 0) {
            stringBuffer.append(PropertyFactory.getFormattedString("in_InfoRequirements", string));
        }
        stringBuffer.append("<br>");
        stringBuffer.append(PropertyFactory.getFormattedString("in_InfoDescription", DescriptionFormatting.piDescSubString(this.thePC, this.theAbility)));
        if (this.theAbility.getSafeSizeOfMapFor(MapKey.ASPECT) > 0) {
            object = this.theAbility.getKeysFor(MapKey.ASPECT);
            StringBuffer stringBuffer2 = new StringBuffer();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AspectName aspectName = (AspectName)iterator.next();
                Aspect aspect = this.theAbility.get(MapKey.ASPECT, aspectName);
                if (stringBuffer2.length() > 0) {
                    stringBuffer2.append(", ");
                }
                stringBuffer2.append(aspect.getName()).append(": ");
                stringBuffer2.append(aspect.getAspectText(this.thePC, this.theAbility));
            }
            stringBuffer.append("<br>");
            stringBuffer.append(PropertyFactory.getFormattedString("Ability.Info.Aspects", stringBuffer2.toString()));
        }
        if ((object = BenefitFormatting.getBenefits(this.thePC, this.theAbility)) != null && ((String)object).length() > 0) {
            stringBuffer.append("<br>");
            stringBuffer.append(PropertyFactory.getFormattedString("Ability.Info.Benefit", BenefitFormatting.getBenefits(this.thePC, this.theAbility)));
        }
        stringBuffer.append(PropertyFactory.getFormattedString("in_InfoSource", this.theAbility.getDefaultSourceString()));
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }
}

