/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.Constants;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Movement;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SettingsHandler;
import pcgen.core.StatList;
import pcgen.core.analysis.BonusCalc;
import pcgen.core.analysis.RaceStat;
import pcgen.core.display.VisionDisplay;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.NameGui;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.pcGenGUI;
import pcgen.gui.tabs.InfoSpecialAbilities;
import pcgen.gui.tabs.TabUtils;
import pcgen.gui.utils.FormattedCellEditor;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.RegexFormatter;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoSummary
extends FilterAdapterPanel
implements CharacterInfoTab {
    private static final Tab tab = Tab.SUMMARY;
    private static final String NONABILITY = PropertyFactory.getString("in_sumCannotModifyANonAbility");
    private static final int STAT_COLUMN = 0;
    private static final int BASE_COLUMN = 1;
    private static final int RACE_COLUMN = 2;
    private static final int OTHER_COLUMN = 3;
    private static final int TOTAL_COLUMN = 4;
    private static final int MOD_COLUMN = 5;
    private static final int INC_COLUMN = 6;
    private static final int DEC_COLUMN = 7;
    private static boolean needsUpdate = true;
    private static final int COL_PCLEVEL = 0;
    private static final int COL_CLASSNAME = 1;
    private static final int COL_SRC = 2;
    private ClassComboModel classComboModel = null;
    private ClassModel pcClassTreeModel = null;
    private InfoSpecialAbilities infoSpecialAbilities;
    private JButton jButtonHP = null;
    private JButton lvlDownButton = new JButton("-");
    private JButton lvlUpButton = new JButton("+");
    private JComboBoxEx alignmentComboBox = new JComboBoxEx();
    private JComboBoxEx classComboBox = new JComboBoxEx();
    private JComboBoxEx raceComboBox = new JComboBoxEx();
    private JFrame abilitiesFrame = new JFrame(PropertyFactory.getString("in_specialabilities"));
    private JLabel labelAlignment = null;
    private JLabel labelClass = null;
    private JLabel labelHPName = null;
    private JLabel labelHP = new JLabel();
    private JLabel labelName = null;
    private JLabel labelRace = null;
    private JLabel poolLabel = new JLabel(PropertyFactory.getString("in_sumStatCost"));
    private JLabel poolText = new JLabel();
    private JLabel poolPointLabel = null;
    private JLabel poolPointText = null;
    private JPanel levelPanel = new JPanel();
    private JPanel northPanel = new JPanel();
    private JPanel poolPanel = new JPanel();
    private JTableEx pcClassTable;
    private JTextField pcNameText = new JTextField("");
    private JTextField playerNameText = new JTextField("");
    private JTextField tabNameText = new JTextField("");
    private RaceComboModel raceComboModel = null;
    private WholeNumberField levelText = new WholeNumberField(1, 3);
    private String[] alignmentStrings;
    private boolean abilitiesFrameHasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private ActionListener abilitiesListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!InfoSummary.this.abilitiesFrameHasBeenSized) {
                Dimension dimension = PCGen_Frame1.getCharacterPane().getParent().getParent().getSize();
                int n = dimension.height;
                int n2 = dimension.width;
                InfoSummary.this.abilitiesFrame.setSize(n2, n);
                InfoSummary.this.abilitiesFrameHasBeenSized = true;
            }
            InfoSummary.this.abilitiesFrame.setVisible(true);
        }
    };
    private ActionListener alignmentListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (InfoSummary.this.alignmentComboBox.getSelectedItem() != null) {
                InfoSummary.this.alignmentChanged();
            }
        }
    };
    private ActionListener classListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (InfoSummary.this.classComboBox.getSelectedItem() != null) {
                PCClass pCClass = (PCClass)InfoSummary.this.classComboBox.getSelectedItem();
                InfoSummary.this.setInfoLabelText(pCClass);
                if (pCClass.isQualified(InfoSummary.this.pc)) {
                    InfoSummary.this.labelClass.setForeground(new Color(SettingsHandler.getPrereqQualifyColor()));
                } else {
                    InfoSummary.this.labelClass.setForeground(new Color(SettingsHandler.getPrereqFailColor()));
                }
            }
        }
    };
    private ActionListener levelCmdListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = InfoSummary.this.levelText.getValue();
            if (n <= 0) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumNumberOfLevelsMustBePositive"), "PCGen", MessageType.ERROR);
                return;
            }
            PCClass pCClass = (PCClass)InfoSummary.this.classComboBox.getSelectedItem();
            if (pCClass.getDisplayName().equals("<none selected>")) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouMustSelectAClass"), "PCGen", MessageType.ERROR);
                return;
            }
            if (pCClass == null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouMustSelectAClass"), "PCGen", MessageType.ERROR);
                return;
            }
            if (!pCClass.isQualified(InfoSummary.this.pc)) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumYouAreNotQualifiedToTakeTheClass", pCClass.getDisplayName()), "PCGen", MessageType.ERROR);
                return;
            }
            if (actionEvent.getSource() == InfoSummary.this.lvlDownButton) {
                n *= -1;
            }
            InfoSummary.this.addClass(pCClass, n);
            InfoSummary.this.pcClassTreeModel.fireTableDataChanged();
        }
    };
    private ActionListener raceListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Race race = (Race)InfoSummary.this.raceComboBox.getSelectedItem();
            if (race.getDisplayName().equals("<none selected>")) {
                InfoSummary.this.enableClassControls(false);
            } else if (race != null) {
                InfoSummary.this.setInfoLabelText(race);
                InfoSummary.this.enableClassControls(true);
            }
        }
    };
    private ActionListener randNameListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (InfoSummary.this.nameFrame == null) {
                InfoSummary.this.nameFrame = new NameGui(InfoSummary.this.pc);
            } else {
                InfoSummary.this.nameFrame.setPc(InfoSummary.this.pc);
            }
            InfoSummary.this.nameFrame.setVisible(true);
        }
    };
    private InputVerifier pcNameInputVerify = new InputVerifier(){

        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            String string = InfoSummary.this.pcNameText.getText();
            if (string != null && !string.equals(InfoSummary.this.pc.getName())) {
                InfoSummary.this.pc.setName(string);
                PCGen_Frame1.forceUpdate_PlayerTabs();
            }
            return bl;
        }

        public boolean verify(JComponent jComponent) {
            return true;
        }
    };
    private InputVerifier playerNameInputVerify = new InputVerifier(){

        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            String string = InfoSummary.this.playerNameText.getText();
            if (string != null && !string.equals(InfoSummary.this.pc.getPlayersName())) {
                InfoSummary.this.pc.setPlayersName(string);
            }
            return bl;
        }

        public boolean verify(JComponent jComponent) {
            return true;
        }
    };
    private FocusAdapter raceFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.isTemporary()) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    InfoSummary.this.updateRace();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    };
    private InputVerifier tabNameInputVerify = new InputVerifier(){

        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            String string = InfoSummary.this.tabNameText.getText();
            if (string != null && !string.equals(InfoSummary.this.pc.getTabName())) {
                InfoSummary.this.pc.setTabName(string);
            }
            return bl;
        }

        public boolean verify(JComponent jComponent) {
            return true;
        }
    };
    private JButton abilitiesButton;
    private JButton btnAddHD = new JButton("+");
    private JButton btnRemoveHD = new JButton("-");
    private JButton btnAddKit = new JButton(PropertyFactory.getFormattedString("in_sumCreateMonsterAddKit", new Object[0]));
    private JButton randName;
    private JButton rollStatsButton;
    private JLabel lblHDModify = new JLabel();
    private JLabel lblMonsterlHD = new JLabel();
    private JLabel txtMonsterlHD = new JLabel();
    private JLabelPane infoPane = new JLabelPane();
    private JLabelPane statPane = new JLabelPane();
    private JLabelPane todoPane = new JLabelPane();
    private JPanel pnlHD = new JPanel();
    private JTableEx statTable;
    private NameGui nameFrame = null;
    private RendererEditor plusMinusRenderer = new RendererEditor();
    private StatTableModel statTableModel = new StatTableModel();
    private WholeNumberField txtHD = new WholeNumberField(1, 3);

    public InfoSummary(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.infoSpecialAbilities = new InfoSpecialAbilities(playerCharacter);
        this.setName(tab.toString());
        this.initComponents();
        FilterFactory.restoreFilterSettings(this);
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh(true);
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Summary.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Summary.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isNewCharName(this.pc.getName())) {
            arrayList.add(PropertyFactory.getString("in_sumTodoName"));
        }
        if (Globals.getGameModeAlignmentText().length() != 0 && this.pc.getAlignment() == 9) {
            arrayList.add(PropertyFactory.getString("in_sumTodoAlign"));
        }
        if (this.pc.getTotalLevels() == 0) {
            arrayList.add(PropertyFactory.getString("in_sumTodoStats"));
        }
        if (!SettingsHandler.isAbilitiesShownAsATab()) {
            arrayList.addAll(this.infoSpecialAbilities.getToDos());
        }
        return arrayList;
    }

    private boolean isNewCharName(String string) {
        if (string == null) {
            return true;
        }
        if (!string.startsWith("New") || string.length() < 4) {
            return false;
        }
        try {
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh(false);
        }
        if (this.rollStatsButton != null) {
            if (this.pc.getTotalPlayerLevels() == 0 && SettingsHandler.getGame().getRollMethod() == 3) {
                this.rollStatsButton.setEnabled(true);
            } else {
                this.rollStatsButton.setEnabled(false);
            }
        }
    }

    @Override
    public void forceRefresh() {
        this.forceRefresh(true);
    }

    public void forceRefresh(boolean bl) {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo(bl);
            this.infoSpecialAbilities.setPc(this.pc);
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    public JTextField getPcNameText() {
        return this.pcNameText;
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    public void addMonsterHD(int n) {
        int n2 = this.txtHD.getValue();
        if (n2 <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumNumberOfHitDiceMustBePositive"), "PCGen", MessageType.ERROR);
            return;
        }
        n2 *= n;
        LevelCommandFactory levelCommandFactory = this.pc.getRace().get(ObjectKey.MONSTER_CLASS);
        if (levelCommandFactory != null) {
            if (n2 < 0) {
                int n3 = levelCommandFactory.getLevelCount().resolve(this.pc, "").intValue();
                PCClass pCClass = this.pc.getClassKeyed(levelCommandFactory.getPCClass().getKeyName());
                int n4 = 0;
                if (pCClass != null) {
                    n4 += pCClass.getLevel();
                }
                Logging.errorPrint("minHD=" + n3 + "  currentHD=" + n4 + "  numHD=" + n2);
                if (n4 + n2 < n3) {
                    n2 = n3 - n4;
                    Logging.errorPrint("numHD modified to: " + n2);
                }
                if (pCClass == null || n2 == 0 || n4 + n2 < n3) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumCannotLowerHitDiceAnyMore"), "PCGen", MessageType.ERROR);
                    return;
                }
            }
            this.addClass(levelCommandFactory.getPCClass(), n2);
        }
    }

    @Override
    public void initializeFilters() {
        this.registerFilter(FilterFactory.createPCClassFilter());
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllRaceFilters(this);
        FilterFactory.registerAllClassFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    @Override
    public synchronized void refreshFiltering() {
        this.stopListeners();
        if (this.raceComboModel != null) {
            this.raceComboModel.updateModel();
        }
        if (this.classComboModel != null) {
            this.classComboModel.updateModel();
        }
        this.startListeners();
    }

    public void updateHP() {
        this.labelHP.setText(String.valueOf(this.pc.hitPoints()));
    }

    private static int getUsedStatPool(PlayerCharacter playerCharacter) {
        int n = 0;
        for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBLONG.length; ++i) {
            PCStat pCStat = playerCharacter.getStatList().getStatAt(i);
            if (!pCStat.isRolled()) continue;
            int n2 = playerCharacter.getStatList().getBaseStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[i]);
            n += InfoSummary.getPurchaseCostForStat(playerCharacter, n2);
        }
        return n += (int)playerCharacter.getTotalBonusTo("POINTBUY", "SPENT");
    }

    private void setInfoLabelText(Race race) {
        InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder();
        if (race != null && !race.getDisplayName().startsWith("<none")) {
            String string;
            TransitionChoice<PCClass> transitionChoice;
            Object object;
            infoLabelTextBuilder.appendSmallTitleElement(PropertyFactory.getString("in_sumRace") + race.getDisplayName());
            infoLabelTextBuilder.appendSpacer();
            infoLabelTextBuilder.appendI18nElement("in_sumTYPE", race.getType());
            String string2 = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, race.getPrerequisiteList(), false);
            if (string2.length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumRequirements", string2);
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
                if (RaceStat.isNonAbility(i, race)) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append(PropertyFactory.getString("in_SumNonability"));
                    continue;
                }
                if (BonusCalc.getStatMod(race, i, this.pc) == 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append(':').append(BonusCalc.getStatMod(race, i, this.pc));
            }
            if (stringBuffer.length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumStatAdj", stringBuffer.toString());
            }
            infoLabelTextBuilder.appendSpacer();
            Formula formula = race.get(FormulaKey.SIZE);
            infoLabelTextBuilder.appendI18nElement("in_sumSize", formula == null ? "" : formula.toString());
            List<Movement> list = race.getListFor(ListKey.MOVEMENT);
            if (list != null && !list.isEmpty() && ((String)(object = list.get(0).toString())).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumMove", String.valueOf(object));
            }
            infoLabelTextBuilder.appendSpacer();
            infoLabelTextBuilder.appendI18nElement("in_sumVision", VisionDisplay.getVision(this.pc, race));
            object = race.getListFor(ListKey.FAVORED_CLASS);
            String string3 = null;
            if (object != null && object.size() != 0) {
                string3 = ReferenceUtilities.joinLstFormat(object, ", ");
            } else if (race.getSafe(ObjectKey.ANY_FAVORED_CLASS).booleanValue()) {
                string3 = "Any (Highest Level Class)";
            } else {
                transitionChoice = race.get(ObjectKey.FAVCLASS_CHOICE);
                if (transitionChoice != null) {
                    string3 = "CHOOSE:" + transitionChoice.getChoices().getLSTformat();
                }
            }
            if (string3 != null) {
                transitionChoice = string3.length() == 0 ? PropertyFactory.getString("in_sumVarious") : string3;
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumFavoredClass", (String)((Object)transitionChoice));
            }
            if (((Number)((Object)(transitionChoice = race.getSafe(FormulaKey.LEVEL_ADJUSTMENT).resolve(this.pc, "")))).floatValue() > 0.0f) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumLevelAdj", transitionChoice.toString());
            }
            if ((string = race.getDefaultSourceString()).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumSource1", string);
            }
        }
        this.infoPane.setText(infoLabelTextBuilder.toString());
    }

    private void setInfoLabelText(PCClass pCClass) {
        if (pCClass != null) {
            String string;
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder();
            infoLabelTextBuilder.appendSmallTitleElement(PropertyFactory.getString("in_sumClass") + pCClass.getDisplayName());
            infoLabelTextBuilder.appendSpacer();
            infoLabelTextBuilder.appendI18nElement("in_sumTYPE", pCClass.getType());
            String string2 = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, pCClass.getPrerequisiteList(), false);
            if (string2.length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumRequirements", string2);
            }
            infoLabelTextBuilder.appendSpacer();
            infoLabelTextBuilder.appendI18nElement("in_sumHD", "d" + pCClass.getSafe(ObjectKey.LEVEL_HITDIE).getDie());
            if (Globals.getGameModeShowSpellTab()) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumSpelltype", pCClass.getSpellType());
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumBaseStat", pCClass.getSpellBaseStat());
            }
            if ((string = pCClass.getDefaultSourceString()).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_sumSource1", string);
            }
            this.infoPane.setText(infoLabelTextBuilder.toString());
        }
    }

    private void setStatLabelText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        if (this.pc != null) {
            int n;
            int n2;
            if (Globals.getGameModeACText().length() != 0) {
                stringBuffer.append("<b>").append(Globals.getGameModeACAbbrev()).append("</b> ");
                stringBuffer.append("<i>").append(PropertyFactory.getString("in_sumTotal")).append("</i>: ").append(this.pc.getACTotal());
                if (SettingsHandler.getGame().isValidACType("Flatfooted")) {
                    stringBuffer.append(" <i>").append(PropertyFactory.getString("in_sumFlatfooted")).append("</i>: ").append(this.pc.flatfootedAC());
                }
                if (SettingsHandler.getGame().isValidACType("Touch")) {
                    stringBuffer.append(" <i>").append(PropertyFactory.getString("in_sumTouch")).append("</i>: ").append(this.pc.touchAC());
                }
                stringBuffer.append("<br>");
            } else {
                stringBuffer.append("<b>").append(PropertyFactory.getString("in_sumTotalAC")).append("</b> ").append((int)this.pc.getTotalBonusTo(PropertyFactory.getString("in_sumCombat"), PropertyFactory.getString("in_sumAC")));
                stringBuffer.append("<br>");
            }
            int n3 = this.pc.initiativeMod();
            stringBuffer.append("<b>").append(PropertyFactory.getString("in_sumInit")).append("</b>: ").append(Delta.toString(n3));
            String string = SettingsHandler.getGame().getBabAbbrev();
            if (string == null) {
                string = PropertyFactory.getString("in_sumBAB");
            }
            if (string != null && string.length() != 0) {
                n2 = this.pc.baseAttackBonus();
                stringBuffer.append(" <b>").append(string).append("</b>: ").append(n2);
                n = (int)this.pc.getBonusDueToType("COMBAT", "TOHIT", "EPIC");
                if (n > 0) {
                    stringBuffer.append('+');
                    stringBuffer.append(n);
                    stringBuffer.append('=');
                    stringBuffer.append(n2 + n);
                }
            }
            stringBuffer.append(" <b>").append(Globals.getGameModeHPAbbrev()).append("</b>: ").append(this.pc.hitPoints());
            if (Globals.getGameModeAltHPText().length() != 0) {
                stringBuffer.append(" <b>").append(Globals.getGameModeAltHPAbbrev()).append("</b>: ").append(this.pc.altHP());
            }
            for (n = 0; n < SettingsHandler.getGame().getUnmodifiableCheckList().size(); ++n) {
                if (n == 0) {
                    stringBuffer.append("<br>");
                    stringBuffer.append("<b>").append(PropertyFactory.getString("in_sumSaves")).append("</b>: ");
                }
                n2 = this.pc.getTotalCheck(n);
                stringBuffer.append(" <i>").append(SettingsHandler.getGame().getUnmodifiableCheckList().get(n).toString()).append("</i>: ").append(Delta.toString(n2));
            }
            PCClass pCClass = this.pc.getSelectedFavoredClass();
            if (pCClass != null) {
                stringBuffer.append("<br><b>").append(PropertyFactory.getString("in_sumFavoredClass")).append("</b>: ").append(pCClass.getDisplayName());
            }
            stringBuffer.append("<br><b>").append(PropertyFactory.getString("in_sumSize")).append("</b>: ").append(this.pc.getSize());
        }
        stringBuffer.append("</html>");
        this.statPane.setText(stringBuffer.toString());
    }

    private void addClass(PCClass pCClass, int n) {
        Serializable serializable;
        PCClass pCClass2;
        if (Globals.getGameModeAlignmentText().length() != 0 && n > 0 && this.pc.getAlignment() == SettingsHandler.getGame().getIndexOfAlignment("None")) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouMustSelectAnAlignmentBeforeAddingClasses"), "PCGen", MessageType.ERROR);
            return;
        }
        if (pCClass == null || !pCClass.isQualified(this.pc)) {
            return;
        }
        if (n > 0 && !this.pc.canLevelUp()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_Enforce_rejectLevelUp"), "PCGen", MessageType.ERROR);
            return;
        }
        if (n > 1 && SettingsHandler.getEnforceSpendingBeforeLevelUp()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_Enforce_oneLevelOnly"), "PCGen", MessageType.INFORMATION);
            n = 1;
        }
        if ((pCClass2 = this.pc.getClassKeyed(pCClass.getKeyName())) != null && pCClass2.getSubClassKey() != null && (serializable = pCClass2.getSubClassKeyed(pCClass2.getSubClassKey())) != null && !((PCClass)serializable).isQualified(this.pc)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumYouAreNotQualifiedToTakeTheClass", pCClass2.getDisplayName() + "/" + ((PObject)serializable).getDisplayName()), "PCGen", MessageType.ERROR);
            return;
        }
        if (!Globals.checkRule("LEVELCAP") && pCClass.hasMaxLevel() && (n > pCClass.getSafe(IntegerKey.LEVEL_LIMIT) || pCClass2 != null && pCClass2.getLevel() + n > pCClass2.getSafe(IntegerKey.LEVEL_LIMIT))) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumMaximumLevelIs", String.valueOf(pCClass.getSafe(IntegerKey.LEVEL_LIMIT))), "PCGen", MessageType.INFORMATION);
            return;
        }
        if (this.pc.getTotalLevels() == 0 && n > 0) {
            if (SettingsHandler.getGame().isPurchaseStatMode() && this.pc.getTotalPointBuyPoints() > InfoSummary.getUsedStatPool(this.pc)) {
                int n2 = JOptionPane.showConfirmDialog(this, PropertyFactory.getString("in_sumPoolWarning"), PropertyFactory.getString("in_sumLevelWarnTitle"), 0, 2);
                if (n2 != 0) {
                    return;
                }
            } else if (this.allAbilitiesAreZero()) {
                int n3 = JOptionPane.showConfirmDialog(this, PropertyFactory.getString("in_sumAbilitiesZeroWarning"), PropertyFactory.getString("in_sumLevelWarnTitle"), 0, 2);
                if (n3 != 0) {
                    return;
                }
            } else if (SettingsHandler.isShowWarningAtFirstLevelUp()) {
                serializable = new JCheckBox(PropertyFactory.getString("in_sumAbilitiesWarningCheckBox"), true);
                ((AbstractButton)serializable).addItemListener(new ItemListener((JCheckBox)serializable){
                    final /* synthetic */ JCheckBox val$shouldDisplay;
                    {
                        this.val$shouldDisplay = jCheckBox;
                    }

                    public void itemStateChanged(ItemEvent itemEvent) {
                        SettingsHandler.setShowWarningAtFirstLevelUp(this.val$shouldDisplay.isSelected());
                    }
                });
                JPanel jPanel = InfoSummary.buildMessageLabelPanel(PropertyFactory.getString("in_sumAbilitiesWarning"), (JCheckBox)serializable);
                int n4 = JOptionPane.showConfirmDialog(this, jPanel, PropertyFactory.getString("in_sumLevelWarnTitle"), 0, 2);
                if (n4 != 0) {
                    return;
                }
            }
        }
        this.pc.incrementClassLevel(n, pCClass);
        this.pc.getSpellList();
        PCGen_Frame1.forceUpdate_PlayerTabs();
        serializable = PCGen_Frame1.getCharacterPane();
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoClasses());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoSkills());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoAbilities());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoDomain());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoSpells());
        ((CharacterInfo)serializable).setPaneForUpdate(((CharacterInfo)serializable).infoInventory());
        ((CharacterInfo)serializable).refresh();
        this.infoSpecialAbilities.refresh();
        ((CharacterInfo)serializable).refreshToDosAsync();
        this.statTable.invalidate();
        this.statTable.updateUI();
        this.setStatLabelText();
        if (n > 0) {
            TabUtils.selectClothes(this.pc);
        }
        this.forceRefresh(false);
    }

    private boolean allAbilitiesAreZero() {
        for (PCStat pCStat : this.pc.getStatList()) {
            if (pCStat.getBaseScore() == 0) continue;
            return false;
        }
        return true;
    }

    public static JPanel buildMessageLabelPanel(String string, JCheckBox jCheckBox) {
        JLabel jLabel;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 0;
        int n2 = -1;
        do {
            String string2;
            if ((n2 = string.indexOf("\n", n)) >= 0) {
                string2 = string.substring(n, n2);
                n = n2 + 1;
            } else {
                string2 = string.substring(n);
                n = -1;
            }
            jLabel = new JLabel(string2, 10);
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } while (n >= 0);
        if (jCheckBox != null) {
            jLabel = new JLabel("", 10);
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        return jPanel;
    }

    private void alignmentChanged() {
        int n;
        int n2 = this.alignmentComboBox.getSelectedIndex();
        if (n2 == (n = this.pc.getAlignment())) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<PCClass> arrayList = this.pc.getClassList();
        ArrayList<PCClass> arrayList2 = new ArrayList<PCClass>();
        this.pc.setAlignment(n2, false, true);
        for (PCClass pCClass : arrayList) {
            if (pCClass.isQualified(this.pc) || !pCClass.containsKey(ObjectKey.EX_CLASS)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(pCClass.getKeyName());
            arrayList2.add(pCClass);
        }
        if (stringBuffer.length() > 0 && JOptionPane.showConfirmDialog(null, PropertyFactory.getString("in_sumExClassesWarning") + Constants.s_LINE_SEP + stringBuffer, "PCGen", 2, 3) == 2) {
            this.pc.setAlignment(n, false, true);
            this.alignmentComboBox.setSelectedIndex(n);
            return;
        }
        for (PCClass pCClass : arrayList2) {
            this.pc.makeIntoExClass(pCClass);
        }
        this.pc.setAlignment(n2, false, true);
        this.forceRefresh(false);
        this.enableRaceControls(n2 != SettingsHandler.getGame().getIndexOfAlignment("None"));
        PCGen_Frame1.getCharacterPane().refreshToDosAsync();
    }

    private void createClassComboModel() {
        if (this.classComboModel == null) {
            this.classComboModel = new ClassComboModel();
        } else {
            this.classComboModel.updateModel();
        }
    }

    private void createClassTreeModel() {
        if (this.pcClassTreeModel == null) {
            this.pcClassTreeModel = new ClassModel();
        } else {
            this.pcClassTreeModel.resetModel();
        }
    }

    private void createModels() {
        this.createClassTreeModel();
        this.createRaceComboModel();
        this.createClassComboModel();
    }

    private void createRaceComboModel() {
        if (this.raceComboModel == null) {
            this.raceComboModel = new RaceComboModel();
        } else {
            this.raceComboModel.updateModel();
        }
    }

    private void createTreeTables() {
        this.pcClassTable = new JTableEx(this.pcClassTreeModel);
        this.pcClassTable.setSelectionMode(0);
        this.pcClassTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                String string = InfoSummary.this.pc.getLevelInfoClassKeyName(InfoSummary.this.pcClassTable.getSelectedRow());
                PCClass pCClass = Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, string);
                if (pCClass != null) {
                    InfoSummary.this.classComboBox.setSelectedItem(pCClass);
                }
            }
        });
    }

    private void enableRaceControls(boolean bl) {
        this.raceComboBox.setEnabled(bl);
        if (!((Race)this.raceComboBox.getSelectedItem()).getDisplayName().equals("<none selected>")) {
            this.enableClassControls(true);
        } else {
            this.enableClassControls(false);
        }
    }

    private void enableClassControls(boolean bl) {
        this.classComboBox.setEnabled(bl);
        this.levelText.setEnabled(bl);
        this.lvlUpButton.setEnabled(bl);
        this.lvlDownButton.setEnabled(bl);
    }

    private void formComponentHidden() {
        this.updateRace();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("");
        this.refresh();
    }

    private TableColumn setStatTableColumnPrefs(int n, int n2, int n3) {
        TableColumn tableColumn = this.statTable.getColumnModel().getColumn(n);
        int n4 = Globals.getCustColumnWidth("AbilitiesS", n);
        boolean bl = SettingsHandler.getGame().getSummaryTabStatColumnVisible(n);
        if (!bl) {
            tableColumn.setMinWidth(0);
            tableColumn.setWidth(0);
            tableColumn.setMaxWidth(0);
            tableColumn.setResizable(false);
            n4 = 0;
        } else if (n4 == 0) {
            n4 = n2;
        }
        tableColumn.setPreferredWidth(n4);
        tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", n));
        this.statTable.setColAlign(n, n3);
        if (!bl) {
            tableColumn = null;
        }
        return tableColumn;
    }

    private void initComponents() {
        JComponent jComponent;
        JComponent jComponent2;
        Serializable serializable;
        this.readyForRefresh = true;
        JScrollPane jScrollPane = new JScrollPane();
        this.statTable = new JTableEx();
        this.statTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.statTable.setModel(this.statTableModel);
        this.statTable.setSelectionMode(0);
        this.statTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                InfoSummary.this.statTableMouseClicked(mouseEvent);
            }
        });
        this.setStatTableColumnPrefs(0, 40, 2);
        TableColumn tableColumn = this.setStatTableColumnPrefs(1, 30, 0);
        if (tableColumn != null) {
            serializable = new JFormattedTextField(new RegexFormatter("\\d{1,4}|\\*"));
            ((JTextField)serializable).setHorizontalAlignment(0);
            tableColumn.setCellEditor(new FormattedCellEditor((JFormattedTextField)serializable));
        }
        this.setStatTableColumnPrefs(2, 20, 0);
        this.setStatTableColumnPrefs(3, 20, 0);
        this.setStatTableColumnPrefs(4, 20, 0);
        this.setStatTableColumnPrefs(5, 20, 0);
        tableColumn = this.statTable.getColumnModel().getColumn(6);
        tableColumn.setCellRenderer(this.plusMinusRenderer);
        tableColumn.setMaxWidth(30);
        tableColumn.setMinWidth(30);
        tableColumn = this.statTable.getColumnModel().getColumn(7);
        tableColumn.setCellRenderer(this.plusMinusRenderer);
        tableColumn.setMaxWidth(30);
        tableColumn.setMinWidth(30);
        jScrollPane.setViewportView(this.statTable);
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.northPanel.setLayout((LayoutManager)((Object)serializable));
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.createModels();
        this.createTreeTables();
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelName = new JLabel(PropertyFactory.getString("in_sumCharString") + ": ");
        ((GridBagLayout)serializable).setConstraints(this.labelName, gridBagConstraints);
        this.northPanel.add(this.labelName);
        Utility.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 3.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)serializable).setConstraints(this.pcNameText, gridBagConstraints);
        this.northPanel.add(this.pcNameText);
        Utility.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.randName = new JButton(PropertyFactory.getString("in_sumRandomNameString"));
        ((GridBagLayout)serializable).setConstraints(this.randName, gridBagConstraints);
        this.northPanel.add(this.randName);
        Utility.setDescription(this.randName, PropertyFactory.getString("in_randNameTip"));
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_tabString") + ": ");
        ((GridBagLayout)serializable).setConstraints(jLabel, gridBagConstraints);
        this.northPanel.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)serializable).setConstraints(this.tabNameText, gridBagConstraints);
        this.northPanel.add(this.tabNameText);
        this.tabNameText.setInputVerifier(this.tabNameInputVerify);
        Utility.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        JLabel jLabel2 = new JLabel(PropertyFactory.getString("in_sumPlayerString") + ": ");
        ((GridBagLayout)serializable).setConstraints(jLabel2, gridBagConstraints);
        this.northPanel.add(jLabel2);
        Utility.buildConstraints(gridBagConstraints, 1, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)serializable).setConstraints(this.playerNameText, gridBagConstraints);
        this.northPanel.add(this.playerNameText);
        this.playerNameText.setInputVerifier(this.playerNameInputVerify);
        Utility.buildConstraints(gridBagConstraints, 3, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelAlignment = new JLabel(PropertyFactory.getString("in_alignString") + ": ");
        ((GridBagLayout)serializable).setConstraints(this.labelAlignment, gridBagConstraints);
        this.northPanel.add(this.labelAlignment);
        Utility.buildConstraints(gridBagConstraints, 4, 0, 1, 1, 2.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)serializable).setConstraints(this.alignmentComboBox, gridBagConstraints);
        this.northPanel.add(this.alignmentComboBox);
        this.alignmentComboBox.setModel(new DefaultComboBoxModel<String>(this.populateAlignmentStrings()));
        Utility.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelRace = new JLabel(PropertyFactory.getString("in_raceString") + ": ");
        ((GridBagLayout)serializable).setConstraints(this.labelRace, gridBagConstraints);
        this.northPanel.add(this.labelRace);
        Utility.buildConstraints(gridBagConstraints, 4, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)serializable).setConstraints(this.raceComboBox, gridBagConstraints);
        this.northPanel.add(this.raceComboBox);
        this.raceComboModel = new RaceComboModel();
        this.raceComboBox.setModel(this.raceComboModel);
        Utility.buildConstraints(gridBagConstraints, 3, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.labelClass = new JLabel(PropertyFactory.getString("in_classString") + ": ");
        ((GridBagLayout)serializable).setConstraints(this.labelClass, gridBagConstraints);
        this.northPanel.add(this.labelClass);
        Utility.buildConstraints(gridBagConstraints, 4, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        ((GridBagLayout)serializable).setConstraints(this.classComboBox, gridBagConstraints);
        this.northPanel.add(this.classComboBox);
        ClassComboBoxRenderer classComboBoxRenderer = new ClassComboBoxRenderer();
        classComboBoxRenderer.setPreferredSize(new Dimension(200, 17));
        this.classComboBox.setRenderer(classComboBoxRenderer);
        this.classComboModel = new ClassComboModel();
        this.classComboBox.setModel(this.classComboModel);
        Utility.buildConstraints(gridBagConstraints, 3, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jLabel2 = new JLabel(PropertyFactory.getString("in_levelString") + ": ");
        ((GridBagLayout)serializable).setConstraints(jLabel2, gridBagConstraints);
        this.northPanel.add(jLabel2);
        Utility.buildConstraints(gridBagConstraints, 4, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        Utility.setDescription(this.lvlDownButton, PropertyFactory.getString("in_levelDownButtonTooltip"));
        Utility.setDescription(this.lvlUpButton, PropertyFactory.getString("in_levelUpButtonTooltip"));
        Utility.setDescription(this.levelText, PropertyFactory.getString("in_levelTextTooltip"));
        this.levelPanel.setLayout(new FlowLayout(0));
        this.levelPanel.add(this.levelText);
        this.levelPanel.add(this.lvlUpButton);
        this.levelPanel.add(this.lvlDownButton);
        this.levelPanel.add(this.btnAddKit);
        ((GridBagLayout)serializable).setConstraints(this.levelPanel, gridBagConstraints);
        this.northPanel.add(this.levelPanel);
        Utility.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0.0, 0.0);
        this.lblMonsterlHD.setText(PropertyFactory.getString("in_sumMonsterHitDice"));
        gridBagConstraints.anchor = 13;
        this.northPanel.add((Component)this.lblMonsterlHD, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 1, 4, 1, 1, 0.0, 0.0);
        this.txtMonsterlHD.setText("0");
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.northPanel.add((Component)this.txtMonsterlHD, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 3, 4, 1, 1, 0.0, 0.0);
        this.lblHDModify.setText(PropertyFactory.getString("in_sumHDToAddRem"));
        gridBagConstraints.anchor = 13;
        this.northPanel.add((Component)this.lblHDModify, gridBagConstraints);
        this.pnlHD.setLayout(new FlowLayout(0));
        this.pnlHD.add(this.txtHD);
        this.pnlHD.add(this.btnAddHD);
        this.pnlHD.add(this.btnRemoveHD);
        Utility.buildConstraints(gridBagConstraints, 4, 4, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.northPanel.add((Component)this.pnlHD, gridBagConstraints);
        this.btnAddHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSummary.this.addMonsterHD(1);
            }
        });
        this.btnRemoveHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSummary.this.addMonsterHD(-1);
            }
        });
        this.btnAddKit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoSummary.this.addKit();
            }
        });
        Utility.buildConstraints(gridBagConstraints, 0, 5, 5, 2, 0.0, 18.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        this.poolPanel.add(this.poolLabel);
        this.poolText.setPreferredSize(new Dimension(60, 20));
        this.poolPanel.add(this.poolText);
        if (Globals.getGameModeHasPointPool() && this.poolPointLabel == null) {
            this.poolPointLabel = new JLabel(Globals.getGameModePointPoolName() + ": ");
            this.poolPanel.add(this.poolPointLabel);
            this.poolPointText = new JLabel();
            this.poolPointText.setPreferredSize(new Dimension(60, 20));
            this.poolPanel.add(this.poolPointText);
            this.showPointPool();
        }
        if (Globals.getGameModeHPFormula().length() == 0) {
            this.jButtonHP = new JButton();
            this.jButtonHP.setText(Globals.getGameModeHPAbbrev());
            this.jButtonHP.setAlignmentY(0.0f);
            this.jButtonHP.setHorizontalAlignment(2);
            this.jButtonHP.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    pcGenGUI.showHpFrame(InfoSummary.this.pc);
                }
            });
            this.poolPanel.add(this.jButtonHP);
        } else {
            this.labelHPName = new JLabel(Globals.getGameModeHPAbbrev());
            this.poolPanel.add(this.labelHPName);
        }
        this.labelHP.setText("");
        this.labelHP.setHorizontalAlignment(11);
        this.poolPanel.add(this.labelHP);
        jPanel.add((Component)this.poolPanel, "South");
        ((GridBagLayout)serializable).setConstraints(jPanel, gridBagConstraints);
        this.northPanel.add(jPanel);
        this.todoPane.setBackground(this.northPanel.getBackground());
        this.todoPane.setContentType("text/html");
        StringBuffer stringBuffer = new StringBuffer("<html><body></body></html>");
        this.todoPane.setText(stringBuffer.toString());
        this.todoPane.setEditable(false);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setViewportView(this.todoPane);
        jScrollPane2.getViewport().setScrollMode(1);
        jScrollPane2.setBackground(new Color(255, 255, 255));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jScrollPane2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_tipsString"));
        titledBorder.setTitleJustification(2);
        jPanel2.setBorder(titledBorder);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        Utility.buildConstraints(gridBagConstraints, 0, 7, 5, 1, 0.0, 18.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)serializable).setConstraints(jPanel2, gridBagConstraints);
        this.northPanel.add(jPanel2);
        this.infoPane.setBackground(this.northPanel.getBackground());
        this.infoPane.setContentType("text/html");
        this.infoPane.setText("");
        this.infoPane.setEditable(false);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setVerticalScrollBarPolicy(20);
        jScrollPane3.setHorizontalScrollBarPolicy(30);
        jScrollPane3.setViewportView(this.infoPane);
        jScrollPane3.getViewport().setScrollMode(1);
        jScrollPane3.setBackground(this.northPanel.getBackground());
        Utility.setDescription(this.infoPane, PropertyFactory.getString("in_sumAny_requirements_you_don__t_meet_are_in_italics._137"));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jScrollPane3);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(PropertyFactory.getString("in_infoString"));
        titledBorder2.setTitleJustification(2);
        jPanel3.setBorder(titledBorder2);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        Utility.buildConstraints(gridBagConstraints, 5, 0, 1, 5, 9.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)serializable).setConstraints(jPanel3, gridBagConstraints);
        this.northPanel.add(jPanel3);
        tableColumn = this.pcClassTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(15);
        this.pcClassTable.setColAlign(0, 0);
        Utility.buildConstraints(gridBagConstraints, 5, 5, 1, 1, 0.0, 18.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        JScrollPane jScrollPane4 = new JScrollPane(this.pcClassTable);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jScrollPane4);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(PropertyFactory.getString("in_classesString"));
        titledBorder3.setTitleJustification(2);
        jPanel4.setBorder(titledBorder3);
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        ((GridBagLayout)serializable).setConstraints(jPanel4, gridBagConstraints);
        this.northPanel.add(jPanel4);
        if (!SettingsHandler.isAbilitiesShownAsATab()) {
            Utility.buildConstraints(gridBagConstraints, 5, 6, 1, 1, 0.0, 0.0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            this.abilitiesButton = new JButton(PropertyFactory.getString("in_specialabilities"));
            ((GridBagLayout)serializable).setConstraints(this.abilitiesButton, gridBagConstraints);
            this.northPanel.add(this.abilitiesButton);
            this.abilitiesFrame.getContentPane().setLayout(new BorderLayout());
            this.abilitiesFrame.getContentPane().add((Component)this.infoSpecialAbilities, "Center");
            jComponent2 = new JPanel();
            jComponent2.setLayout(new FlowLayout());
            jComponent = new JButton(PropertyFactory.getString("in_close"));
            ((AbstractButton)jComponent).setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InfoSummary.this.abilitiesFrame.setVisible(false);
                    PCGen_Frame1.getCharacterPane().refreshToDosAsync();
                }
            });
            jComponent2.add(jComponent);
            this.abilitiesFrame.getContentPane().add((Component)jComponent2, "South");
            IconUtilitities.maybeSetIcon(this.abilitiesFrame, "PCGenApp.png");
        }
        this.statPane.setBackground(this.northPanel.getBackground());
        this.statPane.setContentType("text/html");
        this.statPane.setText("");
        this.statPane.setEditable(false);
        jComponent2 = new JScrollPane();
        ((JScrollPane)jComponent2).setVerticalScrollBarPolicy(20);
        ((JScrollPane)jComponent2).setHorizontalScrollBarPolicy(30);
        ((JScrollPane)jComponent2).setViewportView(this.statPane);
        ((JScrollPane)jComponent2).getViewport().setScrollMode(1);
        jComponent2.setBackground(new Color(255, 255, 255));
        jComponent = new JPanel();
        jComponent.add(jComponent2);
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder(PropertyFactory.getString("in_statsString"));
        titledBorder4.setTitleJustification(2);
        jComponent.setBorder(titledBorder4);
        jComponent.setLayout(new BoxLayout(jComponent, 1));
        Utility.buildConstraints(gridBagConstraints, 5, 7, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        ((GridBagLayout)serializable).setConstraints(jComponent, gridBagConstraints);
        this.northPanel.add(jComponent);
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoSummary.this.formComponentShown();
            }

            public void componentHidden(ComponentEvent componentEvent) {
                InfoSummary.this.formComponentHidden();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoSummary.this.refresh();
            }
        });
    }

    private void addKit() {
        PCGen_Frame1.getInst().addKit_actionPerformed();
    }

    private String[] populateAlignmentStrings() {
        this.alignmentStrings = SettingsHandler.getGame().getAlignmentListStrings(true);
        return this.alignmentStrings;
    }

    private synchronized void refreshDisplay(boolean bl) {
        Object object;
        int n;
        if (this.pc == null) {
            return;
        }
        this.stopListeners();
        this.pcNameText.setText(this.pc.getName());
        this.tabNameText.setText(this.pc.getTabName());
        this.playerNameText.setText(this.pc.getPlayersName());
        boolean bl2 = false;
        if (this.alignmentStrings.length != SettingsHandler.getGame().getUnmodifiableAlignmentList().size()) {
            bl2 = true;
        } else {
            String[] stringArray = SettingsHandler.getGame().getAlignmentListStrings(true);
            for (int i = 0; i < Math.min(this.alignmentStrings.length, stringArray.length); ++i) {
                if (this.alignmentStrings[i].equals(stringArray[i])) continue;
                bl2 = true;
            }
        }
        if (bl2) {
            this.alignmentComboBox.setModel(new DefaultComboBoxModel<String>(this.populateAlignmentStrings()));
        }
        if ((n = this.pc.getAlignment()) > -1 && n < this.alignmentStrings.length) {
            this.alignmentComboBox.setSelectedIndex(n);
        }
        Race race = this.pc.getRace();
        this.raceComboModel.setSelectedItem(race);
        if (PrereqHandler.passesAll(race.getPrerequisiteList(), this.pc, race)) {
            this.labelRace.setForeground(new Color(SettingsHandler.getPrereqQualifyColor()));
        } else {
            this.labelRace.setForeground(new Color(SettingsHandler.getPrereqFailColor()));
        }
        this.setInfoLabelText(race);
        this.labelClass.setForeground(Color.black);
        if (bl) {
            if (this.pc.getTotalLevels() == 0) {
                this.classComboBox.setSelectedItem(null);
            } else if (this.pc.getLevelInfoSize() != 0) {
                object = this.classComboBox.getSelectedItem();
                for (int i = this.pc.getLevelInfoSize() - 1; i >= 0; --i) {
                    PCClass pCClass = this.pc.getClassKeyed(this.pc.getLevelInfoClassKeyName(i));
                    if (pCClass == null) continue;
                    this.classComboBox.setSelectedItem(Globals.getContext().ref.silentlyGetConstructedCDOMObject(PCClass.class, pCClass.getKeyName()));
                    if (this.classComboBox.getSelectedIndex() >= 0) break;
                }
                if (this.classComboBox.getSelectedIndex() < 0 && object != null) {
                    this.classComboBox.setSelectedItem(object);
                }
            } else {
                object = this.pc.getRace().get(ObjectKey.MONSTER_CLASS);
                if (object == null) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumClassKindErrMsg"), "PCGen", MessageType.ERROR);
                } else {
                    this.classComboBox.setSelectedItem(((LevelCommandFactory)object).getPCClass());
                }
            }
        }
        if ((object = (PCClass)this.classComboBox.getSelectedItem()) != null && !((PCClass)object).isQualified(this.pc)) {
            this.labelClass.setForeground(new Color(SettingsHandler.getPrereqFailColor()));
        }
        this.createModels();
        this.statTableModel.fireTableDataChanged();
        this.statTable.invalidate();
        this.statTable.updateUI();
        try {
            this.pcClassTable.updateUI();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updatePool(false);
        this.setStatLabelText();
        this.enableRaceControls(!this.alignmentComboBox.isVisible() || n != SettingsHandler.getGame().getIndexOfAlignment("None"));
        this.startListeners();
    }

    private void startListeners() {
        this.pcNameText.setInputVerifier(this.pcNameInputVerify);
        this.randName.addActionListener(this.randNameListener);
        this.alignmentComboBox.addActionListener(this.alignmentListener);
        this.raceComboBox.addActionListener(this.raceListener);
        this.raceComboBox.addFocusListener(this.raceFocusListener);
        this.classComboBox.addActionListener(this.classListener);
        this.tabNameText.setInputVerifier(this.tabNameInputVerify);
        this.playerNameText.setInputVerifier(this.playerNameInputVerify);
        this.lvlDownButton.addActionListener(this.levelCmdListener);
        this.lvlUpButton.addActionListener(this.levelCmdListener);
        if (!SettingsHandler.isAbilitiesShownAsATab() && this.abilitiesButton != null) {
            this.abilitiesButton.addActionListener(this.abilitiesListener);
        }
    }

    private void statTableMouseClicked(MouseEvent mouseEvent) {
        int n;
        int n2 = this.statTable.getSelectedRow();
        if (n2 < 0 || n2 >= SettingsHandler.getGame().s_ATTRIBSHORT.length) {
            return;
        }
        int n3 = this.pc.getStatList().getBaseStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[n2]);
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        PCStat pCStat = this.pc.getStatList().getStatAt(n2);
        int n6 = this.statTable.columnAtPoint(mouseEvent.getPoint());
        switch (n6) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                n4 = 1;
                n = this.pc.getTotalLevels();
                int n7 = this.pc.getTotalPlayerLevels();
                int n8 = SettingsHandler.getGame().isPurchaseStatMode();
                if (this.pc.isNonAbility(n2)) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(NONABILITY, "PCGen", MessageType.ERROR);
                    break;
                }
                if (n3 >= pCStat.getMaxValue()) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotRaiseStatAbove", Integer.toString(pCStat.getMaxValue())), "PCGen", MessageType.ERROR);
                    break;
                }
                if (n7 < 2 && n3 >= SettingsHandler.getGame().getPurchaseScoreMax(this.pc) && n8 != 0) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotRaiseStatAbovePurchase", SettingsHandler.getGame().getStatDisplayText(SettingsHandler.getGame().getPurchaseScoreMax(this.pc))), "PCGen", MessageType.ERROR);
                    break;
                }
                if (this.poolPointText != null && n > 0) {
                    n5 = InfoSummary.getPurchaseCostForStat(this.pc, n3 + n4) - InfoSummary.getPurchaseCostForStat(this.pc, n3);
                    break;
                }
                bl = true;
                if (n8 != 0 && n == 0 || n8 != 0 && n <= 0) break;
                this.pc.setPoolAmount(Math.max(this.pc.getPoolAmount() - 1, 0));
                break;
            }
            case 7: {
                n4 = -1;
                n = SettingsHandler.getGame().getPurchaseScoreMin(this.pc);
                int n7 = this.pc.getTotalLevels();
                int n8 = this.pc.getTotalPlayerLevels();
                boolean bl2 = SettingsHandler.getGame().isPurchaseStatMode();
                if (n3 <= pCStat.getMinValue()) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotLowerStatBelow", Integer.toString(pCStat.getMinValue())), "PCGen", MessageType.ERROR);
                    break;
                }
                if (this.pc.isNonAbility(n2)) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(NONABILITY, "PCGen", MessageType.ERROR);
                    break;
                }
                if (n8 < 2 && n3 <= n && bl2) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotLowerStatBelowPurchase", SettingsHandler.getGame().getStatDisplayText(n)), "PCGen", MessageType.ERROR);
                    break;
                }
                if (this.poolPointText != null && n7 > 0) {
                    n5 = InfoSummary.getPurchaseCostForStat(this.pc, n3 + n4) - InfoSummary.getPurchaseCostForStat(this.pc, n3);
                    break;
                }
                bl = true;
                if (bl2 && n7 <= 0) break;
                this.pc.setPoolAmount(this.pc.getPoolAmount() + 1);
                break;
            }
            default: {
                Logging.errorPrint("In InfoSummary.statTableMouseClicked the column " + n6 + " is not handled.");
            }
        }
        if (n5 != 0) {
            if (n5 > 0) {
                if (n5 > this.pc.getSkillPoints()) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumStatPoolEmpty", Globals.getGameModePointPoolName()), "PCGen", MessageType.ERROR);
                } else {
                    bl = true;
                }
            } else if (this.pc.getStatIncrease(SettingsHandler.getGame().s_ATTRIBSHORT[n2], true) <= 0) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumNoAddThisLevel"), "PCGen", MessageType.ERROR);
            } else {
                bl = true;
            }
            if (bl) {
                this.pc.adjustFeats(-n5);
                this.showPointPool();
            }
        }
        if (bl) {
            n = (int)this.pc.getStatBonusTo("HP", "BONUS");
            pCStat.setBaseScore(n3 + n4);
            this.pc.saveStatIncrease(pCStat.getAbb(), n4, false);
            this.updatePool(n4 > 0);
            this.statTableModel.fireTableRowsUpdated(n2, n2);
            this.pc.calcActiveBonuses();
            this.setStatLabelText();
            PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
            if ((int)this.pc.getStatBonusTo("HP", "BONUS") != n) {
                pCGen_Frame1.hpTotal_Changed();
            }
            CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
            characterInfo.setPaneForUpdate(characterInfo.infoSkills());
            characterInfo.setPaneForUpdate(characterInfo.infoSpells());
            characterInfo.refresh();
            this.setStatLabelText();
        }
    }

    private void stopListeners() {
        this.pcNameText.setInputVerifier(null);
        this.randName.removeActionListener(this.randNameListener);
        this.alignmentComboBox.removeActionListener(this.alignmentListener);
        this.raceComboBox.removeActionListener(this.raceListener);
        this.raceComboBox.removeFocusListener(this.raceFocusListener);
        this.classComboBox.removeActionListener(this.classListener);
        this.tabNameText.setInputVerifier(null);
        this.playerNameText.setInputVerifier(null);
        this.lvlDownButton.removeActionListener(this.levelCmdListener);
        this.lvlUpButton.removeActionListener(this.levelCmdListener);
        if (!SettingsHandler.isAbilitiesShownAsATab() && this.abilitiesButton != null) {
            this.abilitiesButton.removeActionListener(this.abilitiesListener);
        }
    }

    private void updateCharacterInfo(boolean bl) {
        this.lblMonsterlHD.setVisible(SettingsHandler.hideMonsterClasses());
        this.txtMonsterlHD.setVisible(SettingsHandler.hideMonsterClasses());
        this.lblHDModify.setVisible(SettingsHandler.hideMonsterClasses());
        this.pnlHD.setVisible(SettingsHandler.hideMonsterClasses());
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.infoSpecialAbilities.refresh();
        Race race = this.pc.getRace();
        if (race != null) {
            this.raceComboBox.setSelectedItem(race.getDisplayName());
        }
        this.showPointPool();
        this.updateHP();
        if (Globals.getGameModeAlignmentText().length() == 0) {
            this.labelAlignment.setVisible(false);
            this.alignmentComboBox.setVisible(false);
        } else {
            this.labelAlignment.setVisible(true);
            this.alignmentComboBox.setVisible(true);
        }
        if (this.pnlHD.isVisible()) {
            this.updateHD();
            this.txtHD.setValue(1);
        }
        this.levelText.setValue(1);
        needsUpdate = false;
        this.refreshDisplay(bl);
    }

    private void updateHD() {
        LevelCommandFactory levelCommandFactory;
        int n = -1;
        int n2 = 0;
        if (this.pc != null && (levelCommandFactory = this.pc.getRace().get(ObjectKey.MONSTER_CLASS)) != null) {
            n2 = levelCommandFactory.getLevelCount().resolve(this.pc, "").intValue();
            PCClass pCClass = this.pc.getClassKeyed(levelCommandFactory.getPCClass().getKeyName());
            if (pCClass != null) {
                n = pCClass.getLevel();
            }
        }
        this.btnAddHD.setEnabled(this.pc.getRace().containsListFor(ListKey.HITDICE_ADVANCEMENT) && n >= 0);
        this.btnRemoveHD.setEnabled(n > n2);
        if (n < 0) {
            n = 0;
        }
        this.txtMonsterlHD.setText(Integer.toString(n));
        this.txtHD.setEnabled(this.btnAddHD.isEnabled() | this.btnRemoveHD.isEnabled());
    }

    private void updatePool(boolean bl) {
        int n;
        int n2;
        int n3 = InfoSummary.getUsedStatPool(this.pc);
        int n4 = this.pc.getTotalPlayerLevels();
        if (n4 <= (n2 = this.poolPointText != null ? 0 : 1)) {
            this.pc.setCostPool(n3);
            this.pc.setPoolAmount(n3);
        }
        if (SettingsHandler.getGame().isPurchaseStatMode()) {
            String string = Integer.toString(this.pc.getCostPool());
            n = this.pc.getTotalPointBuyPoints();
            if (n < 0) {
                n = RollingMethods.roll(SettingsHandler.getGame().getPurchaseModeMethodPoolFormula());
                this.pc.setPointBuyPoints(n);
            }
            if (n != 0) {
                this.poolLabel.setText(PropertyFactory.getString("in_sumStatCost"));
                this.poolText.setText(string + " / " + n);
            }
            if (bl && n != 0 && n4 <= n2 && n > 0 && n3 > n) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumYouHaveExcededTheMaximumPointsOf", String.valueOf(n), SettingsHandler.getGame().getPurchaseModeMethodName()), "PCGen", MessageType.INFORMATION);
            }
        }
        if (this.rollStatsButton != null) {
            if (n4 == 0 && SettingsHandler.getGame().getRollMethod() == 3) {
                this.rollStatsButton.setEnabled(true);
            } else {
                this.rollStatsButton.setEnabled(false);
            }
        } else if (SettingsHandler.getGame().getRollingMethod(0) != null) {
            this.rollStatsButton = new JButton(PropertyFactory.getString("in_demAgeRoll"));
            this.rollStatsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    InfoSummary.this.pc.rollStats(3);
                    InfoSummary.this.statTableModel.fireTableRowsUpdated(0, SettingsHandler.getGame().s_ATTRIBLONG.length);
                    InfoSummary.this.pc.calcActiveBonuses();
                    InfoSummary.this.updatePool(false);
                    CharacterInfo characterInfo = PCGen_Frame1.getCharacterPane();
                    characterInfo.setPaneForUpdate(characterInfo.infoSkills());
                    characterInfo.setPaneForUpdate(characterInfo.infoSpells());
                    characterInfo.refresh();
                    InfoSummary.this.setStatLabelText();
                }
            });
            this.poolPanel.add(this.rollStatsButton);
        }
        if (!SettingsHandler.getGame().isPurchaseStatMode() || this.pc.getTotalPointBuyPoints() == 0) {
            this.poolLabel.setText(PropertyFactory.getString("in_sumStatTotal"));
            int n5 = 0;
            n = 0;
            StatList statList = this.pc.getStatList();
            for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBLONG.length; ++i) {
                PCStat pCStat = this.pc.getStatList().getStatAt(i);
                if (this.pc.isNonAbility(i) || !pCStat.isRolled()) continue;
                int n6 = statList.getBaseStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[i]);
                int n7 = statList.getStatModFor(SettingsHandler.getGame().s_ATTRIBSHORT[i]);
                n5 += n6;
                n += n7;
            }
            this.poolLabel.setText(PropertyFactory.getString("in_sumStatTotal") + Integer.toString(n5) + PropertyFactory.getString("in_sumModifierTotal") + Integer.toString(n));
            this.poolText.setText("");
        }
    }

    private void updateRace() {
        Race race;
        Race race2;
        if (this.raceComboBox.getSelectedItem() != null && !(race2 = (Race)this.raceComboBox.getSelectedItem()).equals(race = this.pc.getRace())) {
            PCClass pCClass;
            int n;
            Object object;
            if (this.pnlHD.isVisible() && (object = race.get(ObjectKey.MONSTER_CLASS)) != null && (n = (pCClass = this.pc.getClassKeyed(((LevelCommandFactory)object).getPCClass().getKeyName())).getLevel() - ((LevelCommandFactory)object).getLevelCount().resolve(this.pc, "").intValue()) > 0) {
                this.addClass(pCClass, -n);
            }
            this.pc.setRace(race2);
            if (this.pnlHD.isVisible()) {
                this.updateHD();
            }
            PCGen_Frame1.forceUpdate_PlayerTabs();
            object = PCGen_Frame1.getCharacterPane();
            ((CharacterInfo)object).setPaneForUpdate(((CharacterInfo)object).infoRace());
            ((CharacterInfo)object).setPaneForUpdate(((CharacterInfo)object).infoAbilities());
            ((CharacterInfo)object).setPaneForUpdate(((CharacterInfo)object).infoSkills());
            ((CharacterInfo)object).setPaneForUpdate(((CharacterInfo)object).infoSpells());
            this.infoSpecialAbilities.refresh();
            ((CharacterInfo)object).refreshToDosAsync();
            this.showPointPool();
            this.updateHP();
            this.refreshDisplay(false);
        }
    }

    private void showPointPool() {
        if (this.poolPointText == null) {
            return;
        }
        int n = 0;
        for (PCLevelInfo pCLevelInfo : this.pc.getLevelInfo()) {
            n += pCLevelInfo.getSkillPointsGained();
        }
        int n2 = n - this.pc.getSkillPoints();
        this.poolPointText.setText(Integer.toString(n2) + " / " + Integer.toString(n));
    }

    private static int getPurchaseCostForStat(PlayerCharacter playerCharacter, int n) {
        int n2 = SettingsHandler.getGame().getPurchaseScoreMax(playerCharacter);
        int n3 = SettingsHandler.getGame().getPurchaseScoreMin(playerCharacter);
        if (n > n2) {
            n = n2;
        }
        if (n >= n3) {
            return SettingsHandler.getGame().getAbilityScoreCost(n - n3);
        }
        return 0;
    }

    public void setToDoList(List<String> list) {
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        int n = 1;
        for (String string : list) {
            stringBuffer.append(n++).append(". ").append(string).append("<br>");
        }
        stringBuffer.append("</body></html>");
        this.todoPane.setText(stringBuffer.toString());
        this.todoPane.setEditable(false);
    }

    class ClassComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ClassComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                PCClass pCClass = (PCClass)object;
                this.setText(pCClass.getDisplayName());
                if (bl) {
                    if (pCClass.isQualified(InfoSummary.this.pc)) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(Color.RED);
                        this.setForeground(jList.getSelectionForeground());
                    }
                } else if (pCClass.isQualified(InfoSummary.this.pc)) {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(Color.RED);
                }
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StatTableModel
    extends AbstractTableModel {
        private StatTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return PropertyFactory.getString("in_sumStat");
                }
                case 1: {
                    return PropertyFactory.getString("in_sumScoreEditable");
                }
                case 2: {
                    return PropertyFactory.getString("in_sumRaceAdj");
                }
                case 3: {
                    return PropertyFactory.getString("in_sumOtherAdj");
                }
                case 4: {
                    return PropertyFactory.getString("in_sumTotal");
                }
                case 5: {
                    return PropertyFactory.getString("in_sumMod");
                }
                case 6: {
                    return "+";
                }
                case 7: {
                    return "-";
                }
            }
            return PropertyFactory.getString("in_sumOut_of_Bounds");
        }

        @Override
        public int getRowCount() {
            if (InfoSummary.this.pc != null) {
                return SettingsHandler.getGame().s_ATTRIBLONG.length;
            }
            return 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= 0 && n < InfoSummary.this.pc.getStatList().size() && n2 == 1) {
                int n3;
                int n4;
                if (object == null) {
                    return;
                }
                int n5 = !"*".equals(object.toString()) ? Delta.parseInt(object.toString()) : 10;
                int n6 = InfoSummary.this.pc.getTotalPlayerLevels();
                PCStat pCStat = InfoSummary.this.pc.getStatList().getStatAt(n);
                if (InfoSummary.this.pc.isNonAbility(n)) {
                    ShowMessageDelegate.showMessageDialog(NONABILITY, "PCGen", MessageType.ERROR);
                    return;
                }
                if (n5 < pCStat.getMinValue()) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotLowerStatBelow", SettingsHandler.getGame().getStatDisplayText(pCStat.getMinValue())), "PCGen", MessageType.ERROR);
                    return;
                }
                if (n5 > pCStat.getMaxValue()) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotRaiseStatAbove", SettingsHandler.getGame().getStatDisplayText(pCStat.getMaxValue())), "PCGen", MessageType.ERROR);
                    return;
                }
                if (n6 < 2 && SettingsHandler.getGame().isPurchaseStatMode()) {
                    n4 = SettingsHandler.getGame().getPurchaseScoreMax(InfoSummary.this.pc);
                    if (n5 > n4) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotRaiseStatAbovePurchase", SettingsHandler.getGame().getStatDisplayText(n4)), "PCGen", MessageType.ERROR);
                        return;
                    }
                    n3 = SettingsHandler.getGame().getPurchaseScoreMin(InfoSummary.this.pc);
                    if (n5 < n3) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumCannotLowerStatBelowPurchase", SettingsHandler.getGame().getStatDisplayText(n3)), "PCGen", MessageType.ERROR);
                        return;
                    }
                }
                n4 = pCStat.getBaseScore();
                if (InfoSummary.this.poolPointText != null && n6 > 0) {
                    n3 = InfoSummary.getPurchaseCostForStat(InfoSummary.this.pc, n5) - InfoSummary.getPurchaseCostForStat(InfoSummary.this.pc, n4);
                    if (n3 > 0) {
                        if (n3 > InfoSummary.this.pc.getSkillPoints()) {
                            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_sumStatPoolEmpty", Globals.getGameModePointPoolName()), "PCGen", MessageType.ERROR);
                            return;
                        }
                    } else if (n3 < 0 && InfoSummary.this.pc.getStatIncrease(pCStat.getAbb(), true) < Math.abs(n5 - n4)) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumStatStartedHigher"), "PCGen", MessageType.ERROR);
                        return;
                    }
                    InfoSummary.this.pc.adjustFeats(-n3);
                    InfoSummary.this.showPointPool();
                }
                pCStat.setBaseScore(n5);
                InfoSummary.this.pc.saveStatIncrease(pCStat.getAbb(), n5 - n4, false);
                InfoSummary.this.setStatLabelText();
                InfoSummary.this.statTableModel.fireTableRowsUpdated(n, n);
                InfoSummary.this.pc.calcActiveBonuses();
                InfoSummary.this.updatePool(true);
                if (n == 1) {
                    // empty if block
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                if (n >= 0 && n < SettingsHandler.getGame().s_ATTRIBLONG.length) {
                    return SettingsHandler.getGame().s_ATTRIBLONG[n];
                }
                return PropertyFactory.getString("in_sumOut_of_Bounds");
            }
            String string = SettingsHandler.getGame().s_ATTRIBSHORT[n];
            switch (n2) {
                case 1: {
                    if (InfoSummary.this.pc.isNonAbility(n)) {
                        return "*";
                    }
                    return InfoSummary.this.pc.getStatList().getBaseStatFor(string);
                }
                case 2: {
                    if (InfoSummary.this.pc.isNonAbility(n)) {
                        return "*";
                    }
                    int n3 = (int)InfoSummary.this.pc.getRaceBonusTo("STAT", string);
                    return n3;
                }
                case 3: {
                    if (InfoSummary.this.pc.isNonAbility(n)) {
                        return "*";
                    }
                    int n4 = (int)InfoSummary.this.pc.getRaceBonusTo("STAT", string);
                    return InfoSummary.this.pc.getStatList().getTotalStatFor(string) - InfoSummary.this.pc.getStatList().getBaseStatFor(string) - n4;
                }
                case 4: {
                    if (InfoSummary.this.pc.isNonAbility(n)) {
                        return "*";
                    }
                    return SettingsHandler.getGame().getStatDisplayText(InfoSummary.this.pc.getStatList().getTotalStatFor(string));
                }
                case 5: {
                    if (InfoSummary.this.pc.isNonAbility(n)) {
                        return 0;
                    }
                    return InfoSummary.this.pc.getStatList().getStatModFor(string);
                }
                case 6: {
                    return "+";
                }
                case 7: {
                    return "-";
                }
            }
            return PropertyFactory.getString("in_sumOut_of_Bounds");
        }
    }

    private final class RendererEditor
    implements TableCellRenderer {
        private DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        private JButton plusButton = new JButton("+");

        private RendererEditor() {
            this.def.setBackground(InfoSummary.this.getBackground());
            this.def.setAlignmentX(0.5f);
            this.def.setHorizontalAlignment(0);
            this.plusButton.setPreferredSize(new Dimension(30, 24));
            this.plusButton.setMinimumSize(new Dimension(30, 24));
            this.plusButton.setMaximumSize(new Dimension(30, 24));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 6) {
                this.def.setText("+");
                this.def.setBorder(BorderFactory.createEtchedBorder());
                return this.def;
            }
            if (n2 == 7) {
                this.def.setText("-");
                this.def.setBorder(BorderFactory.createEtchedBorder());
                return this.def;
            }
            return null;
        }
    }

    private final class RaceComboModel
    extends DefaultComboBoxModel {
        private RaceComboModel() {
            this.updateModel();
        }

        private void updateModel() {
            Object object = this.getSelectedItem();
            this.removeAllElements();
            for (Race race : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
                if (!InfoSummary.this.accept(InfoSummary.this.pc, race)) continue;
                this.addElement(race);
            }
            if (this.getIndexOf(Globals.s_EMPTYRACE) < 0) {
                this.insertElementAt(Globals.s_EMPTYRACE, 0);
            }
            if (object != null && this.getIndexOf(object) < 0) {
                this.insertElementAt(object, 1);
            }
            this.setSelectedItem(object);
        }
    }

    private final class ClassComboModel
    extends DefaultComboBoxModel {
        private ClassComboModel() {
            this.updateModel();
        }

        private void updateModel() {
            Object object = this.getSelectedItem();
            this.removeAllElements();
            for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
                if (SettingsHandler.hideMonsterClasses() && pCClass.isMonster() || !pCClass.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.DEFAULT) || !InfoSummary.this.accept(InfoSummary.this.pc, pCClass)) continue;
                this.addElement(pCClass);
            }
            PCClass pCClass = new PCClass();
            pCClass.setName("<none selected>");
            this.insertElementAt(pCClass, 0);
            if (object != null) {
                this.setSelectedItem(object);
            } else {
                this.setSelectedItem(pCClass);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassModel
    extends AbstractTableModel {
        private ClassModel() {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return PropertyFactory.getString("in_sumLevel");
                }
                case 1: {
                    return PropertyFactory.getString("in_sumClassLvl");
                }
                case 2: {
                    return PropertyFactory.getString("in_sumSource");
                }
            }
            return PropertyFactory.getString("in_sumOut_of_Bounds");
        }

        @Override
        public int getRowCount() {
            int n = 0;
            if (InfoSummary.this.pc != null) {
                for (int i = 0; i < InfoSummary.this.pc.getLevelInfoSize(); ++i) {
                    PCClass pCClass = InfoSummary.this.pc.getClassKeyed(InfoSummary.this.pc.getLevelInfoClassKeyName(i));
                    if (pCClass != null && !this.shouldDisplayThis(pCClass)) continue;
                    ++n;
                }
            }
            return n;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = "";
            switch (n2) {
                case 0: {
                    string = Integer.toString(n + 1);
                    break;
                }
                case 1: {
                    if (InfoSummary.this.pc == null) break;
                    PCClass pCClass = null;
                    int n3 = 0;
                    for (int i = 0; i < InfoSummary.this.pc.getLevelInfoSize(); ++i) {
                        String string2;
                        String string3 = InfoSummary.this.pc.getLevelInfoClassKeyName(i);
                        pCClass = InfoSummary.this.pc.getClassKeyed(string3);
                        if (pCClass == null || !this.shouldDisplayThis(pCClass) || n-- != 0) continue;
                        string = pCClass.getDisplayName();
                        if (string.equals(string2 = pCClass.getDisplayClassName(n3 = InfoSummary.this.pc.getLevelInfoClassLevel(i)))) break;
                        string = string + "/" + string2;
                        break;
                    }
                    if (pCClass != null && pCClass.getLevel() != n3) break;
                    string = string + " (" + Integer.toString(n3) + ')';
                    break;
                }
                case 2: {
                    if (InfoSummary.this.pc == null) break;
                    PObject pObject = null;
                    for (int i = 0; i < InfoSummary.this.pc.getLevelInfoSize(); ++i) {
                        String string4 = InfoSummary.this.pc.getLevelInfoClassKeyName(i);
                        pObject = InfoSummary.this.pc.getClassKeyed(string4);
                        if ((pObject == null || this.shouldDisplayThis((PCClass)pObject)) && n-- == 0) break;
                    }
                    if (pObject == null) break;
                    string = pObject.getDefaultSourceString();
                    break;
                }
                default: {
                    string = PropertyFactory.getString("in_sumOut_of_Bounds");
                }
            }
            return string;
        }

        private void resetModel() {
            this.fireTableDataChanged();
        }

        private boolean shouldDisplayThis(PCClass pCClass) {
            return !SettingsHandler.hideMonsterClasses() || !pCClass.isMonster();
        }
    }
}

