/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.BaseCharacterInfoTab;
import pcgen.gui.tabs.SelectPanel;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoCharacterSheet
extends BaseCharacterInfoTab {
    private ExportHandler theHandler = null;
    private DocumentBuilderImpl theDocBuilder = null;
    private HtmlRendererContext theRendererContext = null;
    private HtmlPanel theSheetPanel = null;
    private SelectPanel theSelectPanel = null;
    private FlippingSplitPane theSplitPane;
    private boolean theHasBeenSizedFlag = false;

    public InfoCharacterSheet(PlayerCharacter playerCharacter) {
        super(playerCharacter);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoCharacterSheet.this.initComponents();
            }
        });
    }

    @Override
    protected Tab getTab() {
        return Tab.CHARACTERSHEET;
    }

    @Override
    public int getTabOrder() {
        return 0;
    }

    @Override
    public void setTabOrder(int n) {
    }

    @Override
    public List<String> getToDos() {
        return Collections.emptyList();
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        super.setPc(playerCharacter);
        if (this.theSelectPanel != null) {
            try {
                this.theSelectPanel.setPc(this.getPc());
            }
            catch (Exception exception) {
                Logging.errorPrint("Could not select PC ", exception);
            }
        }
    }

    private void formComponentShown() {
        if (!this.theHasBeenSizedFlag) {
            this.theHasBeenSizedFlag = true;
            if (this.theSplitPane != null) {
                int n = SettingsHandler.getPCGenOption("InfoCharacterSheet.splitLeftRight", (int)(this.getSize().getWidth() * 6.0 / 10.0));
                this.theSplitPane.setDividerLocation(n);
                this.theSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        SettingsHandler.setPCGenOption("InfoCharacterSheet.splitLeftRight", propertyChangeEvent.getNewValue().toString());
                    }
                });
            }
        }
    }

    @Override
    protected void updateCharacterInfo() {
        if (this.theHandler == null) {
            return;
        }
        if (this.theSelectPanel != null) {
            this.theSelectPanel.refresh();
        }
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.theHandler.write(this.getPc(), bufferedWriter);
        String string = stringWriter.toString().replace("preview_color.css", this.getColorCSS());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            URI uRI = new URI("file", SettingsHandler.getPcgenPreviewDir().getAbsolutePath().replaceAll("\\\\", "/"), null);
            Document document = this.theDocBuilder.parse((InputSource)new InputSourceImpl((InputStream)byteArrayInputStream, uRI.toString(), "UTF-8"));
            this.theSheetPanel.setDocument(document, this.theRendererContext);
        }
        catch (Throwable throwable) {
            String string2 = "<html><body>Unable to process sheet<br>" + throwable + "</body></html>";
            byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            try {
                Document document = this.theDocBuilder.parse((InputStream)byteArrayInputStream);
                this.theSheetPanel.setDocument(document, this.theRendererContext);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            Logging.errorPrint("Unable to process sheet: ", throwable);
        }
    }

    private String getColorCSS() {
        int n = SettingsHandler.getGMGenOption("CharacterSheet.color", 0);
        switch (n) {
            case 0: {
                return "preview_color_blue.css";
            }
            case 1: {
                return "preview_color_light_blue.css";
            }
            case 2: {
                return "preview_color_green.css";
            }
            case 3: {
                return "preview_color_light_green.css";
            }
            case 4: {
                return "preview_color_red.css";
            }
            case 5: {
                return "preview_color_light_red.css";
            }
            case 6: {
                return "preview_color_yellow.css";
            }
            case 7: {
                return "preview_color_light_yellow.css";
            }
            case 8: {
                return "preview_color_grey.css";
            }
            case 9: {
                return "preview_color_light_grey.css";
            }
        }
        return "preview_color_blue.css";
    }

    @Override
    public void initializeFilters() {
    }

    @Override
    public void refreshFiltering() {
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.theRendererContext = new SimpleHtmlRendererContext(this.theSheetPanel);
        this.theDocBuilder = new DocumentBuilderImpl(this.theRendererContext.getUserAgentContext(), this.theRendererContext);
        this.theSheetPanel = new HtmlPanel();
        jPanel.add((Component)this.theSheetPanel, "Center");
        this.theSelectPanel = new SelectPanel(this);
        this.theSplitPane = new FlippingSplitPane(1, jPanel, this.theSelectPanel);
        this.theSplitPane.setOneTouchExpandable(true);
        this.theSplitPane.setDividerSize(10);
        this.add((Component)this.theSplitPane, "Center");
        this.theSheetPanel.setPreferredWidth(this.getWidth());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoCharacterSheet.this.formComponentShown();
            }
        });
    }

    public void setSheet(File file) {
        this.theHandler = new ExportHandler(file);
        this.forceRefresh();
    }
}

