/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.prefs;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.gui.prefs.PCGenPrefsPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

public class LanguagePanel
extends PCGenPrefsPanel {
    private static String in_language = PropertyFactory.getString("in_Prefs_language");
    private static String in_langEnglish = PropertyFactory.getString("in_Prefs_langEnglish");
    private static String in_langFrench = PropertyFactory.getString("in_Prefs_langFrench");
    private static String in_langGerman = PropertyFactory.getString("in_Prefs_langGerman");
    private static String in_langItalian = PropertyFactory.getString("in_Prefs_langItalian");
    private static String in_langSpanish = PropertyFactory.getString("in_Prefs_langSpanish");
    private static String in_langPortuguese = PropertyFactory.getString("in_Prefs_langPortuguese");
    private static String in_langSystem = PropertyFactory.getString("in_Prefs_langSystem");
    private static String in_unitSetType = PropertyFactory.getString("in_Prefs_unitSetType");
    private String[] unitSetNames = null;
    private JRadioButton langEng;
    private JRadioButton langFre;
    private JRadioButton langGer;
    private JRadioButton langIt;
    private JRadioButton langEs;
    private JRadioButton langPt;
    private JRadioButton langSystem;
    private JComboBoxEx unitSetType = new JComboBoxEx();

    public LanguagePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, in_language);
        titledBorder.setTitleJustification(1);
        this.setBorder(titledBorder);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        this.langSystem = new JRadioButton(in_langSystem);
        n = LanguagePanel.addLanguageOption(n, gridBagConstraints, gridBagLayout, this, this.langSystem, buttonGroup);
        TreeSet<JRadioButton> treeSet = new TreeSet<JRadioButton>(new Comparator<JRadioButton>(){

            @Override
            public int compare(JRadioButton jRadioButton, JRadioButton jRadioButton2) {
                return jRadioButton.getText().compareToIgnoreCase(jRadioButton2.getText());
            }
        });
        this.langEng = new JRadioButton(in_langEnglish);
        treeSet.add(this.langEng);
        this.langFre = new JRadioButton(in_langFrench);
        treeSet.add(this.langFre);
        this.langGer = new JRadioButton(in_langGerman);
        treeSet.add(this.langGer);
        this.langIt = new JRadioButton(in_langItalian);
        treeSet.add(this.langIt);
        this.langEs = new JRadioButton(in_langSpanish);
        treeSet.add(this.langEs);
        this.langPt = new JRadioButton(in_langPortuguese);
        treeSet.add(this.langPt);
        for (JRadioButton jRadioButton : treeSet) {
            n = LanguagePanel.addLanguageOption(n, gridBagConstraints, gridBagLayout, this, jRadioButton, buttonGroup);
        }
        Utility.buildConstraints(gridBagConstraints, 0, n++, 1, 1, 0.0, 0.0);
        JLabel jLabel = new JLabel(in_unitSetType + ": ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        Utility.buildConstraints(gridBagConstraints, 1, n++, 2, 1, 0.0, 0.0);
        Map<String, UnitSet> map = SystemCollections.getUnitSetList();
        this.unitSetNames = new String[map.size()];
        int n2 = 0;
        for (UnitSet unitSet : map.values()) {
            if (unitSet == null) continue;
            this.unitSetNames[n2++] = unitSet.getName();
        }
        this.unitSetType = new JComboBoxEx(this.unitSetNames);
        gridBagLayout.setConstraints(this.unitSetType, gridBagConstraints);
        this.add(this.unitSetType);
        Utility.buildConstraints(gridBagConstraints, 5, n, 1, 1, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jLabel = new JLabel(" ");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
    }

    private static int addLanguageOption(int n, GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, JPanel jPanel, JRadioButton jRadioButton, ButtonGroup buttonGroup) {
        Utility.buildConstraints(gridBagConstraints, 0, n++, 2, 1, 0.0, 0.0);
        gridBagLayout.setConstraints(jRadioButton, gridBagConstraints);
        jPanel.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        return n;
    }

    public void applyOptionValuesToControls() {
        this.langEng.setSelected(false);
        this.langFre.setSelected(false);
        this.langGer.setSelected(false);
        this.langIt.setSelected(false);
        this.langEs.setSelected(false);
        this.langPt.setSelected(false);
        this.langSystem.setSelected(false);
        String string = Globals.getLanguage();
        if (string == null || string.equals("")) {
            this.langSystem.setSelected(true);
        } else if (Globals.getLanguage().equals("en")) {
            this.langEng.setSelected(true);
        } else if (Globals.getLanguage().equals("fr")) {
            this.langFre.setSelected(true);
        } else if (Globals.getLanguage().equals("de")) {
            this.langGer.setSelected(true);
        } else if (Globals.getLanguage().equals("it")) {
            this.langIt.setSelected(true);
        } else if (Globals.getLanguage().equals("es")) {
            this.langEs.setSelected(true);
        } else if (Globals.getLanguage().equals("pt")) {
            this.langPt.setSelected(true);
        } else {
            this.langSystem.setSelected(true);
        }
        this.unitSetType.setSelectedIndex(0);
        for (int i = 0; i < SystemCollections.getUnitSetList().size(); ++i) {
            if (!this.unitSetNames[i].equals(SettingsHandler.getGameModeUnitSet().getName())) continue;
            this.unitSetType.setSelectedIndex(i);
        }
    }

    public String getTitle() {
        return in_language;
    }

    public void setOptionsBasedOnControls() {
        if (this.langEng.isSelected()) {
            Globals.setLanguage("en");
            Globals.setCountry("US");
        } else if (this.langFre.isSelected()) {
            Globals.setLanguage("fr");
            Globals.setCountry("FR");
        } else if (this.langGer.isSelected()) {
            Globals.setLanguage("de");
            Globals.setCountry("DE");
        } else if (this.langIt.isSelected()) {
            Globals.setLanguage("it");
            Globals.setCountry("IT");
        } else if (this.langEs.isSelected()) {
            Globals.setLanguage("es");
            Globals.setCountry("ES");
        } else if (this.langPt.isSelected()) {
            Globals.setLanguage("pt");
            Globals.setCountry("PT");
        } else if (this.langSystem.isSelected()) {
            Globals.setLanguage(null);
            Globals.setCountry(null);
        }
        SettingsHandler.getGame().selectUnitSet((String)this.unitSetType.getSelectedItem());
    }
}

