/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class SpinningTabbedPane
extends JTabbedPane {
    static final long serialVersionUID = 4980035692406423131L;
    private static final int PLACE_OFFSET = 0;
    private static final int MOVE_LEFT_RIGHT_OFFSET = 4;
    private static final int MOVE_UP_DOWN_OFFSET = 8;
    private static final int GROUP_OFFSET = 12;
    private static final int TAB_OFFSET = 16;
    private static final int UNGROUP_CHILD_OFFSET = 20;
    private static final int UNGROUP_SELF_OFFSET = 24;
    private static final int UNGROUP_SINGLE_OFFSET = 28;
    private static final String[] labels = new String[]{PropertyFactory.getString("in_top"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_beginning"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_end"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_top"), PropertyFactory.getString("in_up"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_down"), PropertyFactory.getString("in_up"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_down"), PropertyFactory.getString("in_right"), null, null, null, null, PropertyFactory.getString("in_ungroupTop"), PropertyFactory.getString("in_ungroupLeft"), PropertyFactory.getString("in_ungroupBottom"), PropertyFactory.getString("in_ungroupRight"), PropertyFactory.getString("in_ungroupTop"), PropertyFactory.getString("in_ungroupLeft"), PropertyFactory.getString("in_ungroupBottom"), PropertyFactory.getString("in_ungroupRight"), PropertyFactory.getString("in_ungroupUp"), PropertyFactory.getString("in_ungroupLeft"), PropertyFactory.getString("in_ungroupDown"), PropertyFactory.getString("in_ungroupRight")};
    private static final ImageIcon[] icons = new ImageIcon[]{Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.BEGINNING_ICON, Utilities.LEFT_ICON, Utilities.END_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.UP_ICON, Utilities.BOTTOM_ICON, Utilities.DOWN_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.BEGINNING_ICON, Utilities.BOTTOM_ICON, Utilities.END_ICON, Utilities.TOP_ICON, Utilities.BEGINNING_ICON, Utilities.BOTTOM_ICON, Utilities.END_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON};
    private static final String[] tips = new String[]{PropertyFactory.getString("in_spinTips1"), PropertyFactory.getString("in_spinTips2"), PropertyFactory.getString("in_spinTips3"), PropertyFactory.getString("in_spinTips4"), PropertyFactory.getString("in_spinTips5"), PropertyFactory.getString("in_spinTips6"), PropertyFactory.getString("in_spinTips7"), PropertyFactory.getString("in_spinTips8"), PropertyFactory.getString("in_spinTips9"), PropertyFactory.getString("in_spinTips10"), PropertyFactory.getString("in_spinTips11"), PropertyFactory.getString("in_spinTips12"), PropertyFactory.getString("in_spinTips13"), PropertyFactory.getString("in_spinTips14"), PropertyFactory.getString("in_spinTips15"), PropertyFactory.getString("in_spinTips16"), PropertyFactory.getString("in_spinTips17"), PropertyFactory.getString("in_spinTips18"), PropertyFactory.getString("in_spinTips19"), PropertyFactory.getString("in_spinTips20"), PropertyFactory.getString("in_spinTips21"), PropertyFactory.getString("in_spinTips22"), PropertyFactory.getString("in_spinTips23"), PropertyFactory.getString("in_spinTips24"), PropertyFactory.getString("in_spinTips25"), PropertyFactory.getString("in_spinTips26"), PropertyFactory.getString("in_spinTips27"), PropertyFactory.getString("in_spinTips28"), PropertyFactory.getString("in_spinTips29"), PropertyFactory.getString("in_spinTips30"), PropertyFactory.getString("in_spinTips31"), PropertyFactory.getString("in_spinTips32")};
    private PopupMenuPolicy policy = new DefaultPopupMenuPolicy();
    private Set<Component> locked = new HashSet<Component>();
    private SpinningTabbedPane parent = null;

    public SpinningTabbedPane() {
        this.addMouseListener(new PopupListener());
    }

    public final void setTabPlacement(int n) {
        super.setTabPlacement(n);
        if (this.parent != null) {
            this.parent.updateTabUIAt(this.parent.indexOfComponent(this));
        }
    }

    public final void setTitleAt(int n, String string) {
        String string2 = this.getExtraTitleAt(n);
        if (string2 != null) {
            string = string == null || string.length() == 0 ? string2 : string + " " + string2;
        }
        super.setTitleAt(n, string);
    }

    public final int indexAtLocation(int n, int n2) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).tabForCoordinate(this, n, n2);
        }
        return -1;
    }

    private static void setMenuItem(JMenuItem jMenuItem, int n) {
        String string = labels[n];
        jMenuItem.setText(string);
        if (string != null) {
            jMenuItem.setMnemonic(string.charAt(0));
        }
        jMenuItem.setIcon(icons[n]);
        jMenuItem.setToolTipText(tips[n]);
    }

    private static final SpinningTabbedPane createPane() {
        return new SpinningTabbedPane();
    }

    private static int offsetForPlacement(int n) {
        return n - 1;
    }

    private static int placementForSlot(int n, int n2) {
        return (n2 - 1 + n) % 4 + 1;
    }

    private final String getExtraTitleAt(int n) {
        Component component = this.getComponentAt(n);
        return component instanceof SpinningTabbedPane ? "(" + ((SpinningTabbedPane)component).getSpinTabCount() + ")" : null;
    }

    private final int getMovableTabCount() {
        int n = 0;
        int n2 = this.getTabCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            ++n;
        }
        return n;
    }

    private final int[] getMovableTabIndices() {
        int n = this.getTabCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private final String getPlainTitleAt(int n) {
        String string = this.getTitleAt(n);
        Component component = this.getComponentAt(n);
        if (string == null) {
            return "";
        }
        if (string.length() == 0 || !(component instanceof SpinningTabbedPane)) {
            return string;
        }
        String string2 = this.getExtraTitleAt(n);
        if (string.length() == string2.length()) {
            return "";
        }
        return string.substring(0, string.length() - string2.length() - 1);
    }

    private final int getSpinTabCount() {
        int n = this.getTabCount();
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            Component component = this.getComponentAt(i);
            if (!(component instanceof SpinningTabbedPane)) continue;
            --n;
            n += ((SpinningTabbedPane)component).getSpinTabCount();
        }
        return n;
    }

    private final int getSpinTabPlacementAt(int n) {
        Component component = this.getComponentAt(n);
        if (component instanceof SpinningTabbedPane) {
            return ((SpinningTabbedPane)component).getTabPlacement();
        }
        return -1;
    }

    private final boolean isTabLockedAt(int n) {
        return this.locked.contains(this.getComponentAt(n));
    }

    private final void addNewTab() {
        this.add(new JPanel());
    }

    private final void lockTabAt(int n) {
        this.locked.add(this.getComponentAt(n));
        this.setIconAt(n, Utilities.LOCK_ICON);
    }

    private final void spinTabsAt(int n, int n2) {
        Component component;
        SpinningTabbedPane spinningTabbedPane = SpinningTabbedPane.createPane();
        this.moveTabAtTo(n, -1, spinningTabbedPane);
        int n3 = this.getTabCount();
        for (int i = n; i < n3 && !((component = this.getComponentAt(n)) instanceof SpinningTabbedPane); ++i) {
            this.moveTabAtTo(n, -1, spinningTabbedPane);
        }
        this.add((Component)spinningTabbedPane, n);
        this.setTitleAt(n, "");
        spinningTabbedPane.parent = this;
        spinningTabbedPane.setTabPlacement(n2);
        this.updateTabUIAt(n);
    }

    private final void unlockTabAt(int n) {
        this.locked.remove(this.getComponentAt(n));
        this.setIconAt(n, null);
    }

    private final void unspinAll() {
        int n = this.parent.indexOfComponent(this);
        this.parent.removeTabAt(n);
        int n2 = this.getTabCount();
        while (--n2 >= 0) {
            this.moveTabAtTo(n2, n, this.parent);
        }
        this.parent = null;
    }

    private final void unspinTabAt(int n) {
        if (this.getTabCount() == 1) {
            this.unspinAll();
        } else {
            int n2 = this.parent.indexOfComponent(this);
            this.moveTabAtTo(n, n2, this.parent);
            this.parent.updateTabUIAt(n2 + 1);
        }
    }

    private void moveTabAtTo(int n, int n2, JTabbedPane jTabbedPane) {
        Component component = this.getComponentAt(n);
        if (component instanceof SpinningTabbedPane) {
            ((SpinningTabbedPane)component).parent = this;
        }
        Color color = this.getBackgroundAt(n);
        Icon icon = this.getDisabledIconAt(n);
        Color color2 = this.getForegroundAt(n);
        Icon icon2 = this.getIconAt(n);
        String string = this.getTitleAt(n);
        String string2 = this.getToolTipTextAt(n);
        this.removeTabAt(n);
        if (n2 == -1) {
            n2 = jTabbedPane.getTabCount();
        }
        jTabbedPane.add(component, n2);
        jTabbedPane.setBackgroundAt(n2, color);
        jTabbedPane.setDisabledIconAt(n2, icon);
        jTabbedPane.setForegroundAt(n2, color2);
        jTabbedPane.setIconAt(n2, icon2);
        jTabbedPane.setTitleAt(n2, string);
        jTabbedPane.setToolTipTextAt(n2, string2);
    }

    private void updateTabUIAt(int n) {
        SpinningTabbedPane spinningTabbedPane = (SpinningTabbedPane)this.getComponentAt(n);
        int n2 = SpinningTabbedPane.offsetForPlacement(spinningTabbedPane.getTabPlacement()) + 16;
        this.setTitleAt(n, this.getPlainTitleAt(n));
        this.setIconAt(n, icons[n2]);
        this.setToolTipTextAt(n, tips[n2]);
    }

    private class UnlockMenuItem
    extends JMenuItem {
        UnlockMenuItem(int n) {
            super(PropertyFactory.getString("in_unlock"));
            this.addActionListener(new UnlockActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_unlock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class UnlockActionListener
    implements ActionListener {
        private int index;

        UnlockActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane.this.unlockTabAt(this.index);
        }
    }

    private class UngroupSingleMenuItem
    extends JMenuItem {
        UngroupSingleMenuItem(int n) {
            int n2 = SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.parent.getTabPlacement()) + 28;
            this.addActionListener(new UngroupSingleActionListener(n));
            SpinningTabbedPane.setMenuItem(this, n2);
        }
    }

    private class UngroupSingleActionListener
    implements ActionListener {
        private int index;

        UngroupSingleActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane.this.unspinTabAt(this.index);
            SpinningTabbedPane.this.parent.setSelectedIndex(SpinningTabbedPane.this.parent.indexOfComponent(SpinningTabbedPane.this) - 1);
        }
    }

    private class UngroupSelfMenuItem
    extends JMenuItem {
        UngroupSelfMenuItem() {
            int n = SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.parent.getTabPlacement()) + 24;
            this.addActionListener(new UngroupSelfActionListener());
            SpinningTabbedPane.setMenuItem(this, n);
        }
    }

    private class UngroupSelfActionListener
    implements ActionListener {
        private UngroupSelfActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SpinningTabbedPane.this.parent.indexOfComponent(SpinningTabbedPane.this);
            int n2 = SpinningTabbedPane.this.getSelectedIndex();
            SpinningTabbedPane spinningTabbedPane = SpinningTabbedPane.this.parent;
            SpinningTabbedPane.this.unspinAll();
            spinningTabbedPane.setSelectedIndex(n + n2);
        }
    }

    private class UngroupChildMenuItem
    extends JMenuItem {
        UngroupChildMenuItem(int n) {
            int n2 = SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.getTabPlacement()) + 20;
            this.addActionListener(new UngroupChildActionListener(n));
            SpinningTabbedPane.setMenuItem(this, n2);
        }
    }

    private class UngroupChildActionListener
    implements ActionListener {
        private int index;

        UngroupChildActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane spinningTabbedPane = (SpinningTabbedPane)SpinningTabbedPane.this.getComponentAt(this.index);
            int n = spinningTabbedPane.getSelectedIndex();
            spinningTabbedPane.unspinAll();
            SpinningTabbedPane.this.setSelectedIndex(this.index + n);
        }
    }

    private class RenameMenuItem
    extends JMenuItem {
        RenameMenuItem(int n, MouseEvent mouseEvent) {
            super(PropertyFactory.getString("in_rename") + "...");
            this.addActionListener(new RenameActionListener(n, mouseEvent));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_rename"));
        }
    }

    private class RenameActionListener
    implements ActionListener {
        private MouseEvent mouseEvent;
        private int index;

        RenameActionListener(int n, MouseEvent mouseEvent) {
            this.index = n;
            this.mouseEvent = mouseEvent;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.mouseEvent.getX();
            int n2 = this.mouseEvent.getY();
            JPopupMenu jPopupMenu = new JPopupMenu();
            String string = SpinningTabbedPane.this.getPlainTitleAt(this.index);
            JTextField jTextField = new JTextField(string);
            Logging.errorPrint("document? " + jTextField.getDocument());
            jTextField.addActionListener(new RenameTextFieldActionListener(this.index, jTextField, jPopupMenu));
            jPopupMenu.add(jTextField);
            Component component = this.mouseEvent.getComponent();
            jPopupMenu.show(component, n, n2);
            jTextField.selectAll();
            jTextField.setCaretPosition(string.length());
            Component component2 = SpinningTabbedPane.this.getComponentAt(this.index);
            Point point = component2.getLocationOnScreen();
            Point point2 = jPopupMenu.getLocationOnScreen();
            Dimension dimension = component2.getSize();
            Dimension dimension2 = jPopupMenu.getSize();
            boolean bl = false;
            if (point2.x + dimension2.width >= point.x + dimension.width) {
                bl = true;
                n = point.x + dimension.width - dimension2.width - 1;
            }
            if (point2.y + dimension2.height >= point.y + dimension.height) {
                bl = true;
                n2 = point.y + dimension.height - dimension2.height - 1;
            }
            if (bl) {
                jPopupMenu.show(component, n, n2);
            }
        }

        private class RenameTextFieldActionListener
        implements ActionListener {
            private JPopupMenu popupMenu;
            private JTextField textField;
            private int anIndex;

            RenameTextFieldActionListener(int n, JTextField jTextField, JPopupMenu jPopupMenu) {
                this.anIndex = n;
                this.textField = jTextField;
                this.popupMenu = jPopupMenu;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                SpinningTabbedPane.this.setTitleAt(this.anIndex, this.textField.getText());
                this.popupMenu.setVisible(false);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Utilities.isRightMouseButton(mouseEvent)) {
                boolean bl;
                int n;
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                int n4 = SpinningTabbedPane.this.indexAtLocation(n2, n3);
                int n5 = SpinningTabbedPane.this.getTabPlacement();
                JPopupMenu jPopupMenu = new JPopupMenu();
                NewMenuItem newMenuItem = null;
                CloseMenuItem closeMenuItem = null;
                JMenuItem jMenuItem = null;
                RenameMenuItem renameMenuItem = null;
                JMenu jMenu = null;
                JMenu jMenu2 = null;
                PlaceMenu placeMenu = null;
                if (SpinningTabbedPane.this.policy.canNew(n4)) {
                    newMenuItem = new NewMenuItem(n4);
                }
                if (n4 >= 0) {
                    n = SpinningTabbedPane.this.getSpinTabPlacementAt(n4);
                    if (SpinningTabbedPane.this.policy.canClose(n4) && !SpinningTabbedPane.this.isTabLockedAt(n4)) {
                        closeMenuItem = new CloseMenuItem(n4);
                    }
                    if (SpinningTabbedPane.this.policy.canLock(n4)) {
                        JMenuItem jMenuItem2 = jMenuItem = SpinningTabbedPane.this.isTabLockedAt(n4) ? new UnlockMenuItem(n4) : new LockMenuItem(n4);
                    }
                    if (SpinningTabbedPane.this.policy.canRename(n4)) {
                        renameMenuItem = new RenameMenuItem(n4, mouseEvent);
                    }
                    if (SpinningTabbedPane.this.policy.hasGroupMenu(n4, mouseEvent) && !SpinningTabbedPane.this.isTabLockedAt(n4)) {
                        jMenu = new GroupMenu(n4, n == -1 ? n5 : n);
                    }
                    if (SpinningTabbedPane.this.policy.hasMoveMenu(n4, mouseEvent) && SpinningTabbedPane.this.getMovableTabCount() > 1 && !SpinningTabbedPane.this.isTabLockedAt(n4)) {
                        jMenu2 = new MoveMenu(n4);
                    }
                }
                if (SpinningTabbedPane.this.policy.hasPlaceMenu(n4, mouseEvent)) {
                    placeMenu = new PlaceMenu(n5);
                }
                n = newMenuItem != null ? 1 : 0;
                boolean bl2 = closeMenuItem != null;
                boolean bl3 = jMenuItem != null;
                boolean bl4 = renameMenuItem != null;
                boolean bl5 = jMenu != null && jMenu.getMenuComponentCount() > 0;
                boolean bl6 = jMenu2 != null && jMenu2.getMenuComponentCount() > 0;
                boolean bl7 = bl = placeMenu != null && placeMenu.getMenuComponentCount() > 0;
                if (jPopupMenu.getComponentCount() > 0 && (n != 0 || bl2)) {
                    jPopupMenu.addSeparator();
                }
                if (n != 0) {
                    jPopupMenu.add(newMenuItem);
                }
                if (bl2) {
                    jPopupMenu.add(closeMenuItem);
                }
                if (jPopupMenu.getComponentCount() > 0 && (bl3 || bl4)) {
                    jPopupMenu.addSeparator();
                }
                if (bl3) {
                    jPopupMenu.add(jMenuItem);
                }
                if (bl4) {
                    jPopupMenu.add(renameMenuItem);
                }
                if (jPopupMenu.getComponentCount() > 0 && (bl5 || bl6 || bl)) {
                    jPopupMenu.addSeparator();
                }
                if (bl5) {
                    jPopupMenu.add(jMenu);
                }
                if (bl6) {
                    jPopupMenu.add(jMenu2);
                }
                if (bl) {
                    jPopupMenu.add(placeMenu);
                }
                jPopupMenu.show(mouseEvent.getComponent(), n2, n3);
            } else if (Utilities.isShiftLeftMouseButton(mouseEvent)) {
                int n = SpinningTabbedPane.this.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                SpinningTabbedPane.this.spinTabsAt(n, SpinningTabbedPane.placementForSlot(3, SpinningTabbedPane.this.getTabPlacement()));
                SpinningTabbedPane.this.setSelectedIndex(n);
            }
        }
    }

    private class PlaceMenuItem
    extends JMenuItem {
        PlaceMenuItem(SpinningTabbedPane spinningTabbedPane2, int n) {
            int n2 = SpinningTabbedPane.offsetForPlacement(n) + 0;
            this.addActionListener(new PlaceActionListener(spinningTabbedPane2, n));
            SpinningTabbedPane.setMenuItem(this, n2);
        }
    }

    private class PlaceMenu
    extends JMenu {
        PlaceMenu(int n) {
            super(PropertyFactory.getString("in_placeTabs"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_placeTabs"));
            for (int i = 3; i > 0; --i) {
                this.add(new PlaceMenuItem(SpinningTabbedPane.this, SpinningTabbedPane.placementForSlot(i, n)));
            }
        }
    }

    private class PlaceActionListener
    implements ActionListener {
        private SpinningTabbedPane pane;
        private int placement;

        PlaceActionListener(SpinningTabbedPane spinningTabbedPane2, int n) {
            this.pane = spinningTabbedPane2;
            this.placement = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pane.setTabPlacement(this.placement);
        }
    }

    private class NewMenuItem
    extends JMenuItem {
        NewMenuItem(int n) {
            super(PropertyFactory.getString("in_new"));
            this.addActionListener(new NewActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_new"));
            this.setIcon(Utilities.NEW_ICON);
        }
    }

    private class NewActionListener
    implements ActionListener {
        int index;

        NewActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane.this.addNewTab();
        }
    }

    private class MoveTabMenuItem
    extends JMenuItem {
        MoveTabMenuItem(int n, int n2) {
            int n3 = SpinningTabbedPane.offsetForPlacement(n2);
            switch (SpinningTabbedPane.this.getTabPlacement()) {
                case 1: 
                case 3: {
                    n3 += 4;
                    break;
                }
                case 2: 
                case 4: {
                    n3 += 8;
                }
            }
            this.addActionListener(new MoveActionListener(n, n2));
            SpinningTabbedPane.setMenuItem(this, n3);
        }
    }

    private class MoveMenu
    extends JMenu {
        MoveMenu(int n) {
            super(PropertyFactory.getString("in_moveTab"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_movetab"));
            int[] nArray = SpinningTabbedPane.this.getMovableTabIndices();
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            switch (nArray.length) {
                case 0: {
                    this.setEnabled(false);
                    break;
                }
                case 1: {
                    this.setEnabled(false);
                    break;
                }
                case 2: {
                    n2 = nArray[0];
                    n3 = Integer.MAX_VALUE;
                    n4 = Integer.MIN_VALUE;
                    n5 = nArray[1];
                    break;
                }
                case 3: {
                    n2 = nArray[0];
                    n3 = n4 = nArray[1];
                    n5 = nArray[2];
                }
                default: {
                    n2 = nArray[0];
                    n3 = nArray[1];
                    n4 = nArray[nArray.length - 2];
                    n5 = nArray[nArray.length - 1];
                }
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (n < nArray[i]) continue;
                if (n > n2) {
                    if (n > n3) {
                        this.add(new MoveTabMenuItem(n, 1));
                    }
                    this.add(new MoveTabMenuItem(n, 2));
                }
                if (n >= n5) break;
                this.add(new MoveTabMenuItem(n, 4));
                if (n >= n4) break;
                this.add(new MoveTabMenuItem(n, 3));
                break;
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        int index;
        int placement;

        MoveActionListener(int n, int n2) {
            this.index = n;
            this.placement = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = SpinningTabbedPane.this.getMovableTabIndices();
            int n = -1;
            switch (this.placement) {
                case 1: {
                    n = nArray[0];
                    break;
                }
                case 2: {
                    n = this.previous(this.index, nArray);
                    break;
                }
                case 3: {
                    n = nArray[nArray.length - 1];
                    break;
                }
                case 4: {
                    n = this.next(this.index, nArray);
                }
            }
            SpinningTabbedPane.this.moveTabAtTo(this.index, n, SpinningTabbedPane.this);
            SpinningTabbedPane.this.setSelectedIndex(n);
        }

        private int next(int n, int[] nArray) {
            int n2 = nArray.length - 1;
            for (int i = 0; i < n2; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i + 1];
            }
            return -1;
        }

        private int previous(int n, int[] nArray) {
            for (int i = 1; i < nArray.length; ++i) {
                if (n != nArray[i]) continue;
                return nArray[i - 1];
            }
            return -1;
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem(int n) {
            super(PropertyFactory.getString("in_lock"));
            this.addActionListener(new LockActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class LockActionListener
    implements ActionListener {
        private int index;

        LockActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane.this.lockTabAt(this.index);
        }
    }

    private class GroupMenuItem
    extends JMenuItem {
        GroupMenuItem(int n, int n2) {
            int n3 = SpinningTabbedPane.offsetForPlacement(n2) + 12;
            this.addActionListener(new GroupActionListener(n, n2));
            SpinningTabbedPane.setMenuItem(this, n3);
        }
    }

    private class GroupMenu
    extends JMenu {
        GroupMenu(int n, int n2) {
            int n3;
            super(PropertyFactory.getString("in_groupTabs"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_groupTabs"));
            Component component = SpinningTabbedPane.this.getComponentAt(n);
            boolean bl = true;
            if (SpinningTabbedPane.this.parent == null) {
                if (component instanceof SpinningTabbedPane) {
                    this.add(new UngroupChildMenuItem(n));
                    this.addSeparator();
                    for (n3 = 3; n3 > 0; --n3) {
                        this.add(new PlaceMenuItem((SpinningTabbedPane)component, SpinningTabbedPane.placementForSlot(n3, n2)));
                    }
                    bl = false;
                }
            } else {
                this.add(new UngroupSelfMenuItem());
                if (component instanceof SpinningTabbedPane) {
                    this.add(new UngroupChildMenuItem(n));
                } else {
                    this.add(new UngroupSingleMenuItem(n));
                }
                bl = false;
            }
            if (SpinningTabbedPane.this.policy.canGroup(n)) {
                if (!bl) {
                    this.addSeparator();
                }
                for (n3 = 4; n3 > 0; --n3) {
                    this.add(new GroupMenuItem(n, SpinningTabbedPane.placementForSlot(n3, n2)));
                }
            }
        }
    }

    private class GroupActionListener
    implements ActionListener {
        private int index;
        private int placement;

        GroupActionListener(int n, int n2) {
            this.index = n;
            this.placement = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane.this.spinTabsAt(this.index, this.placement);
            SpinningTabbedPane.this.setSelectedIndex(this.index);
        }
    }

    private class CloseMenuItem
    extends JMenuItem {
        CloseMenuItem(int n) {
            super(PropertyFactory.getString("in_close"));
            this.addActionListener(new CloseActionListener(n));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
            this.setIcon(Utilities.CLOSE_ICON);
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private int index;

        CloseActionListener(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SpinningTabbedPane.this.removeTabAt(this.index);
        }
    }

    private final class DefaultPopupMenuPolicy
    implements PopupMenuPolicy {
        private DefaultPopupMenuPolicy() {
        }

        public boolean canClose(int n) {
            return true;
        }

        public boolean canGroup(int n) {
            return true;
        }

        public boolean canLock(int n) {
            return true;
        }

        public boolean canMove(int n) {
            return true;
        }

        public boolean canNew(int n) {
            return true;
        }

        public boolean canRename(int n) {
            return true;
        }

        public boolean hasGroupMenu(int n, MouseEvent mouseEvent) {
            return true;
        }

        public boolean hasMoveMenu(int n, MouseEvent mouseEvent) {
            return true;
        }

        public boolean hasPlaceMenu(int n, MouseEvent mouseEvent) {
            return true;
        }
    }

    public static interface PopupMenuPolicy {
        public boolean canClose(int var1);

        public boolean canGroup(int var1);

        public boolean canLock(int var1);

        public boolean canMove(int var1);

        public boolean canNew(int var1);

        public boolean canRename(int var1);

        public boolean hasGroupMenu(int var1, MouseEvent var2);

        public boolean hasMoveMenu(int var1, MouseEvent var2);

        public boolean hasPlaceMenu(int var1, MouseEvent var2);
    }
}

