/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.spell.Spell;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.PropertyFactory;

public class SpellBasePanel2
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = -4883465552783045888L;
    private JButton btnAddVariant;
    private JButton btnRemoveVariant;
    private JList lstVariants;
    private JPanel pnlVariants;
    private JScrollPane scpVariants;
    private JTextField txtVariant;
    private TypePanel pnlType;

    public SpellBasePanel2() {
        this.initComponents();
    }

    public void updateData(PObject pObject) {
        Spell spell = (Spell)pObject;
        Object[] objectArray = this.pnlType.getSelectedList();
        spell.removeListFor(ListKey.TYPE);
        for (Object object : objectArray) {
            spell.addToListFor(ListKey.TYPE, Type.getConstant(object.toString()));
        }
        objectArray = ((JListModel)this.lstVariants.getModel()).getElements();
        spell.removeListFor(ListKey.VARIANTS);
        for (int i = 0; i < objectArray.length; ++i) {
            spell.addToListFor(ListKey.VARIANTS, objectArray[i].toString());
        }
    }

    public void updateView(PObject pObject) {
        List<String> list = pObject.getListFor(ListKey.VARIANTS);
        if (list != null) {
            ((JListModel)this.lstVariants.getModel()).setData(list);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        for (Object object : Globals.getSpellMap().values()) {
            if (object instanceof List) {
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    EditUtil.addPObjectTypes((Spell)((List)object).get(i), arrayList);
                }
                continue;
            }
            EditUtil.addPObjectTypes((Spell)object, arrayList);
        }
        for (Type type : pObject.getTrueTypeList(false)) {
            if (type.equals(Type.CUSTOM)) continue;
            arrayList2.add(type);
            arrayList.remove(type);
        }
        this.pnlType.setAvailableList(arrayList, true);
        this.pnlType.setSelectedList(arrayList2, true);
    }

    private void btnAddVariantActionPerformed() {
        this.btnAddVariant.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstVariants.getModel();
        jListModel.addElement(this.txtVariant.getText());
        this.txtVariant.setText("");
    }

    private void btnRemoveVariantActionPerformed() {
        this.btnRemoveVariant.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstVariants.getModel();
        Object[] objectArray = this.lstVariants.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            this.txtVariant.setText(objectArray[i].toString());
            jListModel.removeElement(objectArray[i]);
        }
        this.txtVariantKeyReleased();
    }

    private void initComponents() {
        this.pnlType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.pnlVariants = new JPanel();
        this.scpVariants = new JScrollPane();
        this.lstVariants = new JList(new JListModel(new ArrayList(), true));
        this.txtVariant = new JTextField();
        try {
            this.btnAddVariant = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemoveVariant = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exception) {
            this.btnAddVariant = new JButton(">");
            this.btnRemoveVariant = new JButton("<");
        }
        this.btnRemoveVariant.setEnabled(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.pnlType, gridBagConstraints);
        this.pnlVariants.setLayout(new GridBagLayout());
        this.lstVariants.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SpellBasePanel2.this.lstVariantsMouseClicked(mouseEvent);
            }
        });
        this.lstVariants.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SpellBasePanel2.this.lstVariants.getSelectedIndex() >= 0) {
                    SpellBasePanel2.this.lstVariants.ensureIndexIsVisible(SpellBasePanel2.this.lstVariants.getSelectedIndex());
                }
            }
        });
        this.pnlVariants.setBorder(new TitledBorder(PropertyFactory.getString("in_demVariants")));
        this.scpVariants.setViewportView(this.lstVariants);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlVariants.add((Component)this.scpVariants, gridBagConstraints);
        this.btnAddVariant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellBasePanel2.this.btnAddVariantActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlVariants.add((Component)this.btnAddVariant, gridBagConstraints);
        this.btnRemoveVariant.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpellBasePanel2.this.btnRemoveVariantActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.pnlVariants.add((Component)this.btnRemoveVariant, gridBagConstraints);
        this.txtVariant.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                SpellBasePanel2.this.txtVariantKeyReleased();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        this.pnlVariants.add((Component)this.txtVariant, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.pnlVariants, gridBagConstraints);
    }

    private void lstVariantsMouseClicked(MouseEvent mouseEvent) {
        if (EditUtil.isDoubleClick(mouseEvent, this.lstVariants, this.btnRemoveVariant)) {
            this.btnRemoveVariantActionPerformed();
        }
    }

    private void txtVariantKeyReleased() {
        this.btnAddVariant.setEnabled(this.txtVariant.getText().trim().length() != 0);
    }
}

