/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.EditUtil;
import pcgen.gui.editor.JListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;

final class MovementPanel
extends JPanel {
    static final long serialVersionUID = 3024201499870849149L;
    private static final String[] rateTypes = new String[]{"MOVE (Set movement rate)", "<unused>", "MOVECLONE (Adjust based on default rate)"};
    private JButton btnAdd;
    private JButton btnRemove;
    private JComboBoxEx cmbMoveType;
    private JComboBoxEx cmbRateType;
    private JLabel lblHeader;
    private JLabel lblSelected;
    private JList lstSelected;
    private JPanel pnlAddRemove;
    private JPanel pnlAvailable;
    private JPanel pnlHeader;
    private JPanel pnlSelected;
    private JScrollPane scpSelected;
    private JTextField txtMoveAmount;
    private JRadioButton[] rdbAdjustType;

    MovementPanel(boolean bl) {
        this.initComponents(bl);
        this.initComponentContents(bl);
    }

    void setMoveRateType(int n) {
        this.cmbRateType.setSelectedIndex(n);
    }

    int getMoveRateType() {
        return this.cmbRateType.getSelectedIndex();
    }

    String[] getMoveTypes() {
        Object[] objectArray = this.getSelectedList();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            int n = string.indexOf(",");
            stringArray[i] = string.substring(0, n);
        }
        return stringArray;
    }

    String getMoveValues() {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.getSelectedList();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    void setSelectedList(List list) {
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            jListModel.addElement(list.get(i));
        }
    }

    Object[] getSelectedList() {
        return ((JListModel)this.lstSelected.getModel()).getElements();
    }

    static String makeMoveString(String string, Double d, Double d2, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(',');
        if ("*".equals(string2) || "/".equals(string2)) {
            stringBuffer.append(string2);
            stringBuffer.append(d2);
        } else {
            stringBuffer.append(d.intValue());
        }
        return stringBuffer.toString();
    }

    private void btnAddActionPerformed() {
        String string = (String)this.cmbMoveType.getSelectedItem();
        if (string == null || string.length() == 0 || !this.rdbAdjustType[0].isSelected() && !this.rdbAdjustType[1].isSelected() && !this.rdbAdjustType[2].isSelected() || this.txtMoveAmount.getText().trim().length() == 0) {
            ShowMessageDelegate.showMessageDialog("You must enter a movement type, adjustment and amount.", "PCGen", MessageType.ERROR);
            return;
        }
        String string2 = (String)this.cmbMoveType.getSelectedItem() + ",";
        if (this.rdbAdjustType[1].isSelected()) {
            string2 = string2 + "*";
        } else if (this.rdbAdjustType[2].isSelected()) {
            string2 = string2 + "/";
        }
        string2 = string2 + this.txtMoveAmount.getText().trim();
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        jListModel.addElement(string2);
    }

    private void btnRemoveActionPerformed() {
        this.btnRemove.setEnabled(false);
        JListModel jListModel = (JListModel)this.lstSelected.getModel();
        Object[] objectArray = this.lstSelected.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = MovementPanel.splitMoveString((String)objectArray[i]);
            if (stringArray != null) {
                this.cmbMoveType.setSelectedItem(stringArray[0]);
                if (stringArray[1].equals("*")) {
                    this.rdbAdjustType[1].setSelected(true);
                } else if (stringArray[1].equals("/")) {
                    this.rdbAdjustType[2].setSelected(true);
                } else {
                    this.rdbAdjustType[0].setSelected(true);
                }
                this.txtMoveAmount.setText(stringArray[2]);
            }
            jListModel.removeElement(objectArray[i]);
        }
    }

    private void initComponentContents(boolean bl) {
        if (bl) {
            this.cmbRateType.setModel(new DefaultComboBoxModel<String>(new String[]{rateTypes[0]}));
            this.cmbRateType.setSelectedIndex(0);
        } else {
            this.cmbRateType.setModel(new DefaultComboBoxModel<String>(rateTypes));
        }
    }

    private void initComponents(boolean bl) {
        GridBagConstraints gridBagConstraints;
        this.cmbRateType = new JComboBoxEx();
        this.cmbMoveType = new JComboBoxEx(new String[]{"Walk", "Fly", "Swim", "ALL"});
        this.cmbMoveType.setEditable(true);
        this.rdbAdjustType = new JRadioButton[]{new JRadioButton("Add/Set to"), new JRadioButton("Multiply by"), new JRadioButton("Divide by")};
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rdbAdjustType[0]);
        buttonGroup.add(this.rdbAdjustType[1]);
        buttonGroup.add(this.rdbAdjustType[2]);
        this.txtMoveAmount = new JTextField();
        try {
            this.btnAdd = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
            this.btnRemove = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        }
        catch (Exception exception) {
            this.btnAdd = new JButton(">");
            this.btnRemove = new JButton("<");
        }
        this.lblHeader = new JLabel();
        this.lblSelected = new JLabel();
        this.lstSelected = new JList(new JListModel(new ArrayList(), true));
        this.pnlHeader = new JPanel();
        this.pnlAvailable = new JPanel();
        this.pnlAddRemove = new JPanel();
        this.pnlSelected = new JPanel();
        this.scpSelected = new JScrollPane();
        this.pnlHeader.setLayout(new GridBagLayout());
        if (!bl) {
            this.lblHeader = new JLabel("Movement Rate Type of ");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            this.pnlHeader.add((Component)this.lblHeader, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlHeader.add((Component)this.cmbRateType, gridBagConstraints);
        }
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, PropertyFactory.getString("in_demTag"));
        titledBorder.setTitleJustification(1);
        this.pnlAvailable.setBorder(titledBorder);
        this.pnlAvailable.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Movement Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.cmbMoveType, gridBagConstraints);
        if (bl) {
            this.rdbAdjustType[0].setSelected(true);
        } else {
            jLabel = new JLabel("Adjustment:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.1;
            this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlAvailable.add((Component)this.rdbAdjustType[0], gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlAvailable.add((Component)this.rdbAdjustType[1], gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weightx = 0.4;
            this.pnlAvailable.add((Component)this.rdbAdjustType[2], gridBagConstraints);
        }
        jLabel = new JLabel("Amount:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAvailable.add((Component)this.txtMoveAmount, gridBagConstraints);
        this.pnlAvailable.add((Component)jLabel, gridBagConstraints);
        this.pnlAddRemove.setLayout(new GridBagLayout());
        this.btnAdd.setEnabled(true);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MovementPanel.this.btnAddActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MovementPanel.this.btnRemoveActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlAddRemove.add((Component)this.btnRemove, gridBagConstraints);
        this.pnlSelected.setLayout(new GridBagLayout());
        this.lblSelected.setText(PropertyFactory.getString("in_selected"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        this.pnlSelected.add((Component)this.lblSelected, gridBagConstraints);
        this.lstSelected.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                MovementPanel.this.lstSelectedMouseClicked(mouseEvent);
            }
        });
        this.lstSelected.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (MovementPanel.this.lstSelected.getSelectedIndex() >= 0) {
                    MovementPanel.this.lstSelected.ensureIndexIsVisible(MovementPanel.this.lstSelected.getSelectedIndex());
                }
            }
        });
        this.scpSelected.setPreferredSize(new Dimension(90, 20));
        this.scpSelected.setViewportView(this.lstSelected);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.pnlSelected.add((Component)this.scpSelected, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.pnlHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAvailable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlAddRemove, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 1, 2, 1);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlSelected, gridBagConstraints);
    }

    private void lstSelectedMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.lstSelected) && EditUtil.isDoubleClick(mouseEvent, this.lstSelected, this.btnRemove)) {
            this.btnRemoveActionPerformed();
        }
    }

    private static String[] splitMoveString(String string) {
        String[] stringArray = null;
        int n = string.indexOf(",");
        if (n >= 0) {
            stringArray = new String[3];
            stringArray[0] = string.substring(0, n);
            if (string.charAt(n + 1) == '*' || string.charAt(n + 1) == '/') {
                stringArray[1] = string.substring(n + 1, n + 2);
                stringArray[2] = string.substring(n + 2);
            } else {
                stringArray[1] = "";
                stringArray[2] = string.substring(n + 1);
            }
        }
        return stringArray;
    }
}

