/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.Categorisable;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.WholeNumberField;
import pcgen.rules.context.LoadContext;
import pcgen.util.DecimalNumberField;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatBasePanel
extends BasePanel {
    private DecimalNumberField txtCost;
    private DescriptionPanel pnlDescription;
    private JCheckBox chkMultiple;
    private JCheckBox chkStack;
    private JComboBoxEx cmbVisible;
    private JLabel lblCost;
    private JLabel lblSpellLevels;
    private JLabel lblVisible;
    private JPanel pnlMisc;
    private TypePanel pnlFeatType;
    private WholeNumberField txtSpellLevels;

    public FeatBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setCost(double d) {
        this.txtCost.setValue(d);
    }

    public double getCost() {
        return this.txtCost.getValue();
    }

    public void setDescIsPI(boolean bl) {
        this.pnlDescription.setDescIsPI(bl);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String string) {
        this.pnlDescription.setText(string);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void setMultiples(boolean bl) {
        this.chkMultiple.setSelected(bl);
    }

    public boolean getMultiples() {
        return this.chkMultiple.isSelected();
    }

    public void setSpellLevels(int n) {
        this.txtSpellLevels.setValue(n);
    }

    public int getSpellLevels() {
        return this.txtSpellLevels.getValue();
    }

    public void setStacks(boolean bl) {
        this.chkStack.setSelected(bl);
    }

    public boolean getStacks() {
        return this.chkStack.isSelected();
    }

    public void setTypesAvailableList(List<Type> list, boolean bl) {
        this.pnlFeatType.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<Type> list, boolean bl) {
        this.pnlFeatType.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlFeatType.getSelectedList();
    }

    public void setVisible(Visibility visibility) {
        this.cmbVisible.setSelectedIndex(visibility.ordinal());
    }

    public Visibility getVisible() {
        return Visibility.values()[this.cmbVisible.getSelectedIndex()];
    }

    @Override
    public void updateData(PObject pObject) {
        Ability ability = (Ability)pObject;
        LoadContext loadContext = Globals.getContext();
        String string = this.getDescriptionText();
        StringTokenizer stringTokenizer = new StringTokenizer(".CLEAR\t" + string, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            loadContext.unconditionallyProcess(pObject, "DESC", stringTokenizer.nextToken());
        }
        ability.put(ObjectKey.DESC_PI, this.getDescIsPI());
        ability.put(ObjectKey.MULTIPLE_ALLOWED, this.getMultiples() ? Boolean.TRUE : Boolean.FALSE);
        ability.put(ObjectKey.STACKS, this.getStacks() ? Boolean.TRUE : Boolean.FALSE);
        ability.put(ObjectKey.VISIBILITY, this.getVisible());
        ability.put(ObjectKey.SELECTION_COST, new BigDecimal(this.getCost()));
        ability.put(IntegerKey.ADD_SPELL_LEVEL, this.getSpellLevels());
        ability.removeListFor(ListKey.TYPE);
        for (Object object : this.getTypesSelectedList()) {
            ability.addToListFor(ListKey.TYPE, Type.getConstant(object.toString()));
        }
    }

    @Override
    public void updateView(PObject pObject) {
        Ability ability = (Ability)pObject;
        StringBuffer stringBuffer = new StringBuffer();
        for (Description cloneable2 : pObject.getSafeListFor(ListKey.DESCRIPTION)) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(cloneable2.getPCCText());
        }
        this.setDescriptionText(stringBuffer.toString());
        this.setDescIsPI(pObject.getSafe(ObjectKey.DESC_PI));
        ArrayList arrayList = new ArrayList();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        Iterator<Categorisable> iterator = Globals.getAbilityKeyIterator("FEAT");
        while (iterator.hasNext()) {
            Ability ability2 = (Ability)iterator.next();
            for (Type type : ability2.getTrueTypeList(false)) {
                if (type.equals(Type.CUSTOM) || arrayList.contains(type)) continue;
                arrayList.add(type);
            }
        }
        for (Type type : ability.getTrueTypeList(false)) {
            if (type.equals(Type.CUSTOM)) continue;
            arrayList2.add(type);
            arrayList.remove(type);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.setVisible(ability.getSafe(ObjectKey.VISIBILITY));
        this.setMultiples(ability.getSafe(ObjectKey.MULTIPLE_ALLOWED));
        this.setStacks(ability.getSafe(ObjectKey.STACKS));
        this.setCost(ability.getSafe(ObjectKey.SELECTION_COST).doubleValue());
        this.setSpellLevels(ability.getSafe(IntegerKey.ADD_SPELL_LEVEL));
    }

    private void initComponentContents() {
        Vector<String> vector = new Vector<String>();
        for (Visibility visibility : Visibility.values()) {
            vector.add(visibility.toString());
        }
        this.cmbVisible.setModel(new DefaultComboBoxModel(vector));
    }

    private void initComponents() {
        this.pnlDescription = new DescriptionPanel();
        this.pnlFeatType = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.pnlMisc = new JPanel();
        this.lblCost = new JLabel();
        this.lblVisible = new JLabel();
        this.cmbVisible = new JComboBoxEx();
        this.chkMultiple = new JCheckBox();
        this.chkStack = new JCheckBox();
        this.txtCost = new DecimalNumberField(0.0, 5);
        this.lblSpellLevels = new JLabel();
        this.txtSpellLevels = new WholeNumberField(0, 3);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.pnlDescription, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFeatType, gridBagConstraints);
        this.pnlMisc.setLayout(new GridBagLayout());
        this.lblCost.setText("Cost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        this.pnlMisc.add((Component)this.lblCost, gridBagConstraints);
        this.lblVisible.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.1;
        this.pnlMisc.add((Component)this.lblVisible, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.cmbVisible, gridBagConstraints);
        this.chkMultiple.setText("Multiples allowed");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.chkMultiple, gridBagConstraints);
        this.chkStack.setText("Stacks");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.chkStack, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlMisc.add((Component)this.txtCost, gridBagConstraints);
        this.lblSpellLevels.setText("Spell Levels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 13;
        this.pnlMisc.add((Component)this.lblSpellLevels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlMisc.add((Component)this.txtSpellLevels, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlMisc, gridBagConstraints);
    }
}

