/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.converter.ConversionDecider;
import pcgen.gui.converter.LSTConverter;
import pcgen.gui.converter.ObjectInjector;
import pcgen.gui.converter.event.TaskStrategyMessage;
import pcgen.gui.converter.panel.ConversionChoiceDialog;
import pcgen.gui.converter.panel.ConvertSubPanel;
import pcgen.gui.utils.Utility;
import pcgen.io.PCGFile;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.EditorLoadContext;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunConvertPanel
extends ConvertSubPanel
implements Observer,
ConversionDecider {
    int totalFileCount = 0;
    int currentFileCount = 0;
    private JProgressBar progressBar;
    private ArrayList<Campaign> totalCampaigns;
    private final EditorLoadContext context = new EditorLoadContext();
    private JTextArea messageArea;
    private JScrollPane messageAreaContainer;
    private boolean errorState = false;
    private String lastNotifiedFilename = "";
    private String currFilename = "";
    private Component statusField;
    private LoadHandler handler = null;

    public RunConvertPanel(Component component) {
        this.statusField = component;
    }

    @Override
    public boolean autoAdvance(CDOMObject cDOMObject) {
        return false;
    }

    @Override
    public boolean performAnalysis(final CDOMObject cDOMObject) {
        final File file = cDOMObject.get(ObjectKey.DIRECTORY);
        final File file2 = cDOMObject.get(ObjectKey.WRITE_DIRECTORY);
        this.totalCampaigns = new ArrayList<Campaign>(cDOMObject.getSafeListFor(ListKey.CAMPAIGN));
        for (Campaign campaign : cDOMObject.getSafeListFor(ListKey.CAMPAIGN)) {
            for (CampaignSourceEntry campaignSourceEntry : campaign.getSafeListFor(ListKey.FILE_PCC)) {
                URI uRI = campaignSourceEntry.getURI();
                if (!PCGFile.isPCGenCampaignFile(uRI)) continue;
                Campaign campaign2 = Globals.getCampaignByURI(uRI, false);
                this.totalCampaigns.add(campaign2);
            }
        }
        new Thread(new Runnable(){

            public void run() {
                Logging.registerHandler(RunConvertPanel.this.getHandler());
                LSTConverter lSTConverter = new LSTConverter(RunConvertPanel.this.context, file, file2.getAbsolutePath(), RunConvertPanel.this);
                lSTConverter.addObserver(RunConvertPanel.this);
                SettingsHandler.setGame(cDOMObject.get(ObjectKey.GAME_MODE).getName());
                try {
                    lSTConverter.doStartup();
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    persistenceLayerException.printStackTrace();
                }
                int n = 0;
                for (Campaign campaign : RunConvertPanel.this.totalCampaigns) {
                    n += lSTConverter.getNumFilesInCampaign(campaign);
                }
                RunConvertPanel.this.setTotalFileCount(n);
                for (Campaign campaign : RunConvertPanel.this.totalCampaigns) {
                    lSTConverter.processCampaign(campaign);
                }
                ObjectInjector objectInjector = new ObjectInjector(RunConvertPanel.this.context, file2, file, lSTConverter);
                try {
                    objectInjector.writeInjectedObjects(RunConvertPanel.this.totalCampaigns);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                lSTConverter.deleteObserver(RunConvertPanel.this);
                Logging.removeHandler(RunConvertPanel.this.getHandler());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                RunConvertPanel.this.setCurrentFilename("");
                RunConvertPanel.this.addMessage("\nConversion complete, press next button to finish...");
                RunConvertPanel.this.progressBar.setValue(RunConvertPanel.this.progressBar.getMaximum());
                RunConvertPanel.this.fireProgressEvent(0);
            }
        }).start();
        return true;
    }

    @Override
    public void setupDisplay(JPanel jPanel, CDOMObject cDOMObject) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Conversion in progress");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 0.0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.progressBar = this.getProgressBar();
        Dimension dimension = this.progressBar.getPreferredSize();
        dimension.width = 400;
        this.progressBar.setPreferredSize(dimension);
        this.progressBar.setStringPainted(true);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 0.0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.progressBar, gridBagConstraints);
        this.messageAreaContainer = new JScrollPane(this.getMessageArea());
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 0, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.messageAreaContainer, gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(800, 500));
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new LoadHandler();
        }
        return this.handler;
    }

    public void setCurrentFilename(String string) {
        String string2;
        Graphics graphics = this.statusField.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string2 = string == null || string.length() == 0 ? "" : "Converting " + string);
        if (n >= this.statusField.getWidth()) {
            string2 = Utility.shortenString(fontMetrics, string2, this.statusField.getWidth());
        }
        TaskStrategyMessage.sendStatus(this, string2);
        this.currFilename = string;
    }

    public void addMessage(String string) {
        if (this.currFilename.length() > 0 && !this.currFilename.equals(this.lastNotifiedFilename)) {
            this.getMessageArea().append("\n" + this.currFilename + "\n");
            this.lastNotifiedFilename = this.currFilename;
        }
        this.getMessageArea().append(string + "\n");
    }

    public void setErrorState(boolean bl) {
        this.errorState = bl;
    }

    public boolean getErrorState() {
        return this.errorState;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    private JTextArea getMessageArea() {
        if (this.messageArea == null) {
            this.messageArea = new JTextArea();
            this.messageArea.setName("errorMessageBox");
            this.messageArea.setEditable(false);
            this.messageArea.setTabSize(8);
        }
        return this.messageArea;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object instanceof URI) {
            this.setCurrentFileCount(this.currentFileCount + 1);
            URI uRI = (URI)object;
            this.setCurrentFilename(uRI.toString());
        } else if (object instanceof Exception) {
            final Exception exception = (Exception)object;
            Runnable runnable = new Runnable(){

                public void run() {
                    RunConvertPanel.this.addMessage(exception.getMessage());
                    RunConvertPanel.this.setErrorState(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
            System.out.println("Persistence Observer: ERROR: " + exception.getMessage());
        } else {
            System.out.println("Persistence Observer: UNKNOWN: " + object);
        }
    }

    protected void setTotalFileCount(final int n) {
        this.totalFileCount = n;
        Runnable runnable = new Runnable(){

            public void run() {
                RunConvertPanel.this.getProgressBar().setMaximum(n);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void setCurrentFileCount(int n) {
        this.currentFileCount = n;
        this.getProgressBar().setValue(n);
    }

    @Override
    public String getConversionDecision(String string, List<String> list, List<String> list2) {
        final ConversionChoiceDialog conversionChoiceDialog = new ConversionChoiceDialog(null, string, list);
        int n = 0;
        Runnable runnable = new Runnable(){

            public void run() {
                conversionChoiceDialog.setVisible(true);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            Logging.errorPrint("Failed to display user choice, due to: ", interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Logging.errorPrint("Failed to display user choice, due to: ", invocationTargetException);
        }
        n = conversionChoiceDialog.getResult();
        return list2.get(n);
    }

    private class LoadHandler
    extends Handler {
        public LoadHandler() {
            this.setLevel(Logging.LST_WARNING);
        }

        public void close() throws SecurityException {
        }

        public void flush() {
        }

        public void publish(final LogRecord logRecord) {
            Runnable runnable = new Runnable(){

                public void run() {
                    RunConvertPanel.this.addMessage(logRecord.getLevel() + " " + logRecord.getMessage());
                    RunConvertPanel.this.setErrorState(true);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

