/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.gui.converter.panel.ConvertSubPanel;
import pcgen.gui.utils.Utility;

public class CampaignPanel
extends ConvertSubPanel {
    private List<Campaign> gameModeCampaigns;
    private String folderName;

    public boolean autoAdvance(CDOMObject cDOMObject) {
        return false;
    }

    public boolean returnAllowed() {
        return true;
    }

    public boolean performAnalysis(CDOMObject cDOMObject) {
        GameMode gameMode = cDOMObject.get(ObjectKey.GAME_MODE);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(gameMode.getAllowedModes());
        File file = cDOMObject.get(ObjectKey.DIRECTORY);
        this.folderName = file.toURI().toString();
        List<Campaign> list = Globals.getCampaignList();
        this.gameModeCampaigns = new ArrayList<Campaign>();
        for (Campaign campaign : list) {
            if (!campaign.isGameMode(arrayList) || !campaign.getSourceURI().toString().startsWith(this.folderName)) continue;
            this.gameModeCampaigns.add(campaign);
        }
        return false;
    }

    public void setupDisplay(JPanel jPanel, final CDOMObject cDOMObject) {
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Please select the Campaign(s) to Convert:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 1.0, 0.0, 2, 18);
        gridBagConstraints.insets = new Insets(25, 25, 5, 25);
        jPanel.add((Component)jLabel, gridBagConstraints);
        final CampaignTableModel campaignTableModel = new CampaignTableModel(this.gameModeCampaigns, this.folderName);
        final JTable jTable = new JTable(campaignTableModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                String string = String.valueOf(this.getValueAt(n, n2));
                return string;
            }
        };
        jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                cDOMObject.removeListFor(ListKey.CAMPAIGN);
                int[] nArray = jTable.getSelectedRows();
                if (nArray.length == 0) {
                    CampaignPanel.this.fireProgressEvent(1);
                } else {
                    for (int n : nArray) {
                        Campaign campaign = (Campaign)campaignTableModel.getValueAt(n, 0);
                        cDOMObject.addToListFor(ListKey.CAMPAIGN, campaign);
                    }
                    CampaignPanel.this.fireProgressEvent(0);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTable);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 0, 1.0, 1.0);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CampaignTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Campaign", "Location"};
        private Object[][] rowData;

        public CampaignTableModel(List<Campaign> list, String string) {
            this.rowData = new Object[list.size()][2];
            int n = 0;
            for (Campaign campaign : list) {
                this.rowData[n++] = new Object[]{campaign, campaign.getSourceURI().toString().substring(string.length())};
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n].toString();
        }

        @Override
        public int getRowCount() {
            return this.rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.rowData[n][n2];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }
}

