/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.converter;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import pcgen.base.util.DoubleKeyMap;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.cdom.enumeration.AspectName;
import pcgen.cdom.enumeration.Pantheon;
import pcgen.cdom.enumeration.RaceSubType;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SubClassCategory;
import pcgen.cdom.enumeration.SubRace;
import pcgen.cdom.enumeration.SubRegion;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.gui.converter.DefaultTokenProcessor;
import pcgen.gui.converter.event.TokenProcessEvent;
import pcgen.gui.converter.event.TokenProcessorPlugin;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenConverter {
    private static final DoubleKeyMap<Class<?>, String, TokenProcessorPlugin> map = new DoubleKeyMap();
    private static final DoubleKeyMap<Class<?>, String, Boolean> cached = new DoubleKeyMap();
    private static final DoubleKeyMapToList<Class<?>, String, TokenProcessorPlugin> tokenCache = new DoubleKeyMapToList();
    private static final DefaultTokenProcessor defaultProc = new DefaultTokenProcessor();

    public static void addToTokenMap(TokenProcessorPlugin tokenProcessorPlugin) {
        TokenProcessorPlugin tokenProcessorPlugin2 = map.put(tokenProcessorPlugin.getProcessedClass(), tokenProcessorPlugin.getProcessedToken(), tokenProcessorPlugin);
        if (tokenProcessorPlugin2 != null) {
            Logging.errorPrint("More than one Conversion token for " + tokenProcessorPlugin.getProcessedClass().getSimpleName() + " " + tokenProcessorPlugin.getProcessedToken() + " found");
        }
    }

    public static String process(TokenProcessEvent tokenProcessEvent) {
        Class<?> clazz = tokenProcessEvent.getPrimary().getClass();
        String string = tokenProcessEvent.getKey();
        List<TokenProcessorPlugin> list = TokenConverter.getTokens(clazz, string);
        String string2 = "";
        try {
            if (list != null) {
                for (TokenProcessorPlugin tokenProcessorPlugin : list) {
                    string2 = string2 + tokenProcessorPlugin.process(tokenProcessEvent);
                    if (!tokenProcessEvent.isConsumed()) continue;
                    break;
                }
            }
            if (!tokenProcessEvent.isConsumed()) {
                string2 = string2 + defaultProc.process(tokenProcessEvent);
            }
        }
        catch (Exception exception) {
            Logging.errorPrint("Parse of " + tokenProcessEvent.getKey() + ":" + tokenProcessEvent.getValue() + " failed");
            exception.printStackTrace();
        }
        return tokenProcessEvent.isConsumed() ? null : string2;
    }

    public static List<TokenProcessorPlugin> getTokens(Class<?> clazz, String string) {
        List<TokenProcessorPlugin> list = tokenCache.getListFor(clazz, string);
        if (!cached.containsKey(clazz, string)) {
            ConverterIterator converterIterator = new ConverterIterator(clazz, string);
            while (converterIterator.hasNext()) {
                TokenProcessorPlugin tokenProcessorPlugin = (TokenProcessorPlugin)converterIterator.next();
                tokenCache.addToListFor(clazz, string, tokenProcessorPlugin);
            }
            list = tokenCache.getListFor(clazz, string);
            cached.put(clazz, string, Boolean.TRUE);
        }
        return list;
    }

    public static void clearConstants() {
        AspectName.clearConstants();
        Pantheon.clearConstants();
        RaceSubType.clearConstants();
        RaceType.clearConstants();
        Region.clearConstants();
        SubClassCategory.clearConstants();
        SubRace.clearConstants();
        SubRegion.clearConstants();
        Type.clearConstants();
        VariableKey.clearConstants();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConverterIterator
    implements Iterator<TokenProcessorPlugin> {
        private Class<?> rootClass;
        private final String tokenKey;
        private TokenProcessorPlugin nextToken = null;
        private boolean needNewToken = true;

        public ConverterIterator(Class<?> clazz, String string) {
            this.rootClass = clazz;
            this.tokenKey = string;
        }

        @Override
        public boolean hasNext() {
            this.setNextToken();
            return !this.needNewToken;
        }

        protected void setNextToken() {
            if (this.needNewToken) {
                this.nextToken = null;
                while (this.nextToken == null && this.rootClass != null) {
                    this.nextToken = this.grabToken(this.rootClass, this.tokenKey);
                    this.rootClass = this.rootClass.getSuperclass();
                }
                this.needNewToken = this.nextToken == null;
            }
        }

        protected TokenProcessorPlugin grabToken(Class<?> clazz, String string) {
            return (TokenProcessorPlugin)map.get(clazz, string);
        }

        @Override
        public TokenProcessorPlugin next() {
            this.setNextToken();
            if (this.needNewToken) {
                throw new NoSuchElementException();
            }
            this.needNewToken = true;
            return this.nextToken;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator does not support remove");
        }
    }
}

